/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.common;

import com.google.common.base.Preconditions;
import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.mobtalker.mobtalker2.MobTalker2;
import net.mobtalker.mobtalker2.common.IMobTalkerProxy;
import net.mobtalker.mobtalker2.common.MobTalkerConfig;
import net.mobtalker.mobtalker2.common.MobTalkerItems;
import net.mobtalker.mobtalker2.common.network.NetworkManager;
import net.mobtalker.mobtalker2.launch.FingerprintViolationException;
import net.mobtalker.mobtalker2.server.ServerInteractionHandler;
import net.mobtalker.mobtalker2.server.command.MobTalkerCommand;
import net.mobtalker.mobtalker2.server.interaction.IInteractionAdapter;
import net.mobtalker.mobtalker2.server.interaction.InteractionRegistry;
import net.mobtalker.mobtalker2.server.script.InteractionScriptFactory;
import net.mobtalker.mobtalker2.server.scriptpack.ScriptPackRepository;
import net.mobtalker.mobtalker2.util.EntityUtil;
import net.mobtalker.mobtalker2.util.logging.MobTalkerLog;

public abstract class MobTalkerCommonProxy
implements IMobTalkerProxy {
    private static final String LOG_TAG = "Proxy";

    @Override
    public void onPreInit(FMLPreInitializationEvent event) {
        MobTalkerLog.trace(LOG_TAG, "onPreInit");
        File configFile = new File(event.getModConfigurationDirectory(), "MobTalker2.cfg");
        MobTalkerConfig.init(configFile);
        NetworkManager.load();
        MobTalkerItems.register();
    }

    @Override
    public void onInit(FMLInitializationEvent event) {
        MobTalkerLog.trace(LOG_TAG, "onInit");
        this.registerRecipes();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)MobTalker2.instance, (IGuiHandler)this);
    }

    @Override
    public void onPostInit(FMLPostInitializationEvent event) {
        MobTalkerLog.trace(LOG_TAG, "onPostInit");
    }

    @Override
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        if (event.expectedFingerprint.equals("@FINGERPRINT@")) {
            return;
        }
        throw new FingerprintViolationException();
    }

    @Override
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        MobTalkerLog.trace(LOG_TAG, "onServerAboutToStart");
        ScriptPackRepository.load();
        InteractionScriptFactory.load();
        InteractionScriptFactory.precompileScripts();
        InteractionRegistry.load();
    }

    @Override
    public void onServerStarting(FMLServerStartingEvent event) {
        MobTalkerLog.trace(LOG_TAG, "onServerStarting");
        ServerCommandManager cmdMngr = (ServerCommandManager)event.getServer().func_71187_D();
        cmdMngr.func_71560_a((ICommand)new MobTalkerCommand());
    }

    @Override
    public void onServerStopping(FMLServerStoppingEvent event) {
        MobTalkerLog.trace(LOG_TAG, "onServerStopping");
        InteractionRegistry.unload();
        InteractionScriptFactory.unload();
        ScriptPackRepository.unload();
    }

    private void registerRecipes() {
        ItemStack stickStack = new ItemStack(Items.field_151055_y);
        ItemStack glowStoneStack = new ItemStack(Blocks.field_150426_aN);
        ItemStack mobTalkerStack = new ItemStack(MobTalkerItems.talker);
        GameRegistry.addRecipe((ItemStack)mobTalkerStack, (Object[])new Object[]{"x", "y", Character.valueOf('x'), glowStoneStack, Character.valueOf('y'), stickStack});
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        throw new AssertionError();
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        IInteractionAdapter adapter = InteractionRegistry.instance().getAdapter(player);
        Preconditions.checkState((adapter != null ? 1 : 0) != 0, (String)"Tried to open gui for '%s', who does not have a partner", (Object[])new Object[]{EntityUtil.getName(player)});
        if (id == 1) {
            return new ServerInteractionHandler(adapter);
        }
        throw new AssertionError((Object)("Tried to open unknown gui id '" + id + "' for '" + EntityUtil.getName(player) + "'"));
    }
}

