/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.client.renderer.texture;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.util.ResourceLocation;
import net.mobtalker.mobtalker2.util.mgt.Dimension;
import org.apache.logging.log4j.LogManager;

@SideOnly(value=Side.CLIENT)
public class MobTalkerTexture
extends AbstractTexture {
    private final ResourceLocation _textureLocation;
    private Dimension _size;

    public MobTalkerTexture(ResourceLocation resourceLocation) {
        this._textureLocation = resourceLocation;
    }

    public void func_110551_a(IResourceManager resourceManager) throws IOException {
        BufferedImage image;
        IResource resource = resourceManager.func_110536_a(this._textureLocation);
        try (InputStream stream = resource.func_110527_b();){
            image = ImageIO.read(stream);
        }
        boolean blur = false;
        boolean clamp = false;
        if (resource.func_110528_c()) {
            try {
                TextureMetadataSection meta = (TextureMetadataSection)resource.func_110526_a("texture");
                if (meta != null) {
                    blur = meta.func_110479_a();
                    clamp = meta.func_110480_b();
                }
            }
            catch (RuntimeException ex) {
                LogManager.getLogger().warn("Failed reading metadata of: " + this._textureLocation, (Throwable)ex);
            }
        }
        this._size = MobTalkerTexture.scaleToBase(image.getWidth(), image.getHeight(), 256.0f);
        int textureID = this.func_110552_b();
        TextureUtil.func_110991_a((int)textureID, (int)image.getWidth(), (int)image.getHeight());
        TextureUtil.func_110995_a((int)textureID, (BufferedImage)image, (int)0, (int)0, (boolean)blur, (boolean)clamp);
    }

    private static Dimension scaleToBase(int width, int height, float base) {
        int max = Math.max(width, height);
        float scale = base / (float)max;
        width = (int)((float)width * scale);
        height = (int)((float)height * scale);
        return new Dimension(width, height);
    }

    public Dimension getSize() {
        return this._size;
    }
}

