/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.client.network;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.mobtalker.mobtalker2.client.ClientInteractionHandler;
import net.mobtalker.mobtalker2.common.network.ClientToServerMessage;
import net.mobtalker.mobtalker2.common.network.MessageCancelInteraction;
import net.mobtalker.mobtalker2.common.network.MessageHideTexture;
import net.mobtalker.mobtalker2.common.network.MessageShowMenu;
import net.mobtalker.mobtalker2.common.network.MessageShowMenuResponse;
import net.mobtalker.mobtalker2.common.network.MessageShowScene;
import net.mobtalker.mobtalker2.common.network.MessageShowSprite;
import net.mobtalker.mobtalker2.common.network.MessageShowText;
import net.mobtalker.mobtalker2.common.network.MessageShowTextResponse;
import net.mobtalker.mobtalker2.common.network.NetworkManager;
import net.mobtalker.mobtalker2.common.network.ServerToClientMessage;
import net.mobtalker.mobtalker2.util.mgt.Point;

public class ClientMessageHandler {
    private static ClientMessageHandler instance = new ClientMessageHandler();

    public static ClientMessageHandler instance() {
        return instance;
    }

    public void sendCancelInteraction() {
        NetworkManager.sendToServer(new MessageCancelInteraction());
    }

    public void sendTextFinished() {
        NetworkManager.sendToServer(new MessageShowTextResponse());
    }

    public void sendChoiceMade(int choice) {
        NetworkManager.sendToServer(new MessageShowMenuResponse().setChoice(choice));
    }

    public void onShowText(MessageShowText msg) {
        ClientInteractionHandler handler = ClientMessageHandler.getInteractionHandler();
        handler.displayName(msg.getName());
        handler.displayText(msg.getText(), msg.isLast());
    }

    public void onShowMenu(MessageShowMenu msg) {
        ClientInteractionHandler handler = ClientMessageHandler.getInteractionHandler();
        handler.displayChoice(msg.getCaption(), msg.getChoices());
    }

    public void onShowSprite(MessageShowSprite msg) {
        ClientInteractionHandler handler = ClientMessageHandler.getInteractionHandler();
        handler.showSprite(msg.getGroup(), msg.getPath(), msg.getPosition(), new Point(msg.getOffsetX(), msg.getOffsetY()));
    }

    public void onShowScene(MessageShowScene msg) {
        ClientInteractionHandler handler = ClientMessageHandler.getInteractionHandler();
        handler.showScene(msg.getPath(), msg.getMode());
    }

    public void onHideTexture(MessageHideTexture msg) {
        ClientInteractionHandler handler = ClientMessageHandler.getInteractionHandler();
        handler.hideTexture(msg.getGroup());
    }

    public static ClientInteractionHandler getInteractionHandler() {
        EntityClientPlayerMP player = FMLClientHandler.instance().getClientPlayerEntity();
        if (player.field_71070_bA instanceof ClientInteractionHandler) {
            return (ClientInteractionHandler)player.field_71070_bA;
        }
        throw new IllegalStateException("open container is not " + ClientInteractionHandler.class.getName() + " but " + player.field_71070_bA.getClass().getName());
    }

    public static abstract class Delegator<REQ extends ServerToClientMessage>
    implements IMessageHandler<REQ, ClientToServerMessage> {
    }
}

