/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.tree.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import org.abego.treelayout.Configuration;
import org.abego.treelayout.NodeExtentProvider;
import org.abego.treelayout.TreeLayout;
import org.antlr.v4.runtime.misc.JFileChooserConfirmOverwrite;
import org.antlr.v4.runtime.misc.Utils;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.Tree;
import org.antlr.v4.runtime.tree.Trees;
import org.antlr.v4.runtime.tree.gui.TreeLayoutAdaptor;
import org.antlr.v4.runtime.tree.gui.TreeTextProvider;

public class TreeViewer
extends JComponent {
    private static Color LIGHT_RED = new Color(244, 213, 211);
    private TreeTextProvider treeTextProvider;
    private TreeLayout<Tree> treeLayout;
    private String fontName = "Helvetica";
    private int fontSize = 11;
    protected Font font = new Font(this.fontName, 0, this.fontSize);
    private double gapBetweenLevels = 17.0;
    private double gapBetweenNodes = 7.0;
    protected int nodeWidthPadding = 2;
    private double scale = 1.0;
    private Color textColor = Color.black;

    public TreeViewer(List<String> ruleNames, Tree tree) {
        List<String> list = ruleNames;
        this.treeTextProvider = new DefaultTreeTextProvider(list);
        if (tree != null) {
            this.setTree(tree);
        }
        this.setFont(this.font);
    }

    private void updatePreferredSize() {
        TreeViewer treeViewer = this;
        Dimension dimension = treeViewer.treeLayout.getBounds().getBounds().getSize();
        this.setPreferredSize(new Dimension((int)((double)dimension.width * treeViewer.scale), (int)((double)dimension.height * treeViewer.scale)));
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().validate();
        }
        this.repaint();
    }

    private void paintEdges(Graphics g, Tree parent) {
        if (!this.treeLayout.getTree().isLeaf(parent)) {
            BasicStroke stroke = new BasicStroke(1.0f, 1, 1);
            ((Graphics2D)g).setStroke(stroke);
            Rectangle2D.Double parentBounds = this.getBoundsOfNode(parent);
            double x1 = parentBounds.getCenterX();
            double y1 = parentBounds.getMaxY();
            for (Tree child : this.treeLayout.getTree().getChildren(parent)) {
                Rectangle2D.Double childBounds = this.getBoundsOfNode(child);
                double x2 = childBounds.getCenterX();
                double y2 = childBounds.getMinY();
                g.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
                this.paintEdges(g, child);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.treeLayout == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.paintEdges(g, this.treeLayout.getTree().getRoot());
        Iterator<Tree> i$ = this.treeLayout.getNodeBounds().keySet().iterator();
        while (i$.hasNext()) {
            Tree Tree2;
            Tree tree = Tree2 = i$.next();
            Graphics graphics = g;
            TreeViewer treeViewer = this;
            Rectangle2D.Double double_ = treeViewer.getBoundsOfNode(tree);
            if (tree instanceof ErrorNode) {
                if (tree instanceof ErrorNode) {
                    graphics.setColor(LIGHT_RED);
                } else {
                    graphics.setColor(null);
                }
                graphics.fillRoundRect((int)double_.x, (int)double_.y, (int)double_.width - 1, (int)double_.height - 1, 0, 0);
            }
            graphics.setColor(treeViewer.textColor);
            String[] stringArray = treeViewer.getText(tree).split("\n");
            FontMetrics fontMetrics = treeViewer.getFontMetrics(treeViewer.font);
            int n = (int)double_.x + treeViewer.nodeWidthPadding;
            int n2 = (int)double_.y + fontMetrics.getAscent() + fontMetrics.getLeading() + 1;
            for (int i = 0; i < stringArray.length; ++i) {
                int n3 = n2;
                int n4 = n;
                String string = stringArray[i];
                Graphics graphics2 = graphics;
                string = Utils.escapeWhitespace(string, true);
                graphics2.drawString(string, n4, n3);
                n2 += fontMetrics.getHeight();
            }
        }
    }

    @Override
    protected Graphics getComponentGraphics(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.scale(this.scale, this.scale);
        return super.getComponentGraphics(g2d);
    }

    protected static JDialog showInDialog(TreeViewer viewer) {
        JDialog dialog = new JDialog();
        dialog.setTitle("Parse Tree Inspector");
        JPanel mainPane = new JPanel(new BorderLayout(5, 5));
        JPanel contentPane = new JPanel(new BorderLayout(0, 0));
        ((Component)contentPane).setBackground(Color.white);
        JScrollPane scrollPane = new JScrollPane(viewer);
        contentPane.add((Component)scrollPane, "Center");
        JPanel wrapper = new JPanel(new FlowLayout());
        JPanel bottomPanel = new JPanel(new BorderLayout(0, 0));
        contentPane.add((Component)bottomPanel, "South");
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(dialog){
            private /* synthetic */ JDialog val$dialog;
            {
                this.val$dialog = jDialog;
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                this.val$dialog.setVisible(false);
                this.val$dialog.dispose();
            }
        });
        wrapper.add(ok);
        JButton png = new JButton("png");
        png.addActionListener(new ActionListener(viewer, dialog){
            private /* synthetic */ TreeViewer val$viewer;
            private /* synthetic */ JDialog val$dialog;
            {
                this.val$viewer = treeViewer;
                this.val$dialog = jDialog;
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                TreeViewer.access$000(this.val$viewer, this.val$dialog);
            }
        });
        wrapper.add(png);
        bottomPanel.add((Component)wrapper, "South");
        int sliderValue = (int)((viewer.scale - 1.0) * 1000.0);
        JSlider scaleSlider = new JSlider(0, -999, 1000, sliderValue);
        scaleSlider.addChangeListener(new ChangeListener(scaleSlider, viewer){
            private /* synthetic */ JSlider val$scaleSlider;
            private /* synthetic */ TreeViewer val$viewer;
            {
                this.val$scaleSlider = jSlider;
                this.val$viewer = treeViewer;
            }

            @Override
            public final void stateChanged(ChangeEvent e) {
                int v = this.val$scaleSlider.getValue();
                this.val$viewer.setScale((double)v / 1000.0 + 1.0);
            }
        });
        bottomPanel.add((Component)scaleSlider, "Center");
        JPanel treePanel = new JPanel(new BorderLayout(5, 5));
        EmptyIcon empty = new EmptyIcon(0);
        UIManager.put("Tree.closedIcon", empty);
        UIManager.put("Tree.openIcon", empty);
        UIManager.put("Tree.leafIcon", empty);
        Tree parseTreeRoot = viewer.treeLayout.getTree().getRoot();
        TreeNodeWrapper nodeRoot = new TreeNodeWrapper(parseTreeRoot, viewer);
        TreeViewer.fillTree(nodeRoot, parseTreeRoot, viewer);
        JTree tree = new JTree(nodeRoot);
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeSelectionListener(new TreeSelectionListener(viewer){
            private /* synthetic */ TreeViewer val$viewer;
            {
                this.val$viewer = treeViewer;
            }

            @Override
            public final void valueChanged(TreeSelectionEvent e) {
                TreeNodeWrapper treeNode = (TreeNodeWrapper)((JTree)e.getSource()).getSelectionPath().getLastPathComponent();
                this.val$viewer.setTree((Tree)treeNode.getUserObject());
            }
        });
        treePanel.add(new JScrollPane(tree));
        JSplitPane splitPane = new JSplitPane(1, treePanel, contentPane);
        mainPane.add((Component)splitPane, "Center");
        dialog.setContentPane(mainPane);
        dialog.setDefaultCloseOperation(2);
        dialog.setPreferredSize(new Dimension(600, 500));
        dialog.pack();
        splitPane.setDividerLocation(0.33);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        return dialog;
    }

    private static File generateNonExistingPngFile() {
        File pngFile = new File(".", "antlr4_parse_tree.png");
        int counter = 1;
        while (pngFile.exists()) {
            pngFile = new File(".", "antlr4_parse_tree_" + counter + ".png");
            ++counter;
        }
        return pngFile;
    }

    private static void fillTree(TreeNodeWrapper node, Tree tree, TreeViewer viewer) {
        if (tree == null) {
            return;
        }
        for (int i = 0; i < tree.getChildCount(); ++i) {
            Tree childTree = tree.getChild(i);
            TreeNodeWrapper childNode = new TreeNodeWrapper(childTree, viewer);
            node.add(childNode);
            TreeViewer.fillTree(childNode, childTree, viewer);
        }
    }

    public final Future<JDialog> open() {
        TreeViewer viewer = this;
        viewer.setScale(1.5);
        Callable<JDialog> callable = new Callable<JDialog>(){
            JDialog result;
        };
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<JDialog> future = executor.submit(callable);
            return future;
        }
        finally {
            executor.shutdown();
        }
    }

    private Rectangle2D.Double getBoundsOfNode(Tree node) {
        return this.treeLayout.getNodeBounds().get(node);
    }

    protected final String getText(Tree tree) {
        return Utils.escapeWhitespace(this.treeTextProvider.getText(tree), true);
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    public final void setTree(Tree root) {
        if (root != null) {
            this.treeLayout = new TreeLayout<Tree>(new TreeLayoutAdaptor(root), new VariableExtentProvide(this), new Configuration(this.gapBetweenLevels, this.gapBetweenNodes, 0));
            this.updatePreferredSize();
            return;
        }
        this.treeLayout = null;
        this.repaint();
    }

    public final void setScale(double scale) {
        if (scale <= 0.0) {
            scale = 1.0;
        }
        this.scale = scale;
        this.updatePreferredSize();
    }

    static /* synthetic */ void access$000(TreeViewer x0, JDialog x1) {
        JDialog jDialog = x1;
        TreeViewer treeViewer = x0;
        BufferedImage bufferedImage = new BufferedImage(treeViewer.getSize().width, treeViewer.getSize().height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        treeViewer.paint(graphics2D);
        graphics2D.dispose();
        try {
            File file = TreeViewer.generateNonExistingPngFile();
            JFileChooserConfirmOverwrite jFileChooserConfirmOverwrite = new JFileChooserConfirmOverwrite();
            jFileChooserConfirmOverwrite.setCurrentDirectory(file.getParentFile());
            jFileChooserConfirmOverwrite.setSelectedFile(file);
            FileFilter fileFilter = new FileFilter(){

                @Override
                public final boolean accept(File pathname) {
                    if (pathname.isFile()) {
                        return pathname.getName().toLowerCase().endsWith(".png");
                    }
                    return true;
                }

                @Override
                public final String getDescription() {
                    return "PNG Files (*.png)";
                }
            };
            jFileChooserConfirmOverwrite.addChoosableFileFilter(fileFilter);
            jFileChooserConfirmOverwrite.setFileFilter(fileFilter);
            if (jFileChooserConfirmOverwrite.showSaveDialog(jDialog) == 0) {
                File file2 = jFileChooserConfirmOverwrite.getSelectedFile();
                ImageIO.write((RenderedImage)bufferedImage, "png", file2);
                try {
                    Desktop.getDesktop().open(file2.getParentFile());
                    return;
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(jDialog, "Saved PNG to: " + file2.getAbsolutePath());
                    exception.printStackTrace();
                }
            }
            return;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(jDialog, "Could not export to PNG: " + exception.getMessage(), "Error", 0);
            exception.printStackTrace();
            return;
        }
    }

    static class EmptyIcon
    implements Icon {
        private EmptyIcon() {
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 0;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        /* synthetic */ EmptyIcon(byte by) {
            this();
        }
    }

    static class TreeNodeWrapper
    extends DefaultMutableTreeNode {
        private TreeViewer viewer;

        TreeNodeWrapper(Tree tree, TreeViewer viewer) {
            super(tree);
            this.viewer = viewer;
        }

        @Override
        public String toString() {
            return this.viewer.getText((Tree)this.getUserObject());
        }
    }

    public static class VariableExtentProvide
    implements NodeExtentProvider<Tree> {
        private TreeViewer viewer;

        public VariableExtentProvide(TreeViewer viewer) {
            this.viewer = viewer;
        }
    }

    public static class DefaultTreeTextProvider
    implements TreeTextProvider {
        private final List<String> ruleNames;

        public DefaultTreeTextProvider(List<String> ruleNames) {
            this.ruleNames = ruleNames;
        }

        @Override
        public final String getText(Tree node) {
            return String.valueOf(Trees.getNodeText(node, this.ruleNames));
        }
    }
}

