/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.antlr.v4.runtime.misc.IntSet;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.MurmurHash;

public class IntervalSet
implements IntSet {
    private List<Interval> intervals = new ArrayList<Interval>(0);
    private boolean readonly;

    public static IntervalSet of(int a) {
        IntervalSet s = new IntervalSet();
        s.add(a);
        return s;
    }

    public static IntervalSet of(int a, int b) {
        IntervalSet s = new IntervalSet();
        s.add(a, b);
        return s;
    }

    public final void add(int el) {
        if (this.readonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        this.add(el, el);
    }

    public final void add(int a, int b) {
        this.add(Interval.of(a, b));
    }

    private void add(Interval addition) {
        if (this.readonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        if (addition.b < addition.a) {
            return;
        }
        ListIterator<Interval> iter = this.intervals.listIterator();
        while (iter.hasNext()) {
            Interval r = iter.next();
            if (addition.equals(r)) {
                return;
            }
            if (addition.adjacent(r) || !addition.disjoint(r)) {
                Interval next;
                Interval bigger = addition.union(r);
                iter.set(bigger);
                while (iter.hasNext() && (bigger.adjacent(next = iter.next()) || !bigger.disjoint(next))) {
                    iter.remove();
                    iter.previous();
                    iter.set(bigger.union(next));
                    iter.next();
                }
                return;
            }
            if (!addition.startsBeforeDisjoint(r)) continue;
            iter.previous();
            iter.add(addition);
            return;
        }
        this.intervals.add(addition);
    }

    public final IntervalSet addAll(IntSet set) {
        if (set == null) {
            return this;
        }
        if (!(set instanceof IntervalSet)) {
            throw new IllegalArgumentException("can't add non IntSet (" + set.getClass().getName() + ") to IntervalSet");
        }
        IntervalSet other = (IntervalSet)set;
        int n = other.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval I = other.intervals.get(i);
            this.add(I.a, I.b);
        }
        return this;
    }

    public final IntervalSet complement(IntSet vocabulary) {
        IntervalSet vocabularyIS;
        if (vocabulary == null) {
            return null;
        }
        if (!(vocabulary instanceof IntervalSet)) {
            throw new IllegalArgumentException("can't complement with non IntervalSet (" + vocabulary.getClass().getName() + ")");
        }
        IntervalSet intervalSet = vocabularyIS = (IntervalSet)vocabulary;
        int maxElement = vocabularyIS.isNil() ? 0 : intervalSet.intervals.get((int)(intervalSet.intervals.size() - 1)).b;
        IntervalSet compl = new IntervalSet();
        int n = this.intervals.size();
        if (n == 0) {
            return compl;
        }
        Interval first = this.intervals.get(0);
        if (first.a > 0) {
            IntervalSet a = IntervalSet.of(0, first.a - 1).and(vocabularyIS);
            compl.addAll(a);
        }
        for (int i = 1; i < n; ++i) {
            Interval previous = this.intervals.get(i - 1);
            Interval current = this.intervals.get(i);
            IntervalSet a = IntervalSet.of(previous.b + 1, current.a - 1).and(vocabularyIS);
            compl.addAll(a);
        }
        Interval last = this.intervals.get(n - 1);
        if (last.b < maxElement) {
            IntervalSet a = IntervalSet.of(last.b + 1, maxElement).and(vocabularyIS);
            compl.addAll(a);
        }
        return compl;
    }

    private IntervalSet and(IntSet other) {
        if (other == null) {
            return null;
        }
        List<Interval> myIntervals = this.intervals;
        List<Interval> theirIntervals = ((IntervalSet)other).intervals;
        IntervalSet intersection = null;
        int mySize = myIntervals.size();
        int theirSize = theirIntervals.size();
        int i = 0;
        int j = 0;
        while (i < mySize && j < theirSize) {
            Interval theirs;
            Interval mine = myIntervals.get(i);
            if (mine.startsBeforeDisjoint(theirs = theirIntervals.get(j))) {
                ++i;
                continue;
            }
            if (theirs.startsBeforeDisjoint(mine)) {
                ++j;
                continue;
            }
            if (mine.properlyContains(theirs)) {
                if (intersection == null) {
                    intersection = new IntervalSet();
                }
                intersection.add(mine.intersection(theirs));
                ++j;
                continue;
            }
            if (theirs.properlyContains(mine)) {
                if (intersection == null) {
                    intersection = new IntervalSet();
                }
                intersection.add(mine.intersection(theirs));
                ++i;
                continue;
            }
            if (mine.disjoint(theirs)) continue;
            if (intersection == null) {
                intersection = new IntervalSet();
            }
            intersection.add(mine.intersection(theirs));
            if (mine.startsAfterNonDisjoint(theirs)) {
                ++j;
                continue;
            }
            if (!theirs.startsAfterNonDisjoint(mine)) continue;
            ++i;
        }
        if (intersection == null) {
            return new IntervalSet();
        }
        return intersection;
    }

    public final boolean contains(int el) {
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval I = this.intervals.get(i);
            int a = I.a;
            int b = I.b;
            if (el < a) break;
            if (el < a || el > b) continue;
            return true;
        }
        return false;
    }

    private boolean isNil() {
        return this.intervals == null || this.intervals.isEmpty();
    }

    public final int getMinElement() {
        if (this.isNil()) {
            return 0;
        }
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval I = this.intervals.get(i);
            int a = I.a;
            int b = I.b;
            for (int v = a; v <= b; ++v) {
                if (v < 0) continue;
                return v;
            }
        }
        return 0;
    }

    public int hashCode() {
        int hash = 0;
        for (Interval I : this.intervals) {
            hash = MurmurHash.update(MurmurHash.update(hash, I.a), I.b);
        }
        return MurmurHash.finish(hash, this.intervals.size() << 1);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IntervalSet)) {
            return false;
        }
        IntervalSet other = (IntervalSet)obj;
        return this.intervals.equals(other.intervals);
    }

    public String toString() {
        IntervalSet intervalSet = this;
        StringBuilder stringBuilder = new StringBuilder();
        if (intervalSet.intervals == null || intervalSet.intervals.isEmpty()) {
            return "{}";
        }
        if (intervalSet.size() > 1) {
            stringBuilder.append("{");
        }
        Iterator<Interval> iterator = intervalSet.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval = iterator.next();
            int n = interval.a;
            int n2 = interval.b;
            if (n == n2) {
                if (n == -1) {
                    stringBuilder.append("<EOF>");
                } else {
                    stringBuilder.append(n);
                }
            } else {
                stringBuilder.append(n).append("..").append(n2);
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        if (intervalSet.size() > 1) {
            stringBuilder.append("}");
        }
        return stringBuilder.toString();
    }

    public final String toString(String[] tokenNames) {
        StringBuilder buf = new StringBuilder();
        if (this.intervals == null || this.intervals.isEmpty()) {
            return "{}";
        }
        if (this.size() > 1) {
            buf.append("{");
        }
        Iterator<Interval> iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval I = iter.next();
            int a = I.a;
            int b = I.b;
            if (a == b) {
                buf.append(IntervalSet.elementName(tokenNames, a));
            } else {
                for (int i = a; i <= b; ++i) {
                    if (i > a) {
                        buf.append(", ");
                    }
                    buf.append(IntervalSet.elementName(tokenNames, i));
                }
            }
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        if (this.size() > 1) {
            buf.append("}");
        }
        return buf.toString();
    }

    private static String elementName(String[] tokenNames, int a) {
        if (a == -1) {
            return "<EOF>";
        }
        if (a == -2) {
            return "<EPSILON>";
        }
        return tokenNames[a];
    }

    public final int size() {
        int n = 0;
        int numIntervals = this.intervals.size();
        if (numIntervals == 1) {
            Interval firstInterval = this.intervals.get(0);
            return firstInterval.b - firstInterval.a + 1;
        }
        for (int i = 0; i < numIntervals; ++i) {
            Interval I = this.intervals.get(i);
            n += I.b - I.a + 1;
        }
        return n;
    }

    public final void remove$13462e() {
        if (this.readonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval I = this.intervals.get(i);
            int a = I.a;
            int b = I.b;
            if (-2 < a) break;
            if (-2 == a && -2 == b) {
                this.intervals.remove(i);
                return;
            }
            if (-2 == a) {
                ++I.a;
                return;
            }
            if (-2 == b) {
                --I.b;
                return;
            }
            if (-2 <= a || -2 >= b) continue;
            int oldb = I.b;
            I.b = -3;
            this.add(-1, oldb);
        }
    }

    public final void setReadonly$1385ff() {
        this.readonly = true;
    }

    static {
        IntervalSet.of(0, 65534);
        new IntervalSet();
    }
}

