/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime;

import java.util.Arrays;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.WritableToken;
import org.antlr.v4.runtime.misc.Interval;

public class UnbufferedTokenStream<T extends Token>
implements TokenStream {
    private TokenSource tokenSource;
    private Token[] tokens;
    private int n;
    private int p = 0;
    private int numMarkers = 0;
    private Token lastToken;
    private Token lastTokenBufferStart;
    private int currentTokenIndex = 0;

    public UnbufferedTokenStream(TokenSource tokenSource) {
        this(tokenSource, 0);
    }

    private UnbufferedTokenStream(TokenSource tokenSource, byte by) {
        this.tokenSource = tokenSource;
        this.tokens = new Token[256];
        this.n = 0;
        this.fill(1);
    }

    @Override
    public final Token get(int i) {
        int bufferStartIndex = this.getBufferStartIndex();
        if (i < bufferStartIndex || i >= bufferStartIndex + this.n) {
            throw new IndexOutOfBoundsException("get(" + i + ") outside buffer: " + bufferStartIndex + ".." + (bufferStartIndex + this.n));
        }
        return this.tokens[i - bufferStartIndex];
    }

    @Override
    public final Token LT(int i) {
        if (i == -1) {
            return this.lastToken;
        }
        this.sync(i);
        int index = this.p + i - 1;
        if (index < 0) {
            throw new IndexOutOfBoundsException("LT(" + i + ") gives negative index");
        }
        if (index >= this.n) {
            assert (this.n > 0 && this.tokens[this.n - 1].getType() == -1);
            return this.tokens[this.n - 1];
        }
        return this.tokens[index];
    }

    @Override
    public final int LA(int i) {
        return this.LT(i).getType();
    }

    @Override
    public final TokenSource getTokenSource() {
        return this.tokenSource;
    }

    @Override
    public final String getText(Token start, Token stop) {
        Interval interval = Interval.of(start.getTokenIndex(), stop.getTokenIndex());
        UnbufferedTokenStream unbufferedTokenStream = this;
        int n = unbufferedTokenStream.getBufferStartIndex();
        int n2 = n + unbufferedTokenStream.tokens.length - 1;
        int n3 = interval.a;
        int n4 = interval.b;
        if (n3 < n || n4 > n2) {
            throw new UnsupportedOperationException("interval " + interval + " not in token buffer window: " + n + ".." + n2);
        }
        int n5 = n3 - n;
        int n6 = n4 - n;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n5; i <= n6; ++i) {
            Token token = unbufferedTokenStream.tokens[i];
            stringBuilder.append(token.getText());
        }
        return stringBuilder.toString();
    }

    @Override
    public final void consume() {
        if (this.LA(1) == -1) {
            throw new IllegalStateException("cannot consume EOF");
        }
        this.lastToken = this.tokens[this.p];
        if (this.p == this.n - 1 && this.numMarkers == 0) {
            this.n = 0;
            this.p = -1;
            this.lastTokenBufferStart = this.lastToken;
        }
        ++this.p;
        ++this.currentTokenIndex;
        this.sync(1);
    }

    private void sync(int want) {
        int need = this.p + want - 1 - this.n + 1;
        if (need > 0) {
            this.fill(need);
        }
    }

    private int fill(int n) {
        for (int i = 0; i < n; ++i) {
            Token t;
            if (this.n > 0 && this.tokens[this.n - 1].getType() == -1) {
                return i;
            }
            Token token = t = this.tokenSource.nextToken();
            UnbufferedTokenStream unbufferedTokenStream = this;
            if (unbufferedTokenStream.n >= unbufferedTokenStream.tokens.length) {
                unbufferedTokenStream.tokens = Arrays.copyOf(unbufferedTokenStream.tokens, unbufferedTokenStream.tokens.length << 1);
            }
            if (token instanceof WritableToken) {
                ((WritableToken)token).setTokenIndex(unbufferedTokenStream.getBufferStartIndex() + unbufferedTokenStream.n);
            }
            unbufferedTokenStream.tokens[unbufferedTokenStream.n++] = token;
        }
        return n;
    }

    @Override
    public final int mark() {
        if (this.numMarkers == 0) {
            this.lastTokenBufferStart = this.lastToken;
        }
        int mark = -this.numMarkers - 1;
        ++this.numMarkers;
        return mark;
    }

    @Override
    public final void release(int marker) {
        int expectedMark = -this.numMarkers;
        if (marker != expectedMark) {
            throw new IllegalStateException("release() called with an invalid marker.");
        }
        --this.numMarkers;
        if (this.numMarkers == 0) {
            if (this.p > 0) {
                System.arraycopy(this.tokens, this.p, this.tokens, 0, this.n - this.p);
                this.n -= this.p;
                this.p = 0;
            }
            this.lastTokenBufferStart = this.lastToken;
        }
    }

    @Override
    public final int index() {
        return this.currentTokenIndex;
    }

    @Override
    public final void seek(int index) {
        int bufferStartIndex;
        int i;
        if (index == this.currentTokenIndex) {
            return;
        }
        if (index > this.currentTokenIndex) {
            this.sync(index - this.currentTokenIndex);
            index = Math.min(index, this.getBufferStartIndex() + this.n - 1);
        }
        if ((i = index - (bufferStartIndex = this.getBufferStartIndex())) < 0) {
            throw new IllegalArgumentException("cannot seek to negative index " + index);
        }
        if (i >= this.n) {
            throw new UnsupportedOperationException("seek to index outside buffer: " + index + " not in " + bufferStartIndex + ".." + (bufferStartIndex + this.n));
        }
        this.p = i;
        this.currentTokenIndex = index;
        if (this.p == 0) {
            this.lastToken = this.lastTokenBufferStart;
            return;
        }
        this.lastToken = this.tokens[this.p - 1];
    }

    @Override
    public final int size() {
        throw new UnsupportedOperationException("Unbuffered stream cannot know its size");
    }

    @Override
    public final String getSourceName() {
        return this.tokenSource.getSourceName();
    }

    private int getBufferStartIndex() {
        return this.currentTokenIndex - this.p;
    }
}

