/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime;

import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.FailedPredicateException;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.RuleTransition;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.runtime.misc.Pair;

public class DefaultErrorStrategy
implements ANTLRErrorStrategy {
    protected boolean errorRecoveryMode = false;
    protected int lastErrorIndex = -1;
    protected IntervalSet lastErrorStates;

    @Override
    public void reset(Parser recognizer) {
        this.endErrorCondition(recognizer);
    }

    protected void beginErrorCondition(Parser recognizer) {
        this.errorRecoveryMode = true;
    }

    @Override
    public boolean inErrorRecoveryMode(Parser recognizer) {
        return this.errorRecoveryMode;
    }

    protected void endErrorCondition(Parser recognizer) {
        this.errorRecoveryMode = false;
        this.lastErrorStates = null;
        this.lastErrorIndex = -1;
    }

    @Override
    public void reportMatch(Parser recognizer) {
        this.endErrorCondition(recognizer);
    }

    @Override
    public void reportError(Parser recognizer, RecognitionException e) {
        if (this.inErrorRecoveryMode(recognizer)) {
            return;
        }
        this.beginErrorCondition(recognizer);
        if (e instanceof NoViableAltException) {
            this.reportNoViableAlternative(recognizer, (NoViableAltException)e);
            return;
        }
        if (e instanceof InputMismatchException) {
            this.reportInputMismatch(recognizer, (InputMismatchException)e);
            return;
        }
        if (e instanceof FailedPredicateException) {
            this.reportFailedPredicate(recognizer, (FailedPredicateException)e);
            return;
        }
        System.err.println("unknown recognition error type: " + e.getClass().getName());
        recognizer.notifyErrorListeners(e.getOffendingToken(), e.getMessage(), e);
    }

    @Override
    public void recover(Parser recognizer, RecognitionException e) {
        if (this.lastErrorIndex == recognizer.getInputStream().index() && this.lastErrorStates != null && this.lastErrorStates.contains(recognizer.getState())) {
            recognizer.consume();
        }
        this.lastErrorIndex = recognizer.getInputStream().index();
        if (this.lastErrorStates == null) {
            this.lastErrorStates = new IntervalSet();
        }
        this.lastErrorStates.add(recognizer.getState());
        IntervalSet followSet = this.getErrorRecoverySet(recognizer);
        this.consumeUntil(recognizer, followSet);
    }

    @Override
    public void sync(Parser recognizer) throws RecognitionException {
        ATNState s = ((ParserATNSimulator)recognizer.getInterpreter()).atn.states.get(recognizer.getState());
        if (this.inErrorRecoveryMode(recognizer)) {
            return;
        }
        int la = recognizer.getInputStream().LA(1);
        if (recognizer.getATN().nextTokens(s).contains(la) || la == -1) {
            return;
        }
        if (recognizer.isExpectedToken(la)) {
            return;
        }
        switch (s.getStateType()) {
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                if (this.singleTokenDeletion(recognizer) != null) {
                    return;
                }
                throw new InputMismatchException(recognizer);
            }
            case 9: 
            case 11: {
                this.reportUnwantedToken(recognizer);
                IntervalSet intervalSet = this.getErrorRecoverySet(recognizer);
                IntervalSet intervalSet2 = recognizer.getExpectedTokens();
                IntervalSet intervalSet3 = new IntervalSet();
                intervalSet3.addAll(intervalSet2);
                intervalSet3.addAll(intervalSet);
                IntervalSet whatFollowsLoopIterationOrRule = intervalSet3;
                this.consumeUntil(recognizer, whatFollowsLoopIterationOrRule);
            }
        }
    }

    protected void reportNoViableAlternative(Parser recognizer, NoViableAltException e) {
        TokenStream tokens = recognizer.getInputStream();
        String input = tokens != null ? (e.getStartToken().getType() == -1 ? "<EOF>" : tokens.getText(e.getStartToken(), e.getOffendingToken())) : "<unknown input>";
        String msg = "no viable alternative at input " + this.escapeWSAndQuote(input);
        recognizer.notifyErrorListeners(e.getOffendingToken(), msg, e);
    }

    protected void reportInputMismatch(Parser recognizer, InputMismatchException e) {
        String msg = "mismatched input " + this.getTokenErrorDisplay(e.getOffendingToken()) + " expecting " + e.getExpectedTokens().toString(recognizer.getTokenNames());
        recognizer.notifyErrorListeners(e.getOffendingToken(), msg, e);
    }

    protected void reportFailedPredicate(Parser recognizer, FailedPredicateException e) {
        String ruleName = recognizer.getRuleNames()[recognizer._ctx.getRuleIndex()];
        String msg = "rule " + ruleName + " " + e.getMessage();
        recognizer.notifyErrorListeners(e.getOffendingToken(), msg, e);
    }

    protected void reportUnwantedToken(Parser recognizer) {
        if (this.inErrorRecoveryMode(recognizer)) {
            return;
        }
        this.beginErrorCondition(recognizer);
        Token t = recognizer.getCurrentToken();
        String tokenName = this.getTokenErrorDisplay(t);
        IntervalSet expecting = this.getExpectedTokens(recognizer);
        String msg = "extraneous input " + tokenName + " expecting " + expecting.toString(recognizer.getTokenNames());
        recognizer.notifyErrorListeners(t, msg, null);
    }

    protected void reportMissingToken(Parser recognizer) {
        if (this.inErrorRecoveryMode(recognizer)) {
            return;
        }
        this.beginErrorCondition(recognizer);
        Token t = recognizer.getCurrentToken();
        IntervalSet expecting = this.getExpectedTokens(recognizer);
        String msg = "missing " + expecting.toString(recognizer.getTokenNames()) + " at " + this.getTokenErrorDisplay(t);
        recognizer.notifyErrorListeners(t, msg, null);
    }

    @Override
    public Token recoverInline(Parser recognizer) throws RecognitionException {
        Token matchedSymbol = this.singleTokenDeletion(recognizer);
        if (matchedSymbol != null) {
            recognizer.consume();
            return matchedSymbol;
        }
        if (this.singleTokenInsertion(recognizer)) {
            return this.getMissingSymbol(recognizer);
        }
        throw new InputMismatchException(recognizer);
    }

    protected boolean singleTokenInsertion(Parser recognizer) {
        int currentSymbolType = recognizer.getInputStream().LA(1);
        ATNState next = ((ParserATNSimulator)recognizer.getInterpreter()).atn.states.get((int)recognizer.getState()).transition((int)0).target;
        if (((ParserATNSimulator)recognizer.getInterpreter()).atn.nextTokens(next, recognizer._ctx).contains(currentSymbolType)) {
            this.reportMissingToken(recognizer);
            return true;
        }
        return false;
    }

    protected Token singleTokenDeletion(Parser recognizer) {
        int nextTokenType = recognizer.getInputStream().LA(2);
        if (this.getExpectedTokens(recognizer).contains(nextTokenType)) {
            this.reportUnwantedToken(recognizer);
            recognizer.consume();
            Token matchedSymbol = recognizer.getCurrentToken();
            this.reportMatch(recognizer);
            return matchedSymbol;
        }
        return null;
    }

    protected Token getMissingSymbol(Parser recognizer) {
        Token currentSymbol = recognizer.getCurrentToken();
        int expectedTokenType = this.getExpectedTokens(recognizer).getMinElement();
        String tokenText = expectedTokenType == -1 ? "<missing EOF>" : "<missing " + recognizer.getTokenNames()[expectedTokenType] + ">";
        Token current = currentSymbol;
        Token lookback = recognizer.getInputStream().LT(-1);
        if (current.getType() == -1 && lookback != null) {
            current = lookback;
        }
        return recognizer.getTokenFactory().create(new Pair<TokenSource, CharStream>(current.getTokenSource(), current.getTokenSource().getInputStream()), expectedTokenType, tokenText, 0, -1, -1, current.getLine(), current.getCharPositionInLine());
    }

    protected IntervalSet getExpectedTokens(Parser recognizer) {
        return recognizer.getExpectedTokens();
    }

    protected String getTokenErrorDisplay(Token t) {
        if (t == null) {
            return "<no token>";
        }
        String s = this.getSymbolText(t);
        if (s == null) {
            s = this.getSymbolType(t) == -1 ? "<EOF>" : "<" + this.getSymbolType(t) + ">";
        }
        return this.escapeWSAndQuote(s);
    }

    protected String getSymbolText(Token symbol) {
        return symbol.getText();
    }

    protected int getSymbolType(Token symbol) {
        return symbol.getType();
    }

    protected String escapeWSAndQuote(String s) {
        s = s.replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
        return "'" + s + "'";
    }

    protected IntervalSet getErrorRecoverySet(Parser recognizer) {
        ATN atn = ((ParserATNSimulator)recognizer.getInterpreter()).atn;
        RuleContext ctx = recognizer._ctx;
        IntervalSet recoverSet = new IntervalSet();
        while (ctx != null && ctx.invokingState >= 0) {
            RuleTransition rt = (RuleTransition)atn.states.get(ctx.invokingState).transition(0);
            IntervalSet follow = atn.nextTokens(rt.followState);
            recoverSet.addAll(follow);
            ctx = ctx.parent;
        }
        recoverSet.remove$13462e();
        return recoverSet;
    }

    protected void consumeUntil(Parser recognizer, IntervalSet set) {
        int ttype = recognizer.getInputStream().LA(1);
        while (ttype != -1 && !set.contains(ttype)) {
            recognizer.consume();
            ttype = recognizer.getInputStream().LA(1);
        }
    }
}

