/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.value;

import java.util.Arrays;
import java.util.Iterator;
import net.mobtalker.mobtalkerscript.v2.value.MtsNumber;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import net.mobtalker.mobtalkerscript.v2.value.TableHashPart;

final class TableListPart
implements Iterable<MtsValue> {
    private MtsValue[] _entries;
    private int _limit;

    public TableListPart(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this._entries = new MtsValue[n2];
        this._limit = 0;
    }

    public static boolean isValidKey(MtsValue mtsValue) {
        if (!mtsValue.isInteger()) {
            return false;
        }
        return mtsValue.asNumber().isPositive();
    }

    public final int length() {
        return this._limit;
    }

    public final boolean contains(MtsValue mtsValue) {
        return TableListPart.isValidKey(mtsValue) && mtsValue.asNumber().asJavaInt() <= this._limit;
    }

    public final boolean contains(MtsNumber mtsNumber) {
        MtsNumber mtsNumber2 = mtsNumber;
        return mtsNumber2.isInteger() && mtsNumber2.isPositive() && mtsNumber.asJavaInt() <= this._limit;
    }

    public final boolean contains(int n) {
        return n >= 0 && n < this._limit;
    }

    private int findCapacity(int n) {
        int n2;
        if (n <= this._entries.length) {
            return this._entries.length;
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        for (n2 = this._entries.length; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    public final void ensureCapacity(int n) {
        if (n > this._entries.length) {
            int n2 = this.findCapacity(n);
            TableListPart tableListPart = this;
            MtsValue[] mtsValueArray = new MtsValue[n2];
            System.arraycopy(tableListPart._entries, 0, mtsValueArray, 0, tableListPart._entries.length);
            tableListPart._entries = mtsValueArray;
        }
    }

    public final void add(MtsValue mtsValue) {
        if (mtsValue.isNil()) {
            return;
        }
        this.ensureCapacity(this._limit + 1);
        this._entries[this._limit++] = mtsValue;
    }

    public final void insert(int n, MtsValue mtsValue) {
        if (this._limit < n) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n == this._limit) {
            this.add(mtsValue);
            return;
        }
        int n2 = this.findCapacity(this._limit + 1);
        if (n2 > this._entries.length) {
            MtsValue[] mtsValueArray = new MtsValue[n2];
            System.arraycopy(this._entries, 0, mtsValueArray, 0, n);
            System.arraycopy(this._entries, n, mtsValueArray, n + 1, this._limit - n);
            this._entries = mtsValueArray;
        } else {
            System.arraycopy(this._entries, n, this._entries, n + 1, this._limit - n);
        }
        if (mtsValue.isNil()) {
            this._limit = n;
            return;
        }
        this._entries[n] = mtsValue;
        ++this._limit;
    }

    public final MtsValue set(int n, MtsValue mtsValue) {
        if (this._limit <= n) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        MtsValue mtsValue2 = this._entries[n];
        if (mtsValue.isNil()) {
            this._limit = n;
            this._entries[n] = null;
        } else {
            this._entries[n] = mtsValue;
        }
        return mtsValue2;
    }

    public final MtsValue remove(int n) {
        if (this._limit <= n) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = n;
        TableListPart tableListPart = this;
        MtsValue mtsValue = tableListPart._entries[n2];
        System.arraycopy(tableListPart._entries, n2 + 1, tableListPart._entries, n2, tableListPart._limit - n2 - 1);
        --tableListPart._limit;
        return mtsValue;
    }

    public final MtsValue removeLast() {
        if (this._limit == 0) {
            return MtsValue.NIL;
        }
        --this._limit;
        return this._entries[this._limit];
    }

    public final void clear() {
        this._limit = 0;
    }

    public final MtsValue get(int n) {
        if (n < 0 || this._limit <= n) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this._entries[n];
    }

    public final String concat(String string, int n, int n2) {
        if (this._limit == 0 || n < 0 || this._limit <= n2 || n2 < n) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this._entries[n].toMtsString().asJavaString());
        for (int i = n + 1; i <= n2; ++i) {
            stringBuilder.append(string).append(this._entries[i].toMtsString().asJavaString());
        }
        return stringBuilder.toString();
    }

    public final String concat(String string, int n) {
        return this.concat(string, n, this._limit);
    }

    public final String concat(String string) {
        return this.concat(string, 0, this._limit);
    }

    final void collectFrom(TableHashPart tableHashPart) {
        MtsValue mtsValue;
        int n = this._limit;
        while (!(mtsValue = tableHashPart.remove(MtsValue.valueOf(++n))).isNil()) {
            this.add(mtsValue);
        }
    }

    final void transferOrphansTo(TableHashPart tableHashPart) {
        MtsValue mtsValue;
        MtsValue[] mtsValueArray = this._entries;
        int n = this._limit + 1;
        while (n < mtsValueArray.length && (mtsValue = mtsValueArray[n]) != null) {
            mtsValueArray[n] = null;
            tableHashPart.set(MtsValue.valueOf(++n), mtsValue);
        }
    }

    @Override
    public final Iterator<MtsValue> iterator() {
        return new ListIterator(this);
    }

    public final String toString() {
        return Arrays.toString(this._entries);
    }

    static final class ListIterator
    implements Iterator<MtsValue> {
        private final TableListPart _listPart;
        private int _next;

        public ListIterator(TableListPart tableListPart) {
            this._listPart = tableListPart;
            this._next = 0;
        }

        @Override
        public final boolean hasNext() {
            return this._next < this._listPart.length();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

