/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.value;

import com.google.common.collect.Maps;
import java.util.HashMap;
import net.mobtalker.mobtalkerscript.v2.value.MtsTable;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;

public final class MtsType {
    private static final HashMap<String, MtsType> _types = Maps.newHashMap();
    public static final MtsType NIL = MtsType.forName("nil");
    public static final MtsType BOOLEAN = MtsType.forName("boolean");
    public static final MtsType NUMBER = MtsType.forName("number");
    public static final MtsType STRING = MtsType.forName("string");
    public static final MtsType TABLE = MtsType.forName("table");
    public static final MtsType FUNCTION = MtsType.forName("function");
    public static final MtsType VARARGS = MtsType.forName("varargs");
    public static final MtsType USERDATA = MtsType.forName("userdata");
    private final String _name;
    private MtsTable _metaTable;

    public static MtsType forName(String string) {
        MtsType mtsType = _types.get(string);
        if (mtsType == null) {
            mtsType = new MtsType(string);
            _types.put(string, mtsType);
        }
        return mtsType;
    }

    private MtsType(String string) {
        this._name = string;
    }

    public final String getName() {
        return this._name;
    }

    public final boolean hasMetaTable() {
        return this._metaTable != null;
    }

    public final MtsTable getMetaTable() {
        return this._metaTable;
    }

    public final void setMetaTable(MtsValue mtsValue) {
        if (mtsValue.isNil()) {
            this._metaTable = null;
            return;
        }
        if (mtsValue.isTable()) {
            this._metaTable = mtsValue.asTable();
            return;
        }
        throw new IllegalArgumentException("metatable must be a table (was " + mtsValue.getType() + ")");
    }

    public final String toString() {
        return this._name;
    }
}

