/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.value;

import com.google.common.base.Preconditions;
import net.mobtalker.mobtalkerscript.util.MtsCheck;
import net.mobtalker.mobtalkerscript.v2.value.MtsMetaTableValue;
import net.mobtalker.mobtalkerscript.v2.value.MtsNumber;
import net.mobtalker.mobtalkerscript.v2.value.MtsString;
import net.mobtalker.mobtalkerscript.v2.value.MtsType;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import net.mobtalker.mobtalkerscript.v2.value.TableHashPart;
import net.mobtalker.mobtalkerscript.v2.value.TableListPart;

public class MtsTable
extends MtsMetaTableValue {
    private final TableListPart _listPart;
    private final TableHashPart _hashPart;

    public MtsTable() {
        this(16, 16);
    }

    public MtsTable(int n, int n2) {
        this._listPart = new TableListPart(n);
        this._hashPart = new TableHashPart(n2);
    }

    public int count() {
        return this._listPart.length() + this._hashPart.count();
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public void ensureHashCapacity(int n) {
        this._hashPart.ensureCapacity(n);
    }

    public void ensureListCapacity(int n) {
        this._listPart.ensureCapacity(n);
    }

    public boolean containsKey(MtsValue mtsValue) {
        return !this.isEmpty() && (this._listPart.contains(mtsValue) || !this._hashPart.get(mtsValue).isNil());
    }

    public Entry getFirstEntry() {
        if (this._listPart.length() > 0) {
            return new Entry(MtsValue.ONE, this._listPart.get(0));
        }
        return this._hashPart.getFirst();
    }

    public Entry getNext(MtsValue mtsValue) {
        Preconditions.checkNotNull((Object)mtsValue);
        if (this.isEmpty()) {
            return null;
        }
        if (mtsValue.isNil()) {
            return this.getFirstEntry();
        }
        if (TableListPart.isValidKey(mtsValue)) {
            int n = mtsValue.asNumber().asJavaInt() - 1;
            if (this._listPart.contains(n++)) {
                if (this._listPart.contains(n)) {
                    return new Entry(MtsTable.valueOf(n + 1), this._listPart.get(n));
                }
                return this._hashPart.getFirst();
            }
        }
        return this._hashPart.getNext(mtsValue);
    }

    public Entry getINext(MtsNumber mtsNumber) {
        int n = mtsNumber.asNumber().asJavaInt();
        if (this._listPart.contains(n)) {
            return new Entry(MtsTable.valueOf(n), this._listPart.get(n));
        }
        return null;
    }

    public int listSize() {
        return this._listPart.length();
    }

    public void add(MtsValue mtsValue) {
        this._listPart.add(mtsValue);
    }

    public void add(Iterable<? extends MtsValue> iterable) {
        for (MtsValue mtsValue : iterable) {
            this.add(mtsValue);
        }
    }

    public void insert(MtsNumber mtsNumber, MtsValue mtsValue) {
        if (this._listPart.contains(mtsNumber)) {
            int n = mtsNumber.asJavaInt() - 1;
            this._listPart.insert(n, mtsValue);
            this._listPart.collectFrom(this._hashPart);
            return;
        }
        this.set(mtsNumber, mtsValue);
    }

    public MtsValue remove(MtsValue mtsValue) {
        Preconditions.checkNotNull((Object)mtsValue);
        if (this._listPart.contains(mtsValue)) {
            int n = mtsValue.asNumber().asJavaInt();
            return this._listPart.remove(n);
        }
        return this._hashPart.remove(mtsValue);
    }

    public MtsValue remove(int n) {
        if (!this._listPart.contains(n)) {
            return NIL;
        }
        return this._listPart.remove(n);
    }

    public MtsValue removeLast() {
        return this._listPart.removeLast();
    }

    public void clear() {
        this._listPart.clear();
        this._hashPart.clear();
    }

    public MtsString concatList(String string, int n, int n2) {
        return MtsTable.valueOf(this._listPart.concat(string, n, n2));
    }

    public MtsString concatList(String string, int n) {
        return MtsTable.valueOf(this._listPart.concat(string, n));
    }

    public MtsString concatList(String string) {
        return MtsTable.valueOf(this._listPart.concat(string));
    }

    @Override
    public MtsValue doGet(MtsValue mtsValue) {
        int n;
        MtsValue mtsValue2 = mtsValue;
        MtsTable mtsTable = this;
        assert (mtsValue2 != null) : "key cannot be null";
        if (mtsTable.isEmpty() || mtsValue2.isNil()) {
            return NIL;
        }
        if (TableListPart.isValidKey(mtsValue2) && mtsTable._listPart.contains(n = mtsValue2.asNumber().asJavaInt() - 1)) {
            return mtsTable._listPart.get(n);
        }
        return mtsTable._hashPart.get(mtsValue2);
    }

    @Override
    protected void doSet(MtsValue mtsValue, MtsValue mtsValue2) {
        MtsValue mtsValue3 = mtsValue2;
        MtsValue mtsValue4 = mtsValue;
        MtsTable mtsTable = this;
        assert (mtsValue4 != null) : "key was null";
        MtsCheck.checkNotNil(mtsValue4, "table index is nil");
        if (TableListPart.isValidKey(mtsValue4)) {
            int n = mtsValue4.asNumber().asJavaInt() - 1;
            if (mtsTable._listPart.contains(n)) {
                mtsTable._listPart.set(n, mtsValue3);
                if (mtsValue3.isNil()) {
                    mtsTable._listPart.transferOrphansTo(mtsTable._hashPart);
                }
            }
            if (mtsTable._listPart.contains(n - 1) || n == 0) {
                mtsTable._listPart.add(mtsValue3);
                mtsTable._listPart.collectFrom(mtsTable._hashPart);
                return;
            }
        }
        mtsTable._hashPart.set(mtsValue4, mtsValue3);
    }

    @Override
    protected MtsNumber doGetLength() {
        return MtsTable.valueOf(this.listSize());
    }

    @Override
    public boolean isTable() {
        return true;
    }

    @Override
    public MtsTable asTable() {
        return this;
    }

    @Override
    public MtsType getType() {
        return MtsType.TABLE;
    }

    @Override
    public MtsString toMtsString() {
        return MtsTable.valueOf(this.toString());
    }

    public Iterable<MtsValue> listView() {
        return this._listPart;
    }

    public Iterable<Entry> entryView() {
        return this._hashPart;
    }

    public static class Entry {
        protected final MtsValue key;
        protected MtsValue value;

        protected Entry(MtsValue mtsValue, MtsValue mtsValue2) {
            this.key = mtsValue;
            this.value = mtsValue2;
        }

        public MtsValue getKey() {
            return this.key;
        }

        public MtsValue getValue() {
            return this.value;
        }

        public String toString() {
            return this.key.toString() + "=" + this.value.toString();
        }
    }
}

