/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.value;

import com.google.common.math.DoubleMath;
import net.mobtalker.mobtalkerscript.v2.ScriptRuntimeException;
import net.mobtalker.mobtalkerscript.v2.value.MtsBoolean;
import net.mobtalker.mobtalkerscript.v2.value.MtsString;
import net.mobtalker.mobtalkerscript.v2.value.MtsType;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;

public final class MtsNumber
extends MtsValue {
    private static final MtsNumber[] CACHE = new MtsNumber[256];
    public static final MtsNumber NaN;
    public static final double MAX_VALUE = Double.MAX_VALUE;
    public static final double MIN_VALUE = Double.MIN_VALUE;
    private final double _value;

    public static MtsNumber of(double d) {
        if (Double.isNaN(d)) {
            return NaN;
        }
        return new MtsNumber(d);
    }

    public static MtsNumber of(int n) {
        if (-127 <= n && n <= 128) {
            return CACHE[n + 127];
        }
        return new MtsNumber(n);
    }

    public static MtsValue parse(MtsString mtsString) {
        MtsValue mtsValue;
        String string = mtsString.asJavaString();
        try {
            mtsValue = MtsNumber.of(Double.parseDouble(string));
        }
        catch (NumberFormatException numberFormatException) {
            mtsValue = NIL;
        }
        return mtsValue;
    }

    public static MtsNumber parse(MtsBoolean mtsBoolean) {
        if (mtsBoolean.toJavaValue()) {
            return ONE;
        }
        return ZERO;
    }

    private MtsNumber(double d) {
        this._value = d;
    }

    private MtsNumber(int n) {
        this._value = n;
    }

    public final MtsNumber add(MtsNumber mtsNumber) {
        return MtsNumber.of(this._value + mtsNumber._value);
    }

    public final MtsNumber sub(MtsNumber mtsNumber) {
        return MtsNumber.of(this._value - mtsNumber._value);
    }

    public final MtsNumber mul(MtsNumber mtsNumber) {
        return MtsNumber.of(this._value * mtsNumber._value);
    }

    public final MtsNumber div(MtsNumber mtsNumber) {
        return MtsNumber.of(this._value / mtsNumber._value);
    }

    public final MtsNumber mod(MtsNumber mtsNumber) {
        return MtsNumber.of(this._value % mtsNumber._value);
    }

    public final MtsNumber pow(MtsNumber mtsNumber) {
        return MtsNumber.of(Math.pow(this._value, mtsNumber._value));
    }

    public final MtsNumber neg() {
        return MtsNumber.of(-this._value);
    }

    public final MtsNumber incr() {
        return MtsNumber.of(this._value + 1.0);
    }

    public final MtsNumber decr() {
        return MtsNumber.of(this._value - 1.0);
    }

    public final MtsNumber floor() {
        return MtsNumber.of(Math.floor(this._value));
    }

    public final MtsNumber ceil() {
        return MtsNumber.of(Math.ceil(this._value));
    }

    public final MtsNumber round() {
        return MtsNumber.of(Math.round(this._value));
    }

    public final boolean isNaN() {
        return Double.isNaN(this._value);
    }

    public final boolean isInfinite() {
        return Double.isInfinite(this._value);
    }

    public final boolean isPositive() {
        return this._value > 0.0;
    }

    @Override
    protected final MtsBoolean doIsLess(MtsValue mtsValue) {
        if (!mtsValue.isNumber()) {
            throw new ScriptRuntimeException("attempt to compare %s with %s", this.getType(), mtsValue.getType());
        }
        return MtsNumber.valueOf(this._value < mtsValue.asNumber().asJavaDouble());
    }

    @Override
    protected final MtsBoolean doIsLessOrEqual(MtsValue mtsValue) {
        if (!mtsValue.isNumber()) {
            throw new ScriptRuntimeException("attempt to compare %s with %s", this.getType(), mtsValue.getType());
        }
        return MtsNumber.valueOf(this._value <= mtsValue.asNumber().asJavaDouble());
    }

    @Override
    public final boolean isNumber() {
        return true;
    }

    @Override
    public final boolean isInteger() {
        return DoubleMath.isMathematicalInteger((double)this._value);
    }

    @Override
    public final MtsNumber asNumber() {
        return this;
    }

    public final double asJavaDouble() {
        return this._value;
    }

    public final int asJavaInt() {
        return (int)this._value;
    }

    @Override
    public final MtsString toMtsString() {
        return MtsNumber.valueOf(this.toString());
    }

    @Override
    public final MtsNumber toMtsNumber() throws NumberFormatException {
        return this;
    }

    @Override
    public final MtsType getType() {
        return MtsType.NUMBER;
    }

    @Override
    public final int compareTo(MtsValue mtsValue) {
        if (mtsValue.isNumber() || mtsValue.isString()) {
            return (int)Math.rint(this._value - mtsValue.asNumber()._value);
        }
        return 0;
    }

    @Override
    public final String toString() {
        if (this.isInteger()) {
            return Integer.toString((int)this._value);
        }
        return Double.toString(this._value);
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(this._value);
        return (int)(l ^ l >> 32);
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof MtsNumber)) {
            return false;
        }
        return this.compareTo((MtsNumber)object) == 0;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            MtsNumber.CACHE[i] = new MtsNumber(i - 127);
        }
        NaN = MtsNumber.of(Double.NaN);
    }
}

