/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.instruction;

import com.google.common.collect.Lists;
import net.mobtalker.mobtalkerscript.v2.instruction.MtsFrame;
import net.mobtalker.mobtalkerscript.v2.instruction.MtsInstruction;
import net.mobtalker.mobtalkerscript.v2.value.MtsTable;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;

public class InstrNewTable
extends MtsInstruction {
    private final int _nListElements;
    private final int _nHashElements;

    InstrNewTable(int n, int n2) {
        this._nListElements = n;
        this._nHashElements = n2;
    }

    @Override
    public void execute(MtsFrame mtsFrame) {
        MtsTable mtsTable = new MtsTable(Math.max(this._nListElements, 16), Math.max(this._nHashElements, 16));
        mtsTable.add(Lists.reverse(mtsFrame.pop(this._nListElements)));
        for (int i = 0; i < this._nHashElements; ++i) {
            MtsValue mtsValue = mtsFrame.pop();
            MtsValue mtsValue2 = mtsFrame.pop();
            mtsTable.set(mtsValue2, mtsValue, true);
        }
        mtsFrame.push(mtsTable);
    }

    @Override
    public int stackSizeChange() {
        return 1 - this._nListElements - (this._nHashElements << 1);
    }

    @Override
    public String toString() {
        return "NEWTABLE " + this._nListElements + " " + this._nHashElements;
    }
}

