/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.compiler;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mobtalker.mobtalkerscript.util.StringEscapeUtil;
import net.mobtalker.mobtalkerscript.util.logging.MtsLog;
import net.mobtalker.mobtalkerscript.v2.ExternalDescription;
import net.mobtalker.mobtalkerscript.v2.LocalDescription;
import net.mobtalker.mobtalkerscript.v2.MtsFunctionPrototype;
import net.mobtalker.mobtalkerscript.v2.compiler.FunctionState;
import net.mobtalker.mobtalkerscript.v2.compiler.MtsSyntaxError;
import net.mobtalker.mobtalkerscript.v2.compiler.SourcePosition;
import net.mobtalker.mobtalkerscript.v2.compiler.antlr.AntlrCompilerAdapter;
import net.mobtalker.mobtalkerscript.v2.compiler.antlr.MtsAntlrErrorListener;
import net.mobtalker.mobtalkerscript.v2.compiler.antlr.MtsErrorStrategy;
import net.mobtalker.mobtalkerscript.v2.compiler.antlr.MtsLexer;
import net.mobtalker.mobtalkerscript.v2.compiler.antlr.MtsParser;
import net.mobtalker.mobtalkerscript.v2.instruction.Instructions;
import net.mobtalker.mobtalkerscript.v2.instruction.MtsInstruction;
import net.mobtalker.mobtalkerscript.v2.value.MtsBoolean;
import net.mobtalker.mobtalkerscript.v2.value.MtsNumber;
import net.mobtalker.mobtalkerscript.v2.value.MtsString;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import org.antlr.v4.runtime.ANTLRFileStream;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.UnbufferedTokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.apache.commons.lang3.StringUtils;

public class MtsCompiler {
    private final FunctionState _mainFunction;
    private FunctionState _currentFunction;
    private final String _sourceName;
    private SourcePosition _curPosition = new SourcePosition(0, 0);
    private static final Pattern _interpolationPattern = Pattern.compile("(?<!\\\\)\\{([_a-zA-Z][_a-zA-Z0-9]*)\\}");

    public static MtsFunctionPrototype loadFile(String string) throws Exception {
        return MtsCompiler.loadFile(Paths.get(string, new String[0]));
    }

    public static MtsFunctionPrototype loadFile(File file) throws Exception {
        return MtsCompiler.loadFile(file.toPath());
    }

    public static MtsFunctionPrototype loadFile(Path path) throws Exception {
        path = path.toRealPath(new LinkOption[0]);
        return MtsCompiler.load(new ANTLRFileStream(path.toString()));
    }

    public static MtsFunctionPrototype loadString(String string, String string2) throws Exception {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)string) ? 1 : 0) != 0, (Object)"chunk cannot be null or empty");
        ANTLRInputStream aNTLRInputStream = new ANTLRInputStream(string);
        new ANTLRInputStream(string).name = string2;
        return MtsCompiler.load(aNTLRInputStream);
    }

    public static MtsFunctionPrototype load(ANTLRInputStream aNTLRInputStream) throws IOException, MtsSyntaxError {
        MtsParser.ChunkContext chunkContext;
        MtsLexer mtsLexer = new MtsLexer(aNTLRInputStream);
        mtsLexer.setTokenFactory(new CommonTokenFactory());
        UnbufferedTokenStream unbufferedTokenStream = new UnbufferedTokenStream(mtsLexer);
        MtsParser mtsParser = new MtsParser(unbufferedTokenStream);
        mtsParser.removeErrorListeners();
        mtsParser.addErrorListener(new MtsAntlrErrorListener());
        mtsParser.setErrorHandler(new MtsErrorStrategy());
        ((ParserATNSimulator)mtsParser.getInterpreter()).setPredictionMode(PredictionMode.LL_EXACT_AMBIG_DETECTION);
        try {
            chunkContext = mtsParser.chunk();
        }
        catch (MtsSyntaxError mtsSyntaxError) {
            throw new MtsSyntaxError(mtsSyntaxError.getSourceName(), mtsSyntaxError.getSourcePosition(), mtsSyntaxError.getOriginalMessage());
        }
        int n = chunkContext.getStart().getLine();
        int n2 = chunkContext.getStop() != null ? chunkContext.getStop().getLine() : n;
        MtsCompiler mtsCompiler = new MtsCompiler(unbufferedTokenStream.getSourceName(), n, n2);
        new AntlrCompilerAdapter(mtsCompiler).compile(chunkContext);
        return mtsCompiler.compile();
    }

    public MtsCompiler(String string, int n, int n2) {
        this._mainFunction = new FunctionState(null, "main", string, n, n2);
        this._mainFunction.addExternal(new ExternalDescription("_ENV", 0, 0, true));
        this._currentFunction = this._mainFunction;
        this._sourceName = string;
    }

    public void setSourcePosition(int n, int n2) {
        if (this._curPosition.equals(n, n2)) {
            return;
        }
        this._curPosition = new SourcePosition(n, n2);
    }

    public SourcePosition getSourcePosition() {
        return this._curPosition;
    }

    public void addInstr(MtsInstruction mtsInstruction) {
        MtsLog.CompilerLog.fine("  Instruction: " + mtsInstruction, new Object[0]);
        this._currentFunction.addInstruction(mtsInstruction, this._curPosition);
    }

    public void discardValue() {
        this.addInstr(Instructions.InstrPop());
    }

    public void enterFunction(String string, int n, int n2, String ... stringArray) {
        MtsLog.CompilerLog.info("Enter Function ", new Object[0]);
        this.enterFunction(string, n, n2, stringArray);
    }

    public void enterFunction(String string, int n, int n2, Iterable<String> iterable) {
        FunctionState functionState = new FunctionState(this._currentFunction, string, this._sourceName, n, n2);
        this._currentFunction.addChild(functionState);
        this._currentFunction = functionState;
        for (String string2 : iterable) {
            this.declareLocal(string2);
        }
    }

    public void exitFunction() {
        MtsLog.CompilerLog.info("Exit Function ", new Object[0]);
        this.addInstr(Instructions.InstrReturn(0));
        this._currentFunction = this._currentFunction.getParent();
    }

    public void enterBlock() {
        MtsLog.CompilerLog.info("Enter Block", new Object[0]);
        this._currentFunction.enterBlock();
    }

    public void exitBlock() {
        MtsLog.CompilerLog.info("Exit Block", new Object[0]);
        this._currentFunction.exitBlock();
    }

    public void enterWhileLoop() {
        MtsLog.CompilerLog.info("Enter WhileLoop", new Object[0]);
        this._currentFunction.enterLoop();
    }

    public void enterWhileBody() {
        MtsLog.CompilerLog.info("Enter WhileBody", new Object[0]);
        this.addInstr(Instructions.InstrTest());
        this._currentFunction.markBreak();
        this._currentFunction.enterBlock();
    }

    public void exitWhileLoop() {
        MtsLog.CompilerLog.info("Exit WhileLoop", new Object[0]);
        this.addInstr(Instructions.InstrJump());
        this._currentFunction.exitLoop();
        this._currentFunction.exitBlock();
    }

    public void enterRepeatLoop() {
        this._currentFunction.enterLoop();
        this._currentFunction.enterBlock();
    }

    public void enterUntilConditon() {
        this._currentFunction.exitBlock();
    }

    public void exitRepeatLoop() {
        this.addInstr(Instructions.InstrTest());
        this._currentFunction.exitLoop();
    }

    public void enterNumericForLoop(String string) {
        this._currentFunction.enterBlock();
        this._currentFunction.enterNumericForLoop(string);
    }

    public void enterGenericForLoop(String ... stringArray) {
        this._currentFunction.enterBlock();
        this._currentFunction.enterGenericForLoop(stringArray);
    }

    public void exitForLoop() {
        this.addInstr(Instructions.InstrJump());
        this._currentFunction.exitLoop();
        this._currentFunction.exitBlock();
    }

    public void breakLoop() {
        this.addInstr(Instructions.InstrJump());
        this._currentFunction.markBreak();
    }

    public void enterIfThenElseBlock() {
        this._currentFunction.enterIfThenElse();
    }

    public void enterIfCondition() {
        this._currentFunction.enterIfCondition();
    }

    public void endIfCondition() {
        this._currentFunction.endIfCondition();
    }

    public void endThenBlock() {
        this._currentFunction.endThenBlock();
    }

    public void enterElseBlock() {
        this._currentFunction.enterElseBlock();
    }

    public void exitIfThenElse() {
        this._currentFunction.exitIfThenElse();
    }

    public void declareLabel(String string) {
        this._currentFunction.addLabel(string);
    }

    public void gotoLabel(String string) {
        this._currentFunction.gotoLabel(string);
    }

    public LocalDescription declareLocal(String string) {
        MtsLog.CompilerLog.info("Declare local: " + string, new Object[0]);
        return this._currentFunction.declareLocal(string);
    }

    public LocalDescription declareAnonymousLocal(String string) {
        MtsLog.CompilerLog.info("Declare internal: " + string, new Object[0]);
        return this._currentFunction.declareAnonymousLocal(string);
    }

    private void loadEnvironment() {
        if (this._currentFunction.isLocal("_ENV")) {
            int n = this._currentFunction.getLocalIndex("_ENV");
            this.addInstr(Instructions.InstrLoadL(n));
            return;
        }
        int n = this._currentFunction.getExternalIndex("_ENV");
        this.addInstr(Instructions.InstrLoadE(n));
    }

    public void loadVariable(String string) {
        MtsLog.CompilerLog.info("Load Variable: " + string, new Object[0]);
        if (this._currentFunction.isLocal(string)) {
            int n = this._currentFunction.getLocalIndex(string);
            this.addInstr(Instructions.InstrLoadL(n));
            return;
        }
        if (this._currentFunction.isExternal(string)) {
            int n = this._currentFunction.getExternalIndex(string);
            this.addInstr(Instructions.InstrLoadE(n));
            return;
        }
        this.loadEnvironment();
        int n = this._currentFunction.getConstantIndex(MtsValue.valueOf(string));
        this.addInstr(Instructions.InstrLoadC(n));
        this.addInstr(Instructions.InstrLoadT());
    }

    public void loadLocal(int n) {
        this.addInstr(Instructions.InstrLoadL(n));
    }

    public void loadConstant(MtsValue mtsValue) {
        Preconditions.checkNotNull((Object)(mtsValue != null ? 1 : 0), (Object)"value cannot be null");
        Preconditions.checkArgument((!mtsValue.isNil() ? 1 : 0) != 0, (Object)"value cannot be nil");
        MtsLog.CompilerLog.info("Load constant: " + mtsValue, new Object[0]);
        int n = this._currentFunction.getConstantIndex(mtsValue);
        this.addInstr(Instructions.InstrLoadC(n));
    }

    public void loadConstant(String string) {
        this.loadConstant(MtsCompiler.parseString(string));
    }

    public void loadNil() {
        MtsLog.CompilerLog.info("Load nil", new Object[0]);
        this.addInstr(Instructions.InstrLoadNil());
    }

    public void loadNil(int n) {
        for (int i = 0; i < n; ++i) {
            this.loadNil();
        }
    }

    public void storeVariable(String string) {
        MtsLog.CompilerLog.info("Store Variable: " + string, new Object[0]);
        if (this._currentFunction.isLocal(string)) {
            int n = this._currentFunction.getLocalIndex(string);
            this.addInstr(Instructions.InstrStoreL(n));
            return;
        }
        if (this._currentFunction.isExternal(string)) {
            int n = this._currentFunction.getExternalIndex(string);
            this.addInstr(Instructions.InstrStoreE(n));
            return;
        }
        this.loadEnvironment();
        int n = this._currentFunction.getConstantIndex(MtsValue.valueOf(string));
        this.addInstr(Instructions.InstrLoadC(n));
        this.addInstr(Instructions.InstrStoreT());
    }

    public void storeLocal(int n) {
        this.addInstr(Instructions.InstrStoreL(n));
    }

    public void createTable(int n, int n2) {
        MtsLog.CompilerLog.info("Create Table", new Object[0]);
        this.addInstr(Instructions.InstrNewTable(n, n2));
    }

    public void loadFromTable() {
        MtsLog.CompilerLog.info("Load from Table", new Object[0]);
        this.addInstr(Instructions.InstrLoadT());
    }

    public void storeInTable() {
        MtsLog.CompilerLog.info("Store in Table", new Object[0]);
        this.addInstr(Instructions.InstrStoreT());
    }

    public void loadMethod(String string) {
        MtsLog.CompilerLog.info("Load Method: " + string, new Object[0]);
        int n = this._currentFunction.getConstantIndex(MtsValue.valueOf(string));
        this.addInstr(Instructions.InstrLoadM(n));
    }

    public void assignmentOperation(String string) {
        MtsLog.CompilerLog.info("Operator: " + string, new Object[0]);
        throw new UnsupportedOperationException();
    }

    public void unaryOperation(String string) {
        MtsLog.CompilerLog.info("Operator: " + string, new Object[0]);
        this.addInstr(Instructions.InstrUnaryOp(string));
    }

    public void binaryOperation(String string) {
        MtsLog.CompilerLog.log(Level.INFO, "Operator: " + string);
        this.addInstr(Instructions.InstrBinaryOp(string));
    }

    public void logicOperation(String string) {
        MtsLog.CompilerLog.info("Operator: " + string, new Object[0]);
        if (">".equals(string)) {
            this.addInstr(Instructions.InstrLte());
            this.addInstr(Instructions.InstrNot());
            return;
        }
        if (">=".equals(string)) {
            this.addInstr(Instructions.InstrLt());
            this.addInstr(Instructions.InstrNot());
            return;
        }
        if ("!=".equals(string)) {
            this.addInstr(Instructions.InstrEq());
            this.addInstr(Instructions.InstrNot());
            return;
        }
        this.addInstr(Instructions.InstrLogicalOp(string));
    }

    public void enterConditionalBlock(String string) {
        MtsLog.CompilerLog.info("Operator: " + string, new Object[0]);
        if ("and".equals(string)) {
            this.addInstr(Instructions.InstrAnd());
            this._currentFunction.markPendingJump();
            return;
        }
        if ("or".equals(string)) {
            this.addInstr(Instructions.InstrOr());
            this._currentFunction.markPendingJump();
            return;
        }
        throw new IllegalArgumentException(string + " is not a valid conditional operator");
    }

    public void exitConditionalBlock() {
        this._currentFunction.setPendingJump(1);
    }

    public void createClosure() {
        MtsLog.CompilerLog.info("Create Closure", new Object[0]);
        int n = this._currentFunction.getChilds().size() - 1;
        this.addInstr(Instructions.InstrClosure(n));
    }

    public void callFunction(int n, int n2) {
        MtsLog.CompilerLog.info("Call Function", new Object[0]);
        this.addInstr(Instructions.InstrCall(n, n2));
    }

    public void returnFunction(int n) {
        MtsLog.CompilerLog.info("Return Function", new Object[0]);
        this.addInstr(Instructions.InstrReturn(n));
    }

    public void tailCall(int n, int n2) {
        MtsLog.CompilerLog.info("Tailcall Function", new Object[0]);
        this.addInstr(Instructions.InstrTailcall(n, n2));
    }

    public static String cleanString(String string) {
        return StringEscapeUtil.unescape(StringUtils.strip((String)string, (String)"\""));
    }

    public static MtsString parseString(String string) {
        return MtsValue.valueOf(MtsCompiler.cleanString(string));
    }

    public static MtsBoolean parseBoolean(String string) {
        return MtsValue.valueOf(Boolean.parseBoolean(string));
    }

    public static MtsNumber parseNumber(String string) {
        String string2 = string;
        if (StringUtils.startsWithIgnoreCase((CharSequence)string2, (CharSequence)"0x") && StringUtils.lastIndexOfIgnoreCase((CharSequence)string2, (CharSequence)"p") < 0) {
            string2 = string2 + "p0";
        }
        try {
            return MtsValue.valueOf(Double.parseDouble(string2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(string);
        }
    }

    public void interpolateString(String string) {
        string = MtsCompiler.cleanString(string);
        Matcher matcher = _interpolationPattern.matcher(string);
        int n = 0;
        if (matcher.find()) {
            int n2 = 0;
            do {
                int n3;
                if ((n3 = matcher.start(0)) - n > 0) {
                    this.loadConstant(string.substring(n, n3));
                    ++n2;
                }
                String string2 = matcher.group(1);
                this.loadVariable(string2);
                ++n2;
                n = matcher.end(0);
            } while (matcher.find());
            if (string.length() - n > 0) {
                this.loadConstant(string.substring(n));
                ++n2;
            }
            this.addInstr(Instructions.InstrConcat(n2));
            return;
        }
        this.loadConstant(string);
    }

    public MtsFunctionPrototype compile() {
        if (this._currentFunction != this._mainFunction) {
            throw new IllegalStateException();
        }
        return this._mainFunction.createPrototype();
    }
}

