/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.scriptpack;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mobtalker.mobtalker2.MobTalker2;
import net.mobtalker.mobtalker2.server.scriptpack.DefaultScriptPack;
import net.mobtalker.mobtalker2.server.scriptpack.FileScriptPack;
import net.mobtalker.mobtalker2.server.scriptpack.FolderScriptPack;
import net.mobtalker.mobtalker2.server.scriptpack.IScriptPack;
import net.mobtalker.mobtalker2.server.scriptpack.IScriptPackEntry;
import net.mobtalker.mobtalker2.server.scriptpack.config.ScriptPackConfigException;
import net.mobtalker.mobtalker2.util.logging.MobTalkerLog;

public class ScriptPackRepository {
    private static final String LOG_TAG = "ScriptPackRepository";
    private static final Path _defaultPackPath = MobTalker2.getResourcePackPath("MobTalker2_Scripts");
    private static ScriptPackRepository instance;
    private final List<IScriptPack> _scriptPacks = Lists.newArrayList();
    private final Map<String, IScriptPackEntry> _activeScripts = Maps.newHashMap();

    public static ScriptPackRepository instance() {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"No ScriptPackRepository is currently loaded");
        return instance;
    }

    public static boolean isLoaded() {
        return instance != null;
    }

    public static void load() {
        Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Already loaded");
        MobTalkerLog.debug(LOG_TAG, "Loading ScriptPackRepository");
        instance = new ScriptPackRepository();
        try {
            if (!Files.exists(_defaultPackPath, new LinkOption[0])) {
                Files.createDirectories(_defaultPackPath, new FileAttribute[0]);
            }
            instance.addScriptPack(new DefaultScriptPack(_defaultPackPath));
            for (IScriptPack scriptPack : ScriptPackRepository.discoverScriptPacks()) {
                instance.addScriptPack(scriptPack);
            }
            instance.loadScriptPackEntries();
        }
        catch (IOException ex) {
            MobTalkerLog.fatal(LOG_TAG, "Unable to read ScriptPacks", ex);
        }
    }

    public static void unload() {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"No ScriptPackRepository is currently loaded");
        instance.clear();
        instance = null;
    }

    private static List<IScriptPack> discoverScriptPacks() throws IOException {
        ArrayList filePacks = Lists.newArrayList();
        ArrayList folderPacks = Lists.newArrayList();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(MobTalker2.getResourcePackPath(new String[0]));){
            for (Path path : stream) {
                if (path.equals(_defaultPackPath)) continue;
                MobTalkerLog.trace(LOG_TAG, "Examinating '%s' for a script pack", MobTalker2.getMinecraftPath(new String[0]).relativize(path));
                try {
                    if (FolderScriptPack.isValid(path)) {
                        folderPacks.add(FolderScriptPack.from(path));
                        continue;
                    }
                    if (!FileScriptPack.isValid(path)) continue;
                    filePacks.add(FileScriptPack.from(path));
                }
                catch (ScriptPackConfigException ex) {
                    MobTalkerLog.warn(LOG_TAG, "Script pack at path '%s' has an invalid configuration: %s", path.toString(), ex.getMessage());
                }
                catch (IOException ex) {
                    MobTalkerLog.warn(LOG_TAG, "Error while reading a script pack from path '%s'", ex, path.toString());
                }
            }
        }
        ArrayList packs = Lists.newArrayListWithExpectedSize((int)(filePacks.size() + folderPacks.size()));
        packs.addAll(filePacks);
        packs.addAll(folderPacks);
        return packs;
    }

    public List<IScriptPack> getScriptPacks() {
        return Collections.unmodifiableList(this._scriptPacks);
    }

    public Map<String, IScriptPackEntry> getActiveScripts() {
        return Collections.unmodifiableMap(this._activeScripts);
    }

    public boolean hasScriptFor(String entity) {
        return this._activeScripts.containsKey(entity);
    }

    public IScriptPackEntry getScriptFor(String entity) {
        return this._activeScripts.get(entity);
    }

    public boolean hasScripts() {
        return !this._activeScripts.isEmpty();
    }

    private void clear() {
        for (IScriptPack pack : this._scriptPacks) {
            pack.close();
        }
        this._scriptPacks.clear();
    }

    public void addScriptPack(IScriptPack pack) {
        if (this._scriptPacks.contains(pack)) {
            throw new IllegalArgumentException("Tried to add a script pack twice");
        }
        this._scriptPacks.add(pack);
    }

    public void loadScriptPackEntries() {
        this._activeScripts.clear();
        HashMap perEntityPack = Maps.newHashMap();
        for (IScriptPack iScriptPack : this._scriptPacks) {
            MobTalkerLog.debug(LOG_TAG, "Reading ScriptPack entries for %s", iScriptPack.getTitle());
            for (String entity : iScriptPack.getSupportedEntities()) {
                if (perEntityPack.containsKey(entity)) {
                    MobTalkerLog.warn(LOG_TAG, "ScriptPack '%s' is overriding an interaction script for '%s' from '%s'", iScriptPack.getTitle(), entity, ((IScriptPack)perEntityPack.get(entity)).getTitle());
                }
                perEntityPack.put(entity, iScriptPack);
            }
        }
        for (Map.Entry entry : perEntityPack.entrySet()) {
            String entityName = (String)entry.getKey();
            IScriptPack pack = (IScriptPack)entry.getValue();
            IScriptPackEntry entry2 = pack.getEntryFor(entityName);
            this._activeScripts.put(entityName, entry2);
            MobTalkerLog.info(LOG_TAG, "Activated interaction script for '%s' from '%s'", entityName, pack.getTitle());
        }
    }
}

