/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.scriptpack;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import net.mobtalker.mobtalker2.MobTalker2;
import net.mobtalker.mobtalker2.common.MobTalkerConfig;
import net.mobtalker.mobtalker2.server.scriptpack.AbstractScriptPack;
import net.mobtalker.mobtalker2.server.scriptpack.IScriptFile;
import net.mobtalker.mobtalker2.server.scriptpack.ScriptPackEntry;
import net.mobtalker.mobtalker2.server.scriptpack.ZipScriptFile;
import net.mobtalker.mobtalker2.server.scriptpack.config.InteractionScriptConfig;
import net.mobtalker.mobtalker2.server.scriptpack.config.ScriptPackConfig;
import net.mobtalker.mobtalker2.server.scriptpack.config.ScriptPackConfigException;
import net.mobtalker.mobtalker2.util.logging.MobTalkerLog;
import org.apache.commons.lang3.StringUtils;

public class FileScriptPack
extends AbstractScriptPack {
    private static final String LOG_TAG = "ScriptPack";
    private final ZipFile _zipFile;

    public static boolean isValid(Path path) throws ZipException, IOException {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return false;
        }
        boolean isValid = false;
        try (ZipFile zipFile = new ZipFile(path.toFile(), MobTalkerConfig.CHARSET);){
            isValid = zipFile.getEntry("MobTalker2.pack") != null;
        }
        catch (Exception ex) {
            isValid = false;
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileScriptPack from(Path path) throws IOException {
        ScriptPackConfig config;
        MobTalkerLog.info(LOG_TAG, "Reading FileScriptPack '%s'", MobTalker2.getResourcePackPath(new String[0]).relativize(path));
        ZipFile zipFile = new ZipFile(path.toFile(), MobTalkerConfig.CHARSET);
        InputStream configFile = null;
        try {
            configFile = zipFile.getInputStream(zipFile.getEntry("MobTalker2.pack"));
            config = ScriptPackConfig.read(configFile);
        }
        catch (Throwable throwable) {
            Closeables.close(configFile, (boolean)true);
            throw throwable;
        }
        Closeables.close((Closeable)configFile, (boolean)true);
        FileScriptPack pack = new FileScriptPack(path, config, zipFile);
        return pack;
    }

    public FileScriptPack(Path path, ScriptPackConfig config, ZipFile file) throws IOException {
        super(path, config.getTitle(), config.getVersion(), config.getDescription(), config.getAuthors());
        this._zipFile = file;
        this._isResourcePack = this._zipFile.getEntry("assets/mobtalker/") != null;
        this.createEntries(config.getInteractionScripts());
    }

    private void createEntries(List<InteractionScriptConfig> configs) throws IOException {
        for (InteractionScriptConfig config : configs) {
            this.addEntry(config.getEntity(), new ScriptPackEntry(this, this.checkPaths(config.getFiles()), config.getSavedVariables(), config.getSavedVariablesPerPlayer()));
        }
    }

    private List<IScriptFile> checkPaths(List<String> stringPaths) throws IOException {
        ArrayList files = Lists.newArrayListWithExpectedSize((int)stringPaths.size());
        for (String stringPath : stringPaths) {
            ZipEntry entry = this._zipFile.getEntry(stringPath = StringUtils.replaceChars((String)stringPath, (char)'\\', (char)'/'));
            if (entry == null) {
                throw new ScriptPackConfigException("script path '%s' does not exist", stringPath);
            }
            files.add(new ZipScriptFile(this._path, this._zipFile, entry));
        }
        return files;
    }

    @Override
    public void close() {
        try {
            this._zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

