/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.script.lib;

import java.util.Map;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.mobtalker.mobtalker2.server.interaction.IInteractionAdapter;
import net.mobtalker.mobtalker2.server.script.lib.AbstractMobTalkerEntityLib;
import net.mobtalker.mobtalker2.util.InventoryUtil;
import net.mobtalker.mobtalker2.util.ItemUtil;
import net.mobtalker.mobtalkerscript.util.MtsCheck;
import net.mobtalker.mobtalkerscript.v2.BadArgumentException;
import net.mobtalker.mobtalkerscript.v2.ScriptRuntimeException;
import net.mobtalker.mobtalkerscript.v2.value.MtsBoolean;
import net.mobtalker.mobtalkerscript.v2.value.MtsNumber;
import net.mobtalker.mobtalkerscript.v2.value.MtsString;
import net.mobtalker.mobtalkerscript.v2.value.MtsTable;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import net.mobtalker.mobtalkerscript.v2.value.MtsVarArgs;
import net.mobtalker.mobtalkerscript.v2.value.userdata.MtsNativeFunction;

public class InteractionPlayerLib
extends AbstractMobTalkerEntityLib<EntityPlayer> {
    private static final MtsValue KEY_ITEM_NAME = MtsValue.valueOf("name");
    private static final MtsValue KEY_ITEM_COUNT = MtsValue.valueOf("count");
    private static final MtsValue KEY_ITEM_META = MtsValue.valueOf("meta");

    public InteractionPlayerLib(IInteractionAdapter adapter) {
        super(adapter);
    }

    @Override
    protected EntityPlayerMP getEntity() {
        if (!this._adapter.isActive()) {
            throw new IllegalStateException("no interaction partner!");
        }
        return this._adapter.getPlayer();
    }

    @MtsNativeFunction
    public MtsNumber getArmor() {
        EntityPlayerMP player = this.getEntity();
        int armor = ForgeHooks.getTotalArmorValue((EntityPlayer)player);
        return MtsValue.valueOf(armor);
    }

    @MtsNativeFunction
    public MtsVarArgs getExperience() {
        EntityPlayerMP player = this.getEntity();
        int level = player.field_71068_ca;
        float progress = player.field_71106_cc;
        int total = player.field_71067_cb;
        return MtsVarArgs.of(MtsValue.valueOf(level), MtsValue.valueOf(progress), MtsValue.valueOf(total));
    }

    @MtsNativeFunction
    public void giveExperience(MtsValue argAmount) {
        int amount = MtsCheck.checkInteger(argAmount, 0);
        EntityPlayerMP player = this.getEntity();
        player.func_71023_q(amount);
    }

    @MtsNativeFunction
    public MtsVarArgs getHeldItem() {
        EntityPlayerMP player = this.getEntity();
        ItemStack heldStack = player.func_70694_bm();
        if (heldStack == null) {
            return MtsValue.EMPTY_VARARGS;
        }
        Item heldItem = heldStack.func_77973_b();
        String name = heldItem.func_77658_a();
        int meta = heldStack.func_77960_j();
        int amount = heldStack.field_77994_a;
        return MtsVarArgs.of(MtsValue.valueOf(name), MtsValue.valueOf(meta), MtsValue.valueOf(amount));
    }

    private static boolean matchItem(String name, int meta, ItemStack stack) {
        if (meta > -1) {
            if (stack.func_77960_j() != meta) {
                return false;
            }
            return name.equals(stack.func_77973_b().func_77658_a());
        }
        return name.equals(stack.func_77977_a());
    }

    private int getItemCount(String name, int meta) {
        ItemStack[] inventory;
        int count = 0;
        for (ItemStack stack : inventory = this.getEntity().field_71071_by.field_70462_a) {
            if (stack == null || !InteractionPlayerLib.matchItem(name, meta, stack)) continue;
            count += stack.field_77994_a;
        }
        return count;
    }

    @MtsNativeFunction
    public MtsNumber getItemCount(MtsValue argItemName, MtsValue argItemMeta) {
        String name = MtsCheck.checkString(argItemName, 0);
        int meta = MtsCheck.checkInteger(argItemMeta, 1, -1);
        int count = this.getItemCount(name, meta);
        return MtsValue.valueOf(count);
    }

    private boolean removeItems(String name, int meta, int amount) {
        int remaining = this.getItemCount(name, meta);
        if (remaining < amount) {
            return false;
        }
        InventoryPlayer inventory = this.getEntity().field_71071_by;
        ItemStack[] slots = inventory.field_70462_a;
        for (int i = 0; i < slots.length && remaining > 0; ++i) {
            ItemStack stack = slots[i];
            if (stack == null || !InteractionPlayerLib.matchItem(name, meta, stack)) continue;
            int toRemove = Math.min(stack.field_77994_a, remaining);
            stack.field_77994_a -= toRemove;
            remaining -= toRemove;
            assert (stack.field_77994_a >= 0);
            if (stack.field_77994_a > 0) continue;
            slots[i] = null;
        }
        inventory.func_70296_d();
        return true;
    }

    @MtsNativeFunction
    public MtsBoolean takeItems(MtsValue argItemName, MtsValue argItemCount, MtsValue argItemMeta) {
        String name = MtsCheck.checkString(argItemName, 0);
        int count = MtsCheck.checkInteger(argItemCount, 1, 1);
        int meta = MtsCheck.checkInteger(argItemMeta, 2, -1);
        boolean success = this.removeItems(name, meta, count);
        return MtsValue.valueOf(success);
    }

    @MtsNativeFunction
    public MtsBoolean giveItems(MtsValue argItemName, MtsValue argItemCount, MtsValue argItemMeta) {
        int stackSize;
        String name = MtsCheck.checkString(argItemName, 0);
        int meta = MtsCheck.checkInteger(argItemMeta, 2, -1);
        if (!ItemUtil.isValidItem(name)) {
            throw new BadArgumentException("unknown item name '%s'", name);
        }
        Item item = ItemUtil.getItemForName(name);
        EntityPlayerMP player = this.getEntity();
        for (int count = MtsCheck.checkInteger(argItemCount, 1, 1); count > 0; count -= stackSize) {
            ItemStack itemStack = new ItemStack(item, 1, meta);
            stackSize = Math.min(count, itemStack.func_77976_d());
            if (stackSize == 0) {
                throw new ScriptRuntimeException("cannot drop zero size item stacks");
            }
            itemStack.field_77994_a = stackSize;
            EntityItem itemEntity = player.func_70099_a(itemStack, 0.0f);
            itemEntity.field_145804_b = 0;
        }
        return MtsValue.TRUE;
    }

    @MtsNativeFunction
    public MtsTable getInventory() {
        MtsTable t = new MtsTable(32, 0);
        ItemStack[] slots = this.getEntity().field_71071_by.field_70462_a;
        Map<ItemStack, Integer> itemCounts = InventoryUtil.getTotalItemCounts(slots);
        for (Map.Entry<ItemStack, Integer> entry : itemCounts.entrySet()) {
            MtsTable info = new MtsTable(0, 3);
            info.set(KEY_ITEM_NAME, (MtsValue)MtsValue.valueOf(ItemUtil.getNameForItem(entry.getKey())));
            info.set(KEY_ITEM_COUNT, (MtsValue)MtsValue.valueOf(entry.getValue()));
            info.set(KEY_ITEM_META, (MtsValue)MtsValue.valueOf(entry.getKey().func_77960_j()));
            t.add(info);
        }
        return t;
    }

    @MtsNativeFunction
    public MtsString getGameMode() {
        WorldSettings.GameType gameType = this.getEntity().field_71134_c.func_73081_b();
        String name = gameType.func_77149_b();
        return MtsValue.valueOf(name);
    }
}

