/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.script.lib;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.mobtalker.mobtalker2.server.interaction.IInteractionAdapter;
import net.mobtalker.mobtalker2.server.interaction.InteractionCanceledException;
import net.mobtalker.mobtalker2.server.network.ServerMessageHandler;
import net.mobtalker.mobtalker2.server.script.lib.AbstractInteractionLib;
import net.mobtalker.mobtalkerscript.util.MtsCheck;
import net.mobtalker.mobtalkerscript.v2.BadArgumentException;
import net.mobtalker.mobtalkerscript.v2.ScriptEngineException;
import net.mobtalker.mobtalkerscript.v2.value.MtsType;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import net.mobtalker.mobtalkerscript.v2.value.MtsVarArgs;
import net.mobtalker.mobtalkerscript.v2.value.userdata.MtsNativeFunction;

public class InteractionCommandLib
extends AbstractInteractionLib {
    public InteractionCommandLib(IInteractionAdapter adapter) {
        super(adapter);
    }

    @MtsNativeFunction(name="ShowText")
    public void showText(MtsValue arg1, MtsValue arg2, MtsValue arg3) {
        String name = "";
        if (!arg1.isNil()) {
            name = MtsCheck.checkString(arg1, 0);
        }
        String text = MtsCheck.checkString(arg2, 1);
        boolean isLast = MtsValue.isTrue(arg3);
        try {
            ServerMessageHandler.instance().sendShowText(this.getPlayer(), name, text, isLast);
        }
        catch (InterruptedException ex) {
            throw new InteractionCanceledException();
        }
        catch (Exception ex) {
            throw new ScriptEngineException(ex);
        }
    }

    @MtsNativeFunction(name="ShowMenu")
    public MtsValue showMenu(MtsVarArgs args) {
        int choice;
        String caption = "";
        if (!args.get(0).isNil()) {
            caption = MtsCheck.checkString(args, 0);
        }
        ArrayList options = Lists.newArrayList();
        for (int i = 1; i < args.count(); ++i) {
            options.add(MtsCheck.checkString(args, i));
        }
        try {
            choice = ServerMessageHandler.instance().sendShowMenu(this.getPlayer(), caption, options);
        }
        catch (InterruptedException ex) {
            throw new InteractionCanceledException();
        }
        catch (Exception ex) {
            throw new ScriptEngineException(ex);
        }
        return MtsValue.valueOf(choice);
    }

    private String getPath(MtsValue arg) {
        MtsCheck.checkNotNil(arg);
        if (arg.isString()) {
            return arg.asString().asJavaString();
        }
        if (arg.isTable()) {
            StringBuilder s = new StringBuilder();
            for (MtsValue entry : arg.asTable().listView()) {
                if (s.length() != 0) {
                    s.append("/");
                }
                s.append(entry.asString());
            }
            return s.toString();
        }
        throw new BadArgumentException("expected %s or %s, got %s", MtsType.STRING, MtsType.TABLE, arg.getType());
    }

    @MtsNativeFunction(name="ShowSprite")
    public void showSprite(MtsValue arg1, MtsValue arg2, MtsValue arg3, MtsValue arg4, MtsValue arg5) {
        String group = MtsCheck.checkString(arg1, 0);
        String path = this.getPath(arg2);
        String position = MtsCheck.checkString(arg3, 2, "bottom");
        int offsetX = MtsCheck.checkInteger(arg4, 3, 0);
        int offsetY = MtsCheck.checkInteger(arg5, 4, 0);
        ServerMessageHandler.instance().sendShowSprite(this.getPlayer(), group, path, position, offsetX, offsetY);
    }

    @MtsNativeFunction(name="ShowScene")
    public void showScene(MtsValue arg1, MtsValue arg2) {
        String path = this.getPath(arg1);
        String mode = MtsCheck.checkString(arg2, 1, "fill");
        ServerMessageHandler.instance().sendShowScene(this.getPlayer(), path, mode);
    }

    @MtsNativeFunction(name="HideTexture")
    public void hideTexture(MtsValue arg1) {
        String group = MtsCheck.checkString(arg1, 0);
        ServerMessageHandler.instance().sendHideTexture(this.getPlayer(), group);
    }
}

