/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.network;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.mobtalker.mobtalker2.common.network.ClientToServerMessage;
import net.mobtalker.mobtalker2.common.network.MessageCancelInteraction;
import net.mobtalker.mobtalker2.common.network.MessageHideTexture;
import net.mobtalker.mobtalker2.common.network.MessageShowMenu;
import net.mobtalker.mobtalker2.common.network.MessageShowMenuResponse;
import net.mobtalker.mobtalker2.common.network.MessageShowScene;
import net.mobtalker.mobtalker2.common.network.MessageShowSprite;
import net.mobtalker.mobtalker2.common.network.MessageShowText;
import net.mobtalker.mobtalker2.common.network.NetworkManager;
import net.mobtalker.mobtalker2.common.network.RemoteCallMessage;
import net.mobtalker.mobtalker2.common.network.ServerToClientMessage;
import net.mobtalker.mobtalker2.server.ServerInteractionHandler;
import net.mobtalker.mobtalker2.server.interaction.InteractionRegistry;
import net.mobtalker.mobtalker2.server.network.RemoteCallResult;
import net.mobtalker.mobtalker2.util.EntityUtil;
import net.mobtalker.mobtalker2.util.logging.MobTalkerLog;

public class ServerMessageHandler {
    private static final String LOG_TAG = "ServerMessageHandler";
    private static ServerMessageHandler instance = new ServerMessageHandler();
    private final Map<EntityPlayerMP, RemoteCallResult> _calls = Maps.newHashMap();

    public static ServerMessageHandler instance() {
        return instance;
    }

    private ServerMessageHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteCallResult createFuture(EntityPlayerMP player, RemoteCallMessage msg) {
        Map<EntityPlayerMP, RemoteCallResult> map = this._calls;
        synchronized (map) {
            RemoteCallResult future = this._calls.remove(player);
            if (future != null && !future.isCancelled()) {
                MobTalkerLog.error(LOG_TAG, "Overriding an already pending call for player '%s'!", EntityUtil.getName((EntityPlayer)player));
            }
            future = new RemoteCallResult(msg.getResponseType());
            this._calls.put(player, future);
            return future;
        }
    }

    public void sendShowText(EntityPlayerMP player, String name, String text, boolean isLast) throws InterruptedException, ExecutionException {
        MessageShowText msg = new MessageShowText().setName(name).setText(text).setLast(isLast);
        RemoteCallResult result = this.createFuture(player, msg);
        NetworkManager.sendTo(msg, player);
        result.get();
    }

    public int sendShowMenu(EntityPlayerMP player, String caption, List<String> options) throws InterruptedException, ExecutionException {
        MessageShowMenu msg = new MessageShowMenu().setCaption(caption).setChoices(options);
        RemoteCallResult result = this.createFuture(player, msg);
        NetworkManager.sendTo(msg, player);
        MessageShowMenuResponse response = (MessageShowMenuResponse)result.get();
        return response.getChoice();
    }

    public void sendShowSprite(EntityPlayerMP player, String group, String path, String position, int offsetX, int offsetY) {
        NetworkManager.sendTo(new MessageShowSprite().setGroup(group).setPath(path).setPosition(position).setOffsetX(offsetX).setOffsetY(offsetY), player);
    }

    public void sendShowScene(EntityPlayerMP player, String path, String mode) {
        NetworkManager.sendTo(new MessageShowScene().setPath(path).setMode(mode), player);
    }

    public void sendHideTexture(EntityPlayerMP player, String group) {
        NetworkManager.sendTo(new MessageHideTexture().setGroup(group), player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelCall(EntityPlayer player) {
        Map<EntityPlayerMP, RemoteCallResult> map = this._calls;
        synchronized (map) {
            RemoteCallResult future = this._calls.remove(player);
            if (future != null) {
                future.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllCalls() {
        Map<EntityPlayerMP, RemoteCallResult> map = this._calls;
        synchronized (map) {
            for (RemoteCallResult future : this._calls.values()) {
                future.cancel(true);
            }
            this._calls.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemoteCallResult(EntityPlayerMP player, ClientToServerMessage response) {
        RemoteCallResult future;
        Map<EntityPlayerMP, RemoteCallResult> map = this._calls;
        synchronized (map) {
            future = this._calls.remove(player);
        }
        if (future == null || future.isCancelled()) {
            MobTalkerLog.error(LOG_TAG, "Fetched remote call response for a non-exisiting call");
        }
        if (!future.getResponseType().equals(response.getClass())) {
            throw new IllegalStateException("Remote call response has wrong type. Expected '" + future.getResponseType().getName() + "', got '" + response.getClass().getName() + "'.");
        }
        try {
            future.set(response, null);
        }
        catch (Exception ex) {
            future.set(null, ex);
        }
    }

    public void onCancelInteraction(EntityPlayerMP player, MessageCancelInteraction packet) {
        InteractionRegistry.instance().cancelInteraction((EntityPlayer)player);
        this.cancelCall((EntityPlayer)player);
    }

    public static ServerInteractionHandler getInteractionHandler() {
        return null;
    }

    public static abstract class RemoteCallResultDelegator<REQ extends ClientToServerMessage>
    implements IMessageHandler<REQ, ServerToClientMessage> {
        public ServerToClientMessage onMessage(REQ message, MessageContext ctx) {
            ServerMessageHandler.instance().onRemoteCallResult(ctx.getServerHandler().field_147369_b, (ClientToServerMessage)message);
            return null;
        }
    }

    public static abstract class Delegator<REQ extends ClientToServerMessage>
    implements IMessageHandler<REQ, ServerToClientMessage> {
    }
}

