/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.interaction;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.mobtalker.mobtalker2.server.interaction.IInteractionAdapter;
import net.mobtalker.mobtalker2.server.interaction.InteractionCanceledException;
import net.mobtalker.mobtalker2.server.interaction.InteractionRegistry;
import net.mobtalker.mobtalker2.server.script.InteractionScript;
import net.mobtalker.mobtalker2.util.ChatMessageHelper;
import net.mobtalker.mobtalker2.util.logging.MobTalkerLog;
import net.mobtalker.mobtalkerscript.v2.ScriptRuntimeException;

public class InteractionScriptFutureTask
extends FutureTask<InteractionScript> {
    private static final String LOG_TAG = "ScriptFuture";
    private final IInteractionAdapter _adapter;

    public InteractionScriptFutureTask(InteractionScript script) {
        super(script, null);
        this._adapter = script.getAdapter();
    }

    @Override
    protected void done() {
        try {
            this.get();
            MobTalkerLog.debug(LOG_TAG, "Interaction script ran to completion");
        }
        catch (CancellationException ex) {
            MobTalkerLog.debug(LOG_TAG, "Interaction script was canceled");
        }
        catch (InteractionCanceledException ex) {
            MobTalkerLog.debug(LOG_TAG, "Interaction script was canceled");
        }
        catch (ExecutionException ex) {
            ChatComponentText msg;
            Throwable cause = ex.getCause();
            MobTalkerLog.warn(LOG_TAG, "The interaction script threw an exception", cause);
            if (cause instanceof ScriptRuntimeException) {
                ScriptRuntimeException sre = (ScriptRuntimeException)cause;
                msg = ChatMessageHelper.coloredText(sre.createStackTrace(), EnumChatFormatting.RED, new Object[0]);
            } else {
                msg = ChatMessageHelper.coloredText(ex.getMessage(), EnumChatFormatting.RED, new Object[0]);
            }
            this._adapter.getPlayer().func_145747_a((IChatComponent)msg);
        }
        catch (Exception ex) {
            MobTalkerLog.warn(LOG_TAG, "Unexpected exception while running an interaction script", ex);
        }
        InteractionRegistry.instance().endInteraction(this._adapter);
    }
}

