/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.common.network;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.mobtalker.mobtalker2.client.network.ClientMessageHandler;
import net.mobtalker.mobtalker2.common.network.ClientToServerMessage;
import net.mobtalker.mobtalker2.common.network.MessageShowMenuResponse;
import net.mobtalker.mobtalker2.common.network.RemoteCallMessage;

public class MessageShowMenu
extends RemoteCallMessage {
    private String _caption;
    private List<String> _choices;

    public String getCaption() {
        return this._caption;
    }

    public List<String> getChoices() {
        return this._choices;
    }

    public MessageShowMenu setCaption(String caption) {
        this._caption = caption;
        return this;
    }

    public MessageShowMenu setChoices(List<String> choices) {
        this._choices = choices;
        return this;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this._caption = MessageShowMenu.readString(buf);
        int nChoices = buf.readUnsignedByte();
        this._choices = Lists.newArrayListWithExpectedSize((int)nChoices);
        for (int i = 0; i < nChoices; ++i) {
            this._choices.add(MessageShowMenu.readString(buf));
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        MessageShowMenu.writeString(buf, this._caption);
        buf.writeByte(this._choices.size());
        for (String choice : this._choices) {
            MessageShowMenu.writeString(buf, choice);
        }
    }

    @Override
    public Class<? extends ClientToServerMessage> getResponseType() {
        return MessageShowMenuResponse.class;
    }

    public static class Handler
    extends ClientMessageHandler.Delegator<MessageShowMenu> {
        public ClientToServerMessage onMessage(MessageShowMenu message, MessageContext ctx) {
            ClientMessageHandler.instance().onShowMenu(message);
            return null;
        }
    }
}

