/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.misc;

import java.util.Arrays;

public class IntegerList {
    private static int[] EMPTY_DATA = new int[0];
    private int[] _data = EMPTY_DATA;
    private int _size;

    public final void add(int value) {
        if (this._data.length == this._size) {
            int n = this._size + 1;
            IntegerList integerList = this;
            if (n < 0 || n > 0x7FFFFFF7) {
                throw new OutOfMemoryError();
            }
            int n2 = integerList._data.length == 0 ? 4 : integerList._data.length;
            while (n2 < n) {
                if ((n2 <<= 1) >= 0 && n2 <= 0x7FFFFFF7) continue;
                n2 = 0x7FFFFFF7;
            }
            integerList._data = Arrays.copyOf(integerList._data, n2);
        }
        this._data[this._size] = value;
        ++this._size;
    }

    public final int get(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException();
        }
        return this._data[index];
    }

    public final int removeAt(int index) {
        int value = this.get(index);
        System.arraycopy(this._data, index + 1, this._data, index, this._size - index - 1);
        this._data[this._size - 1] = 0;
        --this._size;
        return value;
    }

    public final boolean isEmpty() {
        return this._size == 0;
    }

    public final int size() {
        return this._size;
    }

    public final void clear() {
        Arrays.fill(this._data, 0, this._size, 0);
        this._size = 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegerList)) {
            return false;
        }
        IntegerList other = (IntegerList)o;
        if (this._size != other._size) {
            return false;
        }
        for (int i = 0; i < this._size; ++i) {
            if (this._data[i] == other._data[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this._size; ++i) {
            hashCode = hashCode * 31 + this._data[i];
        }
        return hashCode;
    }

    public String toString() {
        IntegerList integerList = this;
        return Arrays.toString(integerList._size == 0 ? EMPTY_DATA : Arrays.copyOf(integerList._data, integerList._size));
    }
}

