/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.misc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.antlr.v4.runtime.misc.AbstractEqualityComparator;
import org.antlr.v4.runtime.misc.MurmurHash;
import org.antlr.v4.runtime.misc.ObjectEqualityComparator;

public class Array2DHashSet<T>
implements Set<T> {
    private AbstractEqualityComparator<? super T> comparator;
    private T[][] buckets;
    private int n = 0;
    private int threshold = 12;
    private int currentPrime = 1;
    private int initialBucketCapacity = 8;

    public Array2DHashSet() {
        this(null, 8);
    }

    public Array2DHashSet(AbstractEqualityComparator<? super T> comparator, int initialBucketCapacity) {
        if (comparator == null) {
            comparator = ObjectEqualityComparator.INSTANCE;
        }
        this.comparator = comparator;
        this.buckets = this.createBuckets(16);
        this.initialBucketCapacity = initialBucketCapacity;
    }

    public final T getOrAdd(T o) {
        if (this.n > this.threshold) {
            Array2DHashSet array2DHashSet = this;
            T[][] TArray = array2DHashSet.buckets;
            array2DHashSet.currentPrime += 4;
            int n = array2DHashSet.buckets.length << 1;
            T[][] TArray2 = array2DHashSet.createBuckets(n);
            int[] nArray = new int[TArray2.length];
            array2DHashSet.buckets = TArray2;
            array2DHashSet.threshold = (int)((double)n * 0.75);
            int n2 = array2DHashSet.size();
            T[][] TArray3 = TArray;
            int n3 = TArray.length;
            for (int i = 0; i < n3; ++i) {
                T t;
                T[] TArray4 = TArray3[i];
                if (TArray4 == null) continue;
                T[] TArray5 = TArray4;
                int n4 = TArray4.length;
                for (int j = 0; j < n4 && (t = TArray5[j]) != null; ++j) {
                    T[] TArray6;
                    int n5 = array2DHashSet.getBucket(t);
                    int n6 = nArray[n5];
                    if (n6 == 0) {
                        TArray6 = array2DHashSet.createBucket(array2DHashSet.initialBucketCapacity);
                        TArray2[n5] = TArray6;
                    } else {
                        TArray6 = TArray2[n5];
                        if (n6 == TArray6.length) {
                            TArray6 = Arrays.copyOf(TArray6, TArray6.length << 1);
                            TArray2[n5] = TArray6;
                        }
                    }
                    TArray6[n6] = t;
                    int n7 = n5;
                    nArray[n7] = nArray[n7] + 1;
                }
            }
            assert (array2DHashSet.n == n2);
        }
        return this.getOrAddImpl(o);
    }

    private T getOrAddImpl(T o) {
        int b = this.getBucket(o);
        T[] bucket = this.buckets[b];
        if (bucket == null) {
            T[] TArray = this.createBucket(this.initialBucketCapacity);
            bucket = TArray;
            TArray[0] = o;
            this.buckets[b] = bucket;
            ++this.n;
            return o;
        }
        for (int i = 0; i < bucket.length; ++i) {
            T existing = bucket[i];
            if (existing == null) {
                bucket[i] = o;
                ++this.n;
                return o;
            }
            if (!this.comparator.equals(existing, o)) continue;
            return existing;
        }
        int oldLength = bucket.length;
        bucket = Arrays.copyOf(bucket, bucket.length << 1);
        this.buckets[b] = bucket;
        bucket[oldLength] = o;
        ++this.n;
        return o;
    }

    private int getBucket(T o) {
        return this.comparator.hashCode(o) & this.buckets.length - 1;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        T[][] arr$ = this.buckets;
        int len$ = this.buckets.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            T o;
            T[] bucket = arr$[i$];
            if (bucket == null) continue;
            T[] arr$2 = bucket;
            int len$2 = bucket.length;
            for (int i$2 = 0; i$2 < len$2 && (o = arr$2[i$2]) != null; ++i$2) {
                hash = MurmurHash.update(hash, this.comparator.hashCode(o));
            }
        }
        return MurmurHash.finish(hash, this.size());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Array2DHashSet)) {
            return false;
        }
        Array2DHashSet other = (Array2DHashSet)o;
        if (other.size() != this.size()) {
            return false;
        }
        return this.containsAll(other);
    }

    @Override
    public final boolean add(T t) {
        return this.getOrAdd(t) == t;
    }

    @Override
    public final int size() {
        return this.n;
    }

    @Override
    public final boolean isEmpty() {
        return this.n == 0;
    }

    @Override
    public final boolean contains(Object o) {
        return this.containsFast(this.asElementType(o));
    }

    private boolean containsFast(T obj) {
        T t;
        if (obj == null) {
            return false;
        }
        T t2 = obj;
        Array2DHashSet array2DHashSet = this;
        if (t2 == null) {
            t = t2;
        } else {
            int n = array2DHashSet.getBucket(t2);
            T[] TArray = array2DHashSet.buckets[n];
            if (TArray != null) {
                T t3;
                T[] TArray2 = TArray;
                int n2 = TArray.length;
                for (int i = 0; i < n2 && (t3 = TArray2[i]) != null; ++i) {
                    if (!array2DHashSet.comparator.equals(t3, t2)) continue;
                    t = t3;
                    break;
                }
            } else {
                t = null;
            }
        }
        return t != null;
    }

    @Override
    public Iterator<T> iterator() {
        return new SetIterator(this, this.toArray());
    }

    @Override
    public T[] toArray() {
        T[] a = this.createBucket(this.size());
        int i = 0;
        T[][] arr$ = this.buckets;
        int len$ = this.buckets.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            T o;
            T[] bucket = arr$[i$];
            if (bucket == null) continue;
            T[] arr$2 = bucket;
            int len$2 = bucket.length;
            for (int i$2 = 0; i$2 < len$2 && (o = arr$2[i$2]) != null; ++i$2) {
                a[i++] = o;
            }
        }
        return a;
    }

    @Override
    public <U> U[] toArray(U[] a) {
        if (a.length < this.size()) {
            a = Arrays.copyOf(a, this.size());
        }
        int i = 0;
        T[][] arr$ = this.buckets;
        int len$ = this.buckets.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            T o;
            T[] bucket = arr$[i$];
            if (bucket == null) continue;
            T[] arr$2 = bucket;
            int len$2 = bucket.length;
            for (int i$2 = 0; i$2 < len$2 && (o = arr$2[i$2]) != null; ++i$2) {
                T targetElement = o;
                a[i++] = targetElement;
            }
        }
        return a;
    }

    @Override
    public final boolean remove(Object o) {
        return this.removeFast(this.asElementType(o));
    }

    private boolean removeFast(T obj) {
        if (obj == null) {
            return false;
        }
        int b = this.getBucket(obj);
        T[] bucket = this.buckets[b];
        if (bucket == null) {
            return false;
        }
        for (int i = 0; i < bucket.length; ++i) {
            T e = bucket[i];
            if (e == null) {
                return false;
            }
            if (!this.comparator.equals(e, obj)) continue;
            System.arraycopy(bucket, i + 1, bucket, i, bucket.length - i - 1);
            bucket[bucket.length - 1] = null;
            --this.n;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection instanceof Array2DHashSet) {
            T[][] arr$ = ((Array2DHashSet)collection).buckets;
            int len$ = ((Array2DHashSet)collection).buckets.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                T o;
                T[] bucket = arr$[i$];
                if (bucket == null) continue;
                T[] arr$2 = bucket;
                int len$2 = bucket.length;
                for (int i$2 = 0; i$2 < len$2 && (o = arr$2[i$2]) != null; ++i$2) {
                    if (this.containsFast(this.asElementType(o))) continue;
                    return false;
                }
            }
        } else {
            for (Object o : collection) {
                if (this.containsFast(this.asElementType(o))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean changed = false;
        for (T o : c) {
            if (this.getOrAdd(o) == o) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        int newsize = 0;
        T[][] arr$ = this.buckets;
        int len$ = this.buckets.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int i;
            T[] bucket = arr$[i$];
            if (bucket == null) continue;
            int j = 0;
            for (i = 0; i < bucket.length && bucket[i] != null; ++i) {
                if (!c.contains(bucket[i])) continue;
                if (i != j) {
                    bucket[j] = bucket[i];
                }
                ++j;
                ++newsize;
            }
            newsize += j;
            while (j < i) {
                bucket[j] = null;
                ++j;
            }
        }
        boolean changed = newsize != this.n;
        this.n = newsize;
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed |= this.removeFast(this.asElementType(o));
        }
        return changed;
    }

    @Override
    public void clear() {
        this.buckets = this.createBuckets(16);
        this.n = 0;
    }

    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        boolean first = true;
        T[][] arr$ = this.buckets;
        int len$ = this.buckets.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            T o;
            T[] bucket = arr$[i$];
            if (bucket == null) continue;
            T[] arr$2 = bucket;
            int len$2 = bucket.length;
            for (int i$2 = 0; i$2 < len$2 && (o = arr$2[i$2]) != null; ++i$2) {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(o.toString());
            }
        }
        buf.append('}');
        return buf.toString();
    }

    protected T asElementType(Object o) {
        return (T)o;
    }

    protected T[][] createBuckets(int capacity) {
        return new Object[capacity][];
    }

    protected T[] createBucket(int capacity) {
        return new Object[capacity];
    }

    public class SetIterator
    implements Iterator<T> {
        private T[] data;
        private int nextIndex = 0;
        private boolean removed = true;
        private /* synthetic */ Array2DHashSet this$0;

        public SetIterator(Array2DHashSet array2DHashSet, T[] data) {
            this.this$0 = array2DHashSet;
            this.data = data;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.data.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removed = false;
            return this.data[this.nextIndex++];
        }

        @Override
        public void remove() {
            if (this.removed) {
                throw new IllegalStateException();
            }
            this.this$0.remove(this.data[this.nextIndex - 1]);
            this.removed = true;
        }
    }
}

