/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.dfa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.dfa.DFAState;

public class DFASerializer {
    private DFA dfa;
    private String[] tokenNames;

    public DFASerializer(DFA dfa, String[] tokenNames) {
        this.dfa = dfa;
        this.tokenNames = tokenNames;
    }

    public String toString() {
        if (this.dfa.s0 == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        Object object = this.dfa;
        ArrayList<DFAState> arrayList = new ArrayList<DFAState>(((DFA)object).states.keySet());
        Collections.sort(arrayList, new Comparator<DFAState>(){});
        for (DFAState s : arrayList) {
            int n = 0;
            if (s.edges != null) {
                n = s.edges.length;
            }
            for (int i = 0; i < n; ++i) {
                String string;
                DFAState t = s.edges[i];
                if (t == null || t.stateNumber == Integer.MAX_VALUE) continue;
                buf.append(DFASerializer.getStateString(s));
                int n2 = i;
                object = this;
                if (n2 == 0) {
                    string = "EOF";
                } else {
                    String string2 = ((DFASerializer)object).tokenNames != null ? ((DFASerializer)object).tokenNames[n2 - 1] : String.valueOf(n2 - 1);
                    string = string2;
                }
                String label = string;
                buf.append("-").append(label).append("->").append(DFASerializer.getStateString(t)).append('\n');
            }
        }
        String output = buf.toString();
        if (output.length() == 0) {
            return null;
        }
        return output;
    }

    private static String getStateString(DFAState s) {
        int n = s.stateNumber;
        String baseStateStr = (s.isAcceptState ? ":" : "") + "s" + n + (s.requiresFullContext ? "^" : "");
        if (s.isAcceptState) {
            if (s.predicates != null) {
                return baseStateStr + "=>" + Arrays.toString(s.predicates);
            }
            return baseStateStr + "=>" + s.prediction;
        }
        return baseStateStr;
    }
}

