/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.atn;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.antlr.v4.runtime.atn.ATNConfig;
import org.antlr.v4.runtime.atn.ATNSimulator;
import org.antlr.v4.runtime.atn.PredictionContext;
import org.antlr.v4.runtime.atn.SemanticContext;
import org.antlr.v4.runtime.misc.AbstractEqualityComparator;
import org.antlr.v4.runtime.misc.Array2DHashSet;
import org.antlr.v4.runtime.misc.DoubleKeyMap;

public class ATNConfigSet
implements Set<ATNConfig> {
    private boolean readonly = false;
    public AbstractConfigHashSet configLookup;
    private ArrayList<ATNConfig> configs = new ArrayList(7);
    public int uniqueAlt;
    protected BitSet conflictingAlts;
    public boolean hasSemanticContext;
    public boolean dipsIntoOuterContext;
    public final boolean fullCtx;
    private int cachedHashCode = -1;

    public ATNConfigSet(boolean fullCtx) {
        this.configLookup = new ConfigHashSet();
        this.fullCtx = fullCtx;
    }

    public ATNConfigSet() {
        this(true);
    }

    @Override
    public final boolean add(ATNConfig config) {
        return this.add(config, null);
    }

    public final boolean add(ATNConfig config, DoubleKeyMap<PredictionContext, PredictionContext, PredictionContext> mergeCache) {
        ATNConfig existing;
        if (this.readonly) {
            throw new IllegalStateException("This set is readonly");
        }
        if (config.semanticContext != SemanticContext.NONE) {
            this.hasSemanticContext = true;
        }
        if (config.reachesIntoOuterContext > 0) {
            this.dipsIntoOuterContext = true;
        }
        if ((existing = this.configLookup.getOrAdd(config)) == config) {
            this.cachedHashCode = -1;
            this.configs.add(config);
            return true;
        }
        boolean rootIsWildcard = !this.fullCtx;
        PredictionContext merged = PredictionContext.merge(existing.context, config.context, rootIsWildcard, mergeCache);
        existing.reachesIntoOuterContext = Math.max(existing.reachesIntoOuterContext, config.reachesIntoOuterContext);
        existing.context = merged;
        return true;
    }

    public final void optimizeConfigs(ATNSimulator interpreter) {
        if (this.readonly) {
            throw new IllegalStateException("This set is readonly");
        }
        if (this.configLookup.isEmpty()) {
            return;
        }
        for (ATNConfig config : this.configs) {
            i$.next().context = interpreter.getCachedContext(config.context);
        }
    }

    @Override
    public boolean addAll(Collection<? extends ATNConfig> coll) {
        for (ATNConfig aTNConfig : coll) {
            this.add(aTNConfig, null);
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ATNConfigSet)) {
            return false;
        }
        ATNConfigSet other = (ATNConfigSet)o;
        return this.configs.equals(other.configs) && this.fullCtx == other.fullCtx && this.uniqueAlt == other.uniqueAlt && this.conflictingAlts == other.conflictingAlts && this.hasSemanticContext == other.hasSemanticContext && this.dipsIntoOuterContext == other.dipsIntoOuterContext;
    }

    @Override
    public int hashCode() {
        if (this.readonly) {
            if (this.cachedHashCode == -1) {
                this.cachedHashCode = this.configs.hashCode();
            }
            return this.cachedHashCode;
        }
        return this.configs.hashCode();
    }

    @Override
    public int size() {
        return this.configs.size();
    }

    @Override
    public boolean isEmpty() {
        return this.configs.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (this.configLookup == null) {
            throw new UnsupportedOperationException("This method is not implemented for readonly sets.");
        }
        return this.configLookup.contains(o);
    }

    @Override
    public Iterator<ATNConfig> iterator() {
        return this.configs.iterator();
    }

    @Override
    public void clear() {
        if (this.readonly) {
            throw new IllegalStateException("This set is readonly");
        }
        this.configs.clear();
        this.cachedHashCode = -1;
        this.configLookup.clear();
    }

    public final boolean isReadonly() {
        return this.readonly;
    }

    public final void setReadonly$1385ff() {
        this.readonly = true;
        this.configLookup = null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(((Object)this.configs).toString());
        if (this.hasSemanticContext) {
            buf.append(",hasSemanticContext=").append(this.hasSemanticContext);
        }
        if (this.uniqueAlt != 0) {
            buf.append(",uniqueAlt=").append(this.uniqueAlt);
        }
        if (this.conflictingAlts != null) {
            buf.append(",conflictingAlts=").append(this.conflictingAlts);
        }
        if (this.dipsIntoOuterContext) {
            buf.append(",dipsIntoOuterContext");
        }
        return buf.toString();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.configLookup.toArray((U[])a);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public static abstract class AbstractConfigHashSet
    extends Array2DHashSet<ATNConfig> {
        public AbstractConfigHashSet(AbstractEqualityComparator<? super ATNConfig> comparator) {
            this(comparator, 0);
        }

        private AbstractConfigHashSet(AbstractEqualityComparator<? super ATNConfig> comparator, byte by) {
            super(comparator, 2);
        }
    }

    public static final class ConfigEqualityComparator
    extends AbstractEqualityComparator<ATNConfig> {
        public static final ConfigEqualityComparator INSTANCE = new ConfigEqualityComparator();

        private ConfigEqualityComparator() {
        }
    }

    public static class ConfigHashSet
    extends AbstractConfigHashSet {
        public ConfigHashSet() {
            super(ConfigEqualityComparator.INSTANCE);
        }
    }
}

