/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.value.userdata;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.mobtalker.mobtalkerscript.v2.value.MtsTable;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import net.mobtalker.mobtalkerscript.v2.value.userdata.FixedInstanceMethodAdapter;
import net.mobtalker.mobtalkerscript.v2.value.userdata.FunctionAdapter;
import net.mobtalker.mobtalkerscript.v2.value.userdata.MtsNativeField;
import net.mobtalker.mobtalkerscript.v2.value.userdata.NativeHelpers;
import org.apache.commons.lang3.StringUtils;

final class LibraryAdapter {
    private static final Map<Class<?>, LibraryAdapter> _mappers = Maps.newHashMap();
    private final Map<String, Method> _methods;
    private final Map<String, Field> _fields;

    private static LibraryAdapter getMapper(Class<?> clazz) {
        LibraryAdapter libraryAdapter = _mappers.get(clazz);
        if (libraryAdapter == null) {
            libraryAdapter = new LibraryAdapter(clazz);
            _mappers.put(clazz, libraryAdapter);
        }
        return libraryAdapter;
    }

    public static MtsTable bind(Class<?> clazz) {
        MtsTable mtsTable = new MtsTable(0, 0);
        LibraryAdapter.bind(clazz, mtsTable);
        return mtsTable;
    }

    public static MtsTable bind(Object object) {
        MtsTable mtsTable = new MtsTable(0, 0);
        LibraryAdapter.bind(object, mtsTable);
        return mtsTable;
    }

    public static void bind(Class<?> clazz, MtsTable mtsTable) {
        if (!LibraryAdapter.checkClass(clazz)) {
            throw new IllegalArgumentException(clazz.getSimpleName() + " is not a valid class!");
        }
        LibraryAdapter.getMapper(clazz).createAndBindAdapter(null, mtsTable);
    }

    public static void bind(Object object, MtsTable mtsTable) {
        Class<?> clazz = object.getClass();
        if (!LibraryAdapter.checkClass(clazz)) {
            throw new IllegalArgumentException(clazz.getSimpleName() + " is not a valid class!");
        }
        LibraryAdapter.getMapper(clazz).createAndBindAdapter(object, mtsTable);
    }

    private LibraryAdapter(Class<?> clazz) {
        Preconditions.checkNotNull(clazz);
        this._methods = LibraryAdapter.getMethods(clazz);
        this._fields = LibraryAdapter.getFields(clazz);
    }

    private void createAndBindAdapter(Object object, MtsTable mtsTable) {
        MtsValue mtsValue;
        AccessibleObject accessibleObject;
        String string;
        Set<Map.Entry<String, Method>> set = this._methods.entrySet();
        mtsTable.ensureHashCapacity(set.size());
        for (Map.Entry<String, Method> entry : set) {
            string = entry.getKey();
            accessibleObject = entry.getValue();
            if (Modifier.isStatic(((Method)accessibleObject).getModifiers())) {
                mtsValue = new FunctionAdapter((Method)accessibleObject, string);
            } else if (object != null) {
                mtsValue = new FixedInstanceMethodAdapter(object, (Method)accessibleObject, string);
            } else {
                throw new IllegalArgumentException("A static library cannot contain an annotated non-static method!");
            }
            mtsTable.set(string, mtsValue, false);
        }
        for (Map.Entry<String, AccessibleObject> entry : this._fields.entrySet()) {
            string = entry.getKey();
            accessibleObject = (Field)entry.getValue();
            try {
                mtsValue = (MtsValue)((Field)accessibleObject).get(object);
            }
            catch (Exception exception) {
                throw Throwables.propagate((Throwable)exception);
            }
            mtsTable.set(string, mtsValue);
        }
    }

    private static boolean checkClass(Class<?> clazz) {
        if (clazz.isPrimitive() || clazz.isInterface() || clazz.isAnnotation() || clazz.isArray()) {
            return false;
        }
        return Modifier.isPublic(clazz.getModifiers());
    }

    private static Map<String, Method> getMethods(Class<?> clazz) {
        HashMap hashMap = Maps.newHashMap();
        for (Method method : NativeHelpers.getAnnotatedMethods(clazz)) {
            hashMap.put(NativeHelpers.getMethodName(method), method);
        }
        return hashMap;
    }

    private static Map<String, Field> getFields(Class<?> clazz) {
        HashMap hashMap = Maps.newHashMap();
        AnnotatedElement annotatedElement = clazz;
        Object object = new ArrayList();
        for (Field field : ((Class)annotatedElement).getFields()) {
            Class<?> clazz2;
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !MtsValue.class.isAssignableFrom(clazz2 = field.getType()) || !field.isAnnotationPresent(MtsNativeField.class)) continue;
            object.add(field);
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            annotatedElement = field;
            object = ((Field)annotatedElement).getAnnotation(MtsNativeField.class);
            hashMap.put(object == null || Strings.isNullOrEmpty((String)object.name()) ? StringUtils.capitalize((String)((Field)annotatedElement).getName()) : object.name(), field);
        }
        return hashMap;
    }
}

