/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.value.userdata;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import net.mobtalker.mobtalkerscript.v2.value.MtsType;
import net.mobtalker.mobtalkerscript.v2.value.userdata.MethodAdapter;
import net.mobtalker.mobtalkerscript.v2.value.userdata.MtsNativeClass;
import net.mobtalker.mobtalkerscript.v2.value.userdata.MtsNativeFunction;
import net.mobtalker.mobtalkerscript.v2.value.userdata.MtsNativeType;
import net.mobtalker.mobtalkerscript.v2.value.userdata.NativeHelpers;

final class ClassAdapter {
    private static final Map<Class<?>, ClassAdapter> _mappers = Maps.newHashMap();
    private final MtsType _type;
    private final Map<String, MethodAdapter> _methods;

    public static ClassAdapter get(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        if (!(clazz2.isPrimitive() || clazz2.isInterface() || clazz2.isAnnotation() || clazz2.isArray() ? false : (!Modifier.isPublic(clazz2.getModifiers()) ? false : clazz2.isAnnotationPresent(MtsNativeClass.class)))) {
            throw new IllegalArgumentException(clazz.getSimpleName() + " is not a valid class!");
        }
        ClassAdapter classAdapter = _mappers.get(clazz);
        if (classAdapter == null) {
            classAdapter = new ClassAdapter(clazz);
            _mappers.put(clazz, classAdapter);
        }
        return classAdapter;
    }

    private ClassAdapter(Class<?> clazz) {
        Preconditions.checkNotNull(clazz);
        this._type = ClassAdapter.getType(clazz);
        this._methods = ClassAdapter.createMethodAdapters(clazz);
    }

    public final MtsType getType() {
        return this._type;
    }

    public final MethodAdapter getMethod(String string) {
        return this._methods.get(string);
    }

    private static MtsType getType(Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || field.getType() != MtsType.class || !field.isAnnotationPresent(MtsNativeType.class)) continue;
            try {
                return (MtsType)field.get(null);
            }
            catch (Exception exception) {
                throw Throwables.propagate((Throwable)exception);
            }
        }
        Class<?> clazz2 = clazz;
        MtsNativeFunction mtsNativeFunction = clazz2.getAnnotation(MtsNativeFunction.class);
        return MtsType.forName(mtsNativeFunction == null || Strings.isNullOrEmpty((String)mtsNativeFunction.name()) ? clazz2.getSimpleName().toLowerCase() : mtsNativeFunction.name());
    }

    private static Map<String, MethodAdapter> createMethodAdapters(Class<?> clazz) {
        HashMap hashMap = Maps.newHashMap();
        for (Method method : NativeHelpers.getAnnotatedMethods(clazz)) {
            String string = NativeHelpers.getMethodName(method);
            hashMap.put(string, new MethodAdapter(method, string));
        }
        return hashMap;
    }
}

