/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.value;

import java.util.Iterator;
import java.util.Objects;
import net.mobtalker.mobtalkerscript.v2.ScriptRuntimeException;
import net.mobtalker.mobtalkerscript.v2.value.MtsTable;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;

final class TableHashPart
implements Iterable<MtsTable.Entry> {
    private HashEntry[] _entries;
    private int _threshold;
    private int _count;

    public TableHashPart(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this._entries = new HashEntry[n2];
        this._threshold = (int)((float)n2 * 0.75f);
        this._count = 0;
    }

    private static final int getHashFor(MtsValue mtsValue) {
        if (mtsValue == null || mtsValue.isNil()) {
            return 0;
        }
        int n = mtsValue.hashCode();
        return n ^ n >>> 20 ^ n >>> 12 ^ n >>> 7 ^ n >>> 4;
    }

    private void resize(int n) {
        HashEntry[] hashEntryArray;
        if (this._entries.length == 0x40000000) {
            this._threshold = Integer.MAX_VALUE;
            return;
        }
        HashEntry[] hashEntryArray2 = hashEntryArray = new HashEntry[n];
        TableHashPart tableHashPart = this;
        int n2 = hashEntryArray2.length;
        HashEntry[] hashEntryArray3 = tableHashPart._entries;
        for (int i = 0; i < hashEntryArray3.length; ++i) {
            HashEntry hashEntry;
            HashEntry hashEntry2 = hashEntryArray3[i];
            if (hashEntry2 == null) continue;
            hashEntryArray3[i] = null;
            do {
                hashEntry = hashEntry2.next;
                int n3 = hashEntry2.hash & n2 - 1;
                hashEntry2.next = hashEntryArray2[n3];
                hashEntryArray2[n3] = hashEntry2;
            } while ((hashEntry2 = hashEntry) != null);
        }
        this._entries = hashEntryArray;
        this._threshold = (int)((float)n * 0.75f);
    }

    public final void ensureCapacity(int n) {
        if (n > this._threshold) {
            int n2;
            int n3 = (int)((float)n / 0.75f + 1.0f);
            if (n3 > 0x40000000) {
                n3 = 0x40000000;
            }
            for (n2 = this._entries.length; n2 < n3; n2 <<= 1) {
            }
            if (n2 > this._entries.length) {
                this.resize(n2);
            }
        }
    }

    public final MtsValue remove(MtsValue mtsValue) {
        HashEntry hashEntry;
        int n = TableHashPart.getHashFor(mtsValue);
        int n2 = n & this._entries.length - 1;
        HashEntry hashEntry2 = hashEntry = this._entries[n2];
        while (hashEntry2 != null) {
            HashEntry hashEntry3 = hashEntry2.next;
            if (hashEntry2.hash == n && Objects.equals(mtsValue, hashEntry2.key)) {
                --this._count;
                if (hashEntry == hashEntry2) {
                    this._entries[n2] = hashEntry3;
                } else {
                    hashEntry.next = hashEntry3;
                }
                return hashEntry2.value;
            }
            hashEntry = hashEntry2;
            hashEntry2 = hashEntry3;
        }
        return MtsValue.NIL;
    }

    public final MtsValue get(MtsValue mtsValue) {
        int n = TableHashPart.getHashFor(mtsValue);
        HashEntry hashEntry = this._entries[n & this._entries.length - 1];
        while (hashEntry != null) {
            if (hashEntry.hash == n && Objects.equals(mtsValue, hashEntry.key)) {
                return hashEntry.value;
            }
            hashEntry = hashEntry.next;
        }
        return MtsValue.NIL;
    }

    private void add(MtsValue mtsValue, int n, int n2, MtsValue mtsValue2) {
        HashEntry hashEntry = this._entries[n2];
        this._entries[n2] = new HashEntry(mtsValue, n, mtsValue2, hashEntry);
        ++this._count;
        if (this._count >= this._threshold) {
            this.resize(2 * this._entries.length);
        }
    }

    public final MtsValue set(MtsValue mtsValue, MtsValue mtsValue2) {
        assert (mtsValue != null) : "key was null";
        if (mtsValue.isNil()) {
            throw new ScriptRuntimeException("table index is nil");
        }
        if (mtsValue2.isNil()) {
            return this.remove(mtsValue);
        }
        int n = TableHashPart.getHashFor(mtsValue);
        int n2 = n & this._entries.length - 1;
        HashEntry hashEntry = this._entries[n2];
        while (hashEntry != null) {
            if (hashEntry.hash == n && Objects.equals(mtsValue, hashEntry.key)) {
                MtsValue mtsValue3 = hashEntry.value;
                hashEntry.value = mtsValue2;
                return mtsValue3;
            }
            hashEntry = hashEntry.next;
        }
        this.add(mtsValue, n, n2, mtsValue2);
        return MtsValue.NIL;
    }

    public final MtsTable.Entry getFirst() {
        if (this._count == 0) {
            return null;
        }
        HashEntry hashEntry = null;
        HashEntry[] hashEntryArray = this._entries;
        for (int i = 0; i < hashEntryArray.length; ++i) {
            hashEntry = hashEntryArray[i];
            if (hashEntry == null) continue;
            return hashEntry;
        }
        return hashEntry;
    }

    public final MtsTable.Entry getNext(MtsValue mtsValue) {
        if (mtsValue.isNil()) {
            return this.getFirst();
        }
        int n = TableHashPart.getHashFor(mtsValue);
        HashEntry[] hashEntryArray = this._entries;
        int n2 = n & hashEntryArray.length - 1;
        HashEntry hashEntry = hashEntryArray[n2];
        while (!(hashEntry == null || hashEntry.hash == n && Objects.equals(mtsValue, hashEntry.key))) {
            hashEntry = hashEntry.next;
        }
        if (hashEntry == null) {
            throw new ScriptRuntimeException("invalid key");
        }
        hashEntry = hashEntry.next;
        if (hashEntry == null) {
            ++n2;
            while (n2 < hashEntryArray.length && hashEntry == null) {
                hashEntry = hashEntryArray[n2++];
            }
        }
        return hashEntry;
    }

    public final void clear() {
        HashEntry[] hashEntryArray = this._entries;
        for (int i = 0; i < hashEntryArray.length; ++i) {
            hashEntryArray[i] = null;
        }
        this._count = 0;
    }

    public final int count() {
        return this._count;
    }

    public final String toString() {
        Iterator<MtsTable.Entry> iterator = this.iterator();
        if (!iterator.hasNext()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(iterator.next());
        while (iterator.hasNext()) {
            stringBuilder.append(", ").append(iterator.next());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public final Iterator<MtsTable.Entry> iterator() {
        return new HashIterator(this);
    }

    static final class HashIterator
    implements Iterator<MtsTable.Entry> {
        private final TableHashPart _hashPart;
        private MtsTable.Entry _next;

        public HashIterator(TableHashPart tableHashPart) {
            this._hashPart = tableHashPart;
            this._next = this._hashPart.getFirst();
        }

        @Override
        public final boolean hasNext() {
            return this._next != null;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static final class HashEntry
    extends MtsTable.Entry {
        final int hash;
        HashEntry next;

        HashEntry(MtsValue mtsValue, int n, MtsValue mtsValue2, HashEntry hashEntry) {
            super(mtsValue, mtsValue2);
            this.hash = n;
            this.next = hashEntry;
        }
    }
}

