/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.value;

import com.google.common.base.Strings;
import java.util.Collections;
import net.mobtalker.mobtalkerscript.v2.ScriptRuntimeException;
import net.mobtalker.mobtalkerscript.v2.WrongTypeException;
import net.mobtalker.mobtalkerscript.v2.value.EvaluatedVarArgs;
import net.mobtalker.mobtalkerscript.v2.value.MtsBoolean;
import net.mobtalker.mobtalkerscript.v2.value.MtsClosure;
import net.mobtalker.mobtalkerscript.v2.value.MtsFunction;
import net.mobtalker.mobtalkerscript.v2.value.MtsNil;
import net.mobtalker.mobtalkerscript.v2.value.MtsNumber;
import net.mobtalker.mobtalkerscript.v2.value.MtsString;
import net.mobtalker.mobtalkerscript.v2.value.MtsTable;
import net.mobtalker.mobtalkerscript.v2.value.MtsType;
import net.mobtalker.mobtalkerscript.v2.value.MtsUserdata;
import net.mobtalker.mobtalkerscript.v2.value.MtsVarArgs;

public abstract class MtsValue
implements Comparable<MtsValue> {
    public static final MtsNil NIL = new MtsNil();
    public static final MtsNumber ZERO = MtsNumber.of(0);
    public static final MtsNumber ONE = MtsNumber.of(1);
    public static final MtsBoolean TRUE = new MtsBoolean(true);
    public static final MtsBoolean FALSE = new MtsBoolean(false);
    public static final MtsString EMPTY_STRING = new MtsString("");
    public static final MtsVarArgs EMPTY_VARARGS = new EvaluatedVarArgs(Collections.emptyList());
    public static final MtsString __METATABLE = MtsValue.valueOf("__metatable");
    public static final MtsString __INDEX = MtsValue.valueOf("__index");
    public static final MtsString __NEWINDEX = MtsValue.valueOf("__newindex");
    public static final MtsString __LENGTH = MtsValue.valueOf("__len");
    public static final MtsString __CALL = MtsValue.valueOf("__call");
    public static final MtsString __EQ = MtsValue.valueOf("__eq");
    public static final MtsString __LT = MtsValue.valueOf("__lt");
    public static final MtsString __LTE = MtsValue.valueOf("__lte");
    public static final MtsString __TOSTRING = MtsValue.valueOf("__tostring");

    public static MtsBoolean valueOf(boolean bl) {
        if (bl) {
            return TRUE;
        }
        return FALSE;
    }

    public static MtsNumber valueOf(int n) {
        return MtsNumber.of(n);
    }

    public static MtsNumber valueOf(double d) {
        return MtsNumber.of(d);
    }

    public static MtsString valueOf(String string) {
        return MtsString.of(string);
    }

    public static boolean isTrue(MtsValue mtsValue) {
        return mtsValue != FALSE && mtsValue != NIL;
    }

    public boolean hasMetaTable() {
        return this.getType().hasMetaTable();
    }

    public MtsTable getMetaTable() {
        return this.getType().getMetaTable();
    }

    public void setMetaTable(MtsValue mtsValue) {
        new ScriptRuntimeException("attempt to set metatable of a %s value", this.getType());
    }

    public boolean hasMetaTag(MtsString mtsString) {
        return this.hasMetaTable() && this.getMetaTable().containsKey(mtsString);
    }

    public final MtsValue getMetaTag(MtsString mtsString) {
        if (this.hasMetaTable()) {
            return this.getMetaTable().get(mtsString);
        }
        return NIL;
    }

    public final MtsValue get(String string) {
        return this.get(MtsValue.valueOf(string));
    }

    public final MtsValue get(String string, boolean bl) {
        return this.get(MtsValue.valueOf(string), bl);
    }

    public final MtsValue get(MtsValue mtsValue) {
        return this.get(mtsValue, false);
    }

    public final MtsValue get(MtsValue mtsValue, boolean bl) {
        MtsValue mtsValue2 = this.doGet(mtsValue);
        if (mtsValue2.isNil() && bl) {
            MtsValue mtsValue3 = this.getMetaTag(__INDEX);
            if (mtsValue3.isFunction()) {
                mtsValue2 = mtsValue3.call(this, mtsValue);
            } else if (!mtsValue3.isNil()) {
                mtsValue2 = mtsValue3.get(mtsValue).get();
            }
        }
        return mtsValue2;
    }

    protected MtsValue doGet(MtsValue mtsValue) {
        throw new ScriptRuntimeException("attempt to index a %s value", this.getType());
    }

    public MtsValue get(int n) {
        if (n == 0) {
            return this;
        }
        return NIL;
    }

    public final MtsValue get() {
        return this.get(0);
    }

    public final void set(String string, MtsValue mtsValue) {
        this.set(string, mtsValue, false);
    }

    public final void set(String string, MtsValue mtsValue, boolean bl) {
        this.set(MtsValue.valueOf(string), mtsValue, bl);
    }

    public final void set(MtsValue mtsValue, MtsValue mtsValue2) {
        this.set(mtsValue, mtsValue2, false);
    }

    public final void set(MtsValue mtsValue, MtsValue mtsValue2, boolean bl) {
        MtsValue mtsValue3;
        if (bl && !(mtsValue3 = this.getMetaTag(__NEWINDEX)).isNil()) {
            if (mtsValue3.isFunction()) {
                mtsValue3.call(this, mtsValue, mtsValue2);
                return;
            }
            mtsValue3.set(mtsValue, mtsValue2);
            return;
        }
        this.doSet(mtsValue, mtsValue2);
    }

    protected void doSet(MtsValue mtsValue, MtsValue mtsValue2) {
        throw new ScriptRuntimeException("attempt to index a %s value", this.getType());
    }

    public final MtsValue call() {
        return this.call(EMPTY_VARARGS);
    }

    public final MtsValue call(MtsValue mtsValue) {
        return this.call(MtsVarArgs.of(mtsValue));
    }

    public final MtsValue call(MtsValue mtsValue, MtsValue mtsValue2) {
        return this.call(MtsVarArgs.of(mtsValue, mtsValue2));
    }

    public final MtsValue call(MtsValue mtsValue, MtsValue mtsValue2, MtsValue mtsValue3) {
        return this.call(MtsVarArgs.of(mtsValue, mtsValue2, mtsValue3));
    }

    public MtsValue call(MtsVarArgs mtsVarArgs) {
        MtsValue mtsValue = this.getMetaTag(__CALL);
        if (mtsValue.isNil()) {
            return this.doCall(mtsVarArgs);
        }
        return mtsValue.call(this, mtsVarArgs);
    }

    protected MtsValue doCall(MtsVarArgs mtsVarArgs) {
        throw new ScriptRuntimeException("attempt to call a %s value", this.getType());
    }

    public final MtsNumber getLength() {
        MtsValue mtsValue = this.getMetaTag(__LENGTH);
        if (mtsValue.isNil()) {
            return this.doGetLength();
        }
        return mtsValue.call(this).get().asNumber();
    }

    protected MtsNumber doGetLength() {
        throw new ScriptRuntimeException("attempt to get length of a %s value", this.getType());
    }

    public final MtsBoolean isEqual(MtsValue mtsValue) {
        MtsValue mtsValue2 = this.getMetaTag(__EQ);
        if (mtsValue2.isNil()) {
            return this.doIsEqual(mtsValue);
        }
        return mtsValue2.call(this).get().toMtsBoolean();
    }

    protected MtsBoolean doIsEqual(MtsValue mtsValue) {
        return MtsValue.valueOf(this.equals(mtsValue));
    }

    public final MtsBoolean isLess(MtsValue mtsValue) {
        MtsValue mtsValue2 = this.getMetaTag(__LT);
        if (mtsValue2.isNil()) {
            return this.doIsLess(mtsValue);
        }
        return mtsValue2.call(this).get().toMtsBoolean();
    }

    protected MtsBoolean doIsLess(MtsValue mtsValue) {
        throw new ScriptRuntimeException("attempt to compare %s with %s", this.getType(), mtsValue.getType());
    }

    public final MtsBoolean isLessOrEqual(MtsValue mtsValue) {
        MtsValue mtsValue2 = this.getMetaTag(__LTE);
        if (mtsValue2.isNil()) {
            return this.doIsLessOrEqual(mtsValue);
        }
        return mtsValue2.call(this).get().toMtsBoolean();
    }

    protected MtsBoolean doIsLessOrEqual(MtsValue mtsValue) {
        throw new ScriptRuntimeException("attempt to compare %s with %s", this.getType(), mtsValue.getType());
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isDecimal() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isNil() {
        return false;
    }

    public boolean isUserdata() {
        return false;
    }

    public boolean isClosure() {
        return false;
    }

    public boolean isFunction() {
        return false;
    }

    public boolean isTable() {
        return false;
    }

    public boolean isVarArgs() {
        return false;
    }

    public boolean is(MtsType mtsType) {
        if (this.getType().equals(mtsType)) {
            return true;
        }
        if (this.isTable() && mtsType.hasMetaTable() && this.hasMetaTable()) {
            return mtsType.getMetaTable().equals(this.getMetaTable());
        }
        return false;
    }

    public MtsBoolean asBoolean() {
        throw new WrongTypeException(MtsType.BOOLEAN, this.getType());
    }

    public MtsNumber asNumber() {
        throw new WrongTypeException(MtsType.NUMBER, this.getType());
    }

    public MtsString asString() {
        throw new WrongTypeException(MtsType.STRING, this.getType());
    }

    public MtsUserdata asUserdata() {
        throw new WrongTypeException(MtsType.USERDATA, this.getType());
    }

    public <T> T asNative() {
        throw new WrongTypeException(MtsType.USERDATA, this.getType());
    }

    public MtsClosure asClosure() {
        throw new WrongTypeException(MtsType.FUNCTION, this.getType());
    }

    public MtsFunction asFunction() {
        throw new WrongTypeException(MtsType.FUNCTION, this.getType());
    }

    public MtsTable asTable() {
        throw new WrongTypeException(MtsType.TABLE, this.getType());
    }

    public MtsVarArgs asVarArgs() {
        throw new WrongTypeException(MtsType.VARARGS, this.getType());
    }

    public MtsBoolean toMtsBoolean() {
        return TRUE;
    }

    public MtsNumber toMtsNumber() throws NumberFormatException {
        throw new NumberFormatException("attempt to convert " + this.getType() + " to " + MtsType.NUMBER);
    }

    public MtsString toMtsString() {
        return MtsValue.valueOf(this.toString());
    }

    public String toString() {
        return this.getType() + ": " + Strings.padStart((String)Integer.toHexString(this.hashCode()), (int)8, (char)'0');
    }

    public abstract MtsType getType();

    @Override
    public int compareTo(MtsValue mtsValue) {
        return 0;
    }
}

