/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.value;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import net.mobtalker.mobtalkerscript.v2.ScriptRuntimeException;
import net.mobtalker.mobtalkerscript.v2.value.MtsBoolean;
import net.mobtalker.mobtalkerscript.v2.value.MtsNumber;
import net.mobtalker.mobtalkerscript.v2.value.MtsType;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import net.mobtalker.mobtalkerscript.v2.value.MtsVarArgs;

public class MtsString
extends MtsValue {
    private static final HashMap<String, MtsString> CACHE = Maps.newHashMapWithExpectedSize((int)2048);
    private final String _value;

    public static MtsString of(String string) {
        Preconditions.checkNotNull((Object)string);
        if (string.length() == 0) {
            return EMPTY_STRING;
        }
        MtsString mtsString = CACHE.get(string);
        if (mtsString == null) {
            if (string.length() <= 32) {
                mtsString = new MtsString(string);
                CACHE.put(string, mtsString);
            } else {
                return new MtsString(string);
            }
        }
        return mtsString;
    }

    public static MtsString concat(MtsValue ... mtsValueArray) {
        if (mtsValueArray == null || mtsValueArray.length == 0) {
            return EMPTY_STRING;
        }
        if (mtsValueArray.length == 1) {
            return mtsValueArray[0].toMtsString();
        }
        if (mtsValueArray.length > 2) {
            StringBuilder stringBuilder = new StringBuilder();
            MtsValue[] mtsValueArray2 = mtsValueArray;
            int n = mtsValueArray.length;
            for (int i = 0; i < n; ++i) {
                MtsValue mtsValue = mtsValueArray2[i];
                stringBuilder.append(mtsValue.toMtsString().asJavaString());
            }
            return MtsString.valueOf(stringBuilder.toString());
        }
        return mtsValueArray[0].toMtsString().concat(mtsValueArray[1]);
    }

    public static MtsString concat(MtsVarArgs mtsVarArgs) {
        if (mtsVarArgs == null || mtsVarArgs.isEmpty()) {
            return EMPTY_STRING;
        }
        int n = mtsVarArgs.count();
        if (n == 1) {
            return mtsVarArgs.get(0).toMtsString();
        }
        if (n > 2) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < mtsVarArgs.count(); ++i) {
                MtsValue mtsValue = mtsVarArgs.get(i);
                stringBuilder.append(mtsValue.toMtsString().asJavaString());
            }
            return MtsString.valueOf(stringBuilder.toString());
        }
        return mtsVarArgs.get(0).toMtsString().concat(mtsVarArgs.get(1));
    }

    public static MtsString concat(Iterable<MtsValue> iterable) {
        if (iterable == null) {
            return EMPTY_STRING;
        }
        Iterator<MtsValue> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return EMPTY_STRING;
        }
        MtsValue mtsValue = iterator.next();
        if (!iterator.hasNext()) {
            return mtsValue.toMtsString();
        }
        StringBuilder stringBuilder = new StringBuilder(mtsValue.toMtsString().asJavaString());
        while (iterator.hasNext()) {
            mtsValue = iterator.next();
            stringBuilder.append(mtsValue.toMtsString().asJavaString());
        }
        return MtsString.valueOf(stringBuilder.toString());
    }

    MtsString(String string) {
        this._value = string;
    }

    public MtsString concat(MtsValue mtsValue) {
        return MtsString.valueOf(this._value.concat(mtsValue.toMtsString().asJavaString()));
    }

    public MtsString intern() {
        if (!CACHE.containsKey(this._value)) {
            CACHE.put(this._value, this);
            return this;
        }
        return this;
    }

    @Override
    protected MtsValue doGet(MtsValue mtsValue) {
        return NIL;
    }

    @Override
    protected MtsBoolean doIsLess(MtsValue mtsValue) {
        if (!mtsValue.isString()) {
            throw new ScriptRuntimeException("attempt to compare %s with %s", this.getType(), mtsValue.getType());
        }
        return MtsString.valueOf(this._value.compareTo(mtsValue.asString().asJavaString()) < 0);
    }

    @Override
    protected MtsBoolean doIsLessOrEqual(MtsValue mtsValue) {
        if (!mtsValue.isString()) {
            throw new ScriptRuntimeException("attempt to compare %s with %s", this.getType(), mtsValue.getType());
        }
        return MtsString.valueOf(this._value.compareTo(mtsValue.asString().asJavaString()) <= 0);
    }

    @Override
    protected MtsNumber doGetLength() {
        return MtsString.valueOf(this._value.length());
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public MtsString asString() {
        return this;
    }

    public String asJavaString() {
        return this._value;
    }

    @Override
    public MtsType getType() {
        return MtsType.STRING;
    }

    @Override
    public MtsString toMtsString() {
        return this;
    }

    @Override
    public MtsNumber toMtsNumber() throws NumberFormatException {
        return MtsString.valueOf(Double.parseDouble(this._value));
    }

    @Override
    public String toString() {
        return this._value;
    }

    public int hashCode() {
        return this._value.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof MtsString)) {
            return false;
        }
        return ((MtsString)object).asJavaString().equals(this._value);
    }

    @Override
    public int compareTo(MtsValue mtsValue) {
        if (!mtsValue.isString()) {
            return 0;
        }
        return this._value.compareTo(mtsValue.asString().asJavaString());
    }
}

