/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.value;

import net.mobtalker.mobtalkerscript.v2.value.MtsNumber;
import net.mobtalker.mobtalkerscript.v2.value.MtsString;
import net.mobtalker.mobtalkerscript.v2.value.MtsType;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;

public class MtsBoolean
extends MtsValue {
    private final boolean _value;
    private final Boolean _obj;
    private final String _string;
    private final MtsString _stringValue;

    public static MtsBoolean parse(MtsString mtsString) {
        return MtsBoolean.valueOf(Boolean.parseBoolean(mtsString.asJavaString()));
    }

    public static MtsBoolean parse(MtsNumber mtsNumber) {
        return MtsBoolean.valueOf((double)((int)mtsNumber.asJavaDouble()) != 0.0);
    }

    MtsBoolean(boolean bl) {
        this._value = bl;
        this._obj = bl;
        this._string = Boolean.toString(bl);
        this._stringValue = MtsBoolean.valueOf(this._string);
    }

    public MtsBoolean or(MtsBoolean mtsBoolean) {
        return MtsBoolean.valueOf(this._value || mtsBoolean._value);
    }

    public MtsBoolean and(MtsBoolean mtsBoolean) {
        return MtsBoolean.valueOf(this._value && mtsBoolean._value);
    }

    public MtsBoolean not() {
        return MtsBoolean.valueOf(!this._value);
    }

    @Override
    public MtsBoolean asBoolean() {
        return this;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public MtsType getType() {
        return MtsType.BOOLEAN;
    }

    @Override
    public MtsString toMtsString() {
        return this._stringValue;
    }

    @Override
    public MtsBoolean toMtsBoolean() {
        return this;
    }

    public boolean toJavaValue() {
        return this._value;
    }

    public boolean isTrue() {
        return this._value;
    }

    @Override
    public String toString() {
        return this._string;
    }

    public int hashCode() {
        return this._obj.hashCode();
    }

    public boolean equals(Object object) {
        return object == this;
    }
}

