/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.lib;

import java.util.Random;
import net.mobtalker.mobtalkerscript.util.MtsCheck;
import net.mobtalker.mobtalkerscript.v2.value.MtsNumber;
import net.mobtalker.mobtalkerscript.v2.value.MtsString;
import net.mobtalker.mobtalkerscript.v2.value.MtsTable;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import net.mobtalker.mobtalkerscript.v2.value.MtsVarArgs;
import net.mobtalker.mobtalkerscript.v2.value.userdata.MtsNativeFunction;

public final class MtsTableLib {
    private static final Random _rnd = new Random();

    @MtsNativeFunction
    public static MtsString concat(MtsValue mtsValue, MtsValue mtsValue2, MtsValue mtsValue3, MtsValue mtsValue4) {
        String string;
        MtsTable mtsTable = MtsCheck.checkTable(mtsValue, 0);
        String string2 = string = mtsValue2.isNil() ? "" : MtsCheck.checkString(mtsValue2, 1);
        if (mtsValue3.isNil()) {
            return mtsTable.concatList(string);
        }
        int n = MtsCheck.checkInteger(mtsValue3, 2);
        if (mtsValue4.isNil()) {
            return mtsTable.concatList(string, n);
        }
        int n2 = MtsCheck.checkInteger(mtsValue4, 3);
        return mtsTable.concatList(string, n, n2);
    }

    @MtsNativeFunction
    public static MtsNumber count(MtsValue mtsValue) {
        return MtsValue.valueOf(MtsCheck.checkTable(mtsValue, 0).count());
    }

    @MtsNativeFunction
    public static void insert(MtsValue mtsValue, MtsValue mtsValue2, MtsValue mtsValue3) {
        MtsTable mtsTable = MtsCheck.checkTable(mtsValue, 0);
        if (mtsValue3.isNil()) {
            mtsTable.add(mtsValue2);
        }
        MtsCheck.checkNumber(mtsValue2, 1);
        mtsTable.insert(mtsValue2.asNumber(), mtsValue3);
    }

    @MtsNativeFunction
    public static MtsValue random(MtsVarArgs mtsVarArgs) {
        if (mtsVarArgs.isEmpty()) {
            return MtsValue.NIL;
        }
        if (mtsVarArgs.count() > 1) {
            return mtsVarArgs.get(_rnd.nextInt(mtsVarArgs.count()));
        }
        MtsValue mtsValue = mtsVarArgs.get(0);
        if (mtsValue.isTable()) {
            MtsTable mtsTable = mtsValue.asTable();
            if (mtsTable.listSize() == 0) {
                return MtsValue.NIL;
            }
            MtsNumber mtsNumber = MtsValue.valueOf(_rnd.nextInt(mtsTable.listSize()) + 1);
            return mtsTable.get(mtsNumber);
        }
        return mtsValue;
    }

    @MtsNativeFunction
    public static MtsValue remove(MtsValue mtsValue, MtsValue mtsValue2) {
        MtsTable mtsTable = MtsCheck.checkTable(mtsValue, 0);
        if (mtsValue2.isNil()) {
            return mtsTable.removeLast();
        }
        return mtsTable.remove(MtsCheck.checkInteger(mtsValue2, 1));
    }
}

