/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.lib;

import com.google.common.collect.Lists;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import net.mobtalker.mobtalkerscript.util.MtsCheck;
import net.mobtalker.mobtalkerscript.v2.MtsFunctionPrototype;
import net.mobtalker.mobtalkerscript.v2.MtsGlobals;
import net.mobtalker.mobtalkerscript.v2.ScriptEngineException;
import net.mobtalker.mobtalkerscript.v2.ScriptRuntimeException;
import net.mobtalker.mobtalkerscript.v2.compiler.MtsCompiler;
import net.mobtalker.mobtalkerscript.v2.compiler.MtsSyntaxError;
import net.mobtalker.mobtalkerscript.v2.value.MtsClosure;
import net.mobtalker.mobtalkerscript.v2.value.MtsTable;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import net.mobtalker.mobtalkerscript.v2.value.userdata.MtsNativeFunction;

public class MtsPackageLib {
    private final MtsGlobals _G;
    private String _basePath;
    private final List<String> _searchPaths;
    private final MtsTable _loadedPackages;

    public MtsPackageLib(MtsGlobals mtsGlobals) {
        this(mtsGlobals, ".");
    }

    public MtsPackageLib(MtsGlobals mtsGlobals, String string) {
        this._G = mtsGlobals;
        this._loadedPackages = new MtsTable(0, 1);
        this._basePath = string;
        this._searchPaths = Lists.newArrayList((Object[])new String[]{"/?.mts", "/?.script", "/lib/?.mts", "/lib/?.script"});
    }

    public String getBasePath() {
        return this._basePath;
    }

    public void setBasePath(String string) {
        this._basePath = string;
    }

    public void addModule(String string, MtsTable mtsTable) {
        this._loadedPackages.set(string, (MtsValue)mtsTable);
    }

    @MtsNativeFunction(name="require")
    public MtsValue require(MtsValue mtsValue) {
        String string = MtsCheck.checkString(mtsValue, 0);
        MtsValue mtsValue2 = this._loadedPackages.get(string);
        if (!mtsValue2.isNil()) {
            return mtsValue2;
        }
        for (String string2 : this._searchPaths) {
            MtsFunctionPrototype mtsFunctionPrototype;
            Path path = Paths.get((this._basePath + string2).replace("?", string), new String[0]);
            this._G.out.println("Searching path '" + path.toString() + " for module '" + string + "'");
            if (!Files.exists(path, new LinkOption[0])) continue;
            try {
                mtsFunctionPrototype = MtsCompiler.loadFile(path);
            }
            catch (MtsSyntaxError mtsSyntaxError) {
                throw mtsSyntaxError;
            }
            catch (Exception exception) {
                throw new ScriptEngineException(exception);
            }
            mtsValue2 = new MtsClosure(mtsFunctionPrototype, this._G).call();
            this._loadedPackages.set(string, mtsValue2);
            return mtsValue2;
        }
        throw new ScriptRuntimeException("module '%s' not found", string);
    }
}

