/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.lib;

import java.util.Random;
import net.mobtalker.mobtalkerscript.util.MtsCheck;
import net.mobtalker.mobtalkerscript.v2.BadArgumentException;
import net.mobtalker.mobtalkerscript.v2.value.MtsNumber;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import net.mobtalker.mobtalkerscript.v2.value.MtsVarArgs;
import net.mobtalker.mobtalkerscript.v2.value.userdata.MtsNativeField;
import net.mobtalker.mobtalkerscript.v2.value.userdata.MtsNativeFunction;

public final class MtsMathLib {
    @MtsNativeField
    public static final MtsNumber PI = MtsValue.valueOf(Math.PI);
    @MtsNativeField
    public static final MtsNumber E = MtsValue.valueOf(Math.E);
    @MtsNativeField
    public static final MtsNumber Epsilon = MtsValue.valueOf(Double.longBitsToDouble(4368491638549381120L));
    private static final Random _rnd = new Random();

    @MtsNativeFunction
    public static MtsNumber abs(MtsValue mtsValue) {
        return MtsValue.valueOf(Math.abs(MtsCheck.checkNumber(mtsValue, 0)));
    }

    @MtsNativeFunction
    public static MtsNumber ceil(MtsValue mtsValue) {
        return MtsValue.valueOf(Math.ceil(MtsCheck.checkNumber(mtsValue, 0)));
    }

    @MtsNativeFunction
    public static MtsNumber cos(MtsValue mtsValue) {
        return MtsValue.valueOf(Math.cos(MtsCheck.checkNumber(mtsValue, 0)));
    }

    @MtsNativeFunction
    public static MtsNumber cosH(MtsValue mtsValue) {
        return MtsValue.valueOf(Math.cosh(MtsCheck.checkNumber(mtsValue, 0)));
    }

    @MtsNativeFunction
    public static MtsNumber floor(MtsValue mtsValue) {
        return MtsValue.valueOf(Math.floor(MtsCheck.checkNumber(mtsValue, 0)));
    }

    @MtsNativeFunction
    public static MtsNumber log(MtsValue mtsValue) {
        return MtsValue.valueOf(Math.log(MtsCheck.checkNumber(mtsValue, 0)));
    }

    @MtsNativeFunction
    public static MtsNumber log10(MtsValue mtsValue) {
        return MtsValue.valueOf(Math.log10(MtsCheck.checkNumber(mtsValue, 0)));
    }

    @MtsNativeFunction
    public static MtsNumber max(MtsVarArgs mtsVarArgs) {
        if (mtsVarArgs.isEmpty()) {
            throw new BadArgumentException("got no value", new Object[0]);
        }
        double d = MtsCheck.checkNumber(mtsVarArgs, 0);
        for (int i = 1; i < mtsVarArgs.count(); ++i) {
            d = Math.max(d, MtsCheck.checkNumber(mtsVarArgs, i));
        }
        return MtsValue.valueOf(d);
    }

    @MtsNativeFunction
    public static MtsNumber min(MtsVarArgs mtsVarArgs) {
        if (mtsVarArgs.isEmpty()) {
            throw new BadArgumentException("got no value", new Object[0]);
        }
        double d = MtsCheck.checkNumber(mtsVarArgs, 0);
        for (int i = 1; i < mtsVarArgs.count(); ++i) {
            d = Math.min(d, MtsCheck.checkNumber(mtsVarArgs, i));
        }
        return MtsValue.valueOf(d);
    }

    @MtsNativeFunction
    public static MtsNumber pow(MtsValue mtsValue, MtsValue mtsValue2) {
        return MtsValue.valueOf(Math.pow(MtsCheck.checkNumber(mtsValue, 0), MtsCheck.checkNumber(mtsValue2, 1)));
    }

    @MtsNativeFunction
    public static MtsNumber random(MtsValue mtsValue, MtsValue mtsValue2) {
        if (mtsValue2.isNil()) {
            if (mtsValue.isNil()) {
                return MtsValue.valueOf(_rnd.nextDouble());
            }
            MtsValue mtsValue3 = mtsValue;
            return MtsValue.valueOf(_rnd.nextInt(MtsCheck.checkInteger(mtsValue3, 0)));
        }
        int n = MtsCheck.checkInteger(mtsValue, 0);
        int n2 = MtsCheck.checkInteger(mtsValue2, 1);
        return MtsValue.valueOf(n + _rnd.nextInt(n2));
    }

    @MtsNativeFunction
    public static MtsNumber round(MtsValue mtsValue) {
        return MtsValue.valueOf(Math.round(MtsCheck.checkNumber(mtsValue, 0)));
    }

    @MtsNativeFunction
    public static MtsNumber sin(MtsValue mtsValue) {
        return MtsValue.valueOf(Math.sin(MtsCheck.checkNumber(mtsValue, 0)));
    }

    @MtsNativeFunction
    public static MtsNumber sinH(MtsValue mtsValue) {
        return MtsValue.valueOf(Math.sinh(MtsCheck.checkNumber(mtsValue, 0)));
    }

    @MtsNativeFunction
    public static MtsNumber sign(MtsValue mtsValue) {
        return MtsValue.valueOf(Math.signum(MtsCheck.checkNumber(mtsValue, 0)));
    }

    @MtsNativeFunction
    public static MtsNumber sqrt(MtsValue mtsValue) {
        return MtsValue.valueOf(Math.sqrt(MtsCheck.checkNumber(mtsValue, 0)));
    }

    @MtsNativeFunction
    public static MtsNumber tan(MtsValue mtsValue) {
        return MtsValue.valueOf(Math.tan(MtsCheck.checkNumber(mtsValue, 0)));
    }

    @MtsNativeFunction
    public static MtsNumber tanH(MtsValue mtsValue) {
        return MtsValue.valueOf(Math.tanh(MtsCheck.checkNumber(mtsValue, 0)));
    }

    @MtsNativeFunction
    public static MtsNumber toDegrees(MtsValue mtsValue) {
        return MtsValue.valueOf(Math.toDegrees(MtsCheck.checkNumber(mtsValue, 0)));
    }

    @MtsNativeFunction
    public static MtsNumber toRadians(MtsValue mtsValue) {
        return MtsValue.valueOf(Math.toRadians(MtsCheck.checkNumber(mtsValue, 0)));
    }
}

