/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.lib;

import net.mobtalker.mobtalkerscript.util.MtsCheck;
import net.mobtalker.mobtalkerscript.v2.MtsFunctionPrototype;
import net.mobtalker.mobtalkerscript.v2.MtsGlobals;
import net.mobtalker.mobtalkerscript.v2.ScriptRuntimeException;
import net.mobtalker.mobtalkerscript.v2.compiler.MtsCompiler;
import net.mobtalker.mobtalkerscript.v2.value.MtsBoolean;
import net.mobtalker.mobtalkerscript.v2.value.MtsClosure;
import net.mobtalker.mobtalkerscript.v2.value.MtsFunction;
import net.mobtalker.mobtalkerscript.v2.value.MtsNumber;
import net.mobtalker.mobtalkerscript.v2.value.MtsString;
import net.mobtalker.mobtalkerscript.v2.value.MtsTable;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import net.mobtalker.mobtalkerscript.v2.value.MtsVarArgs;
import net.mobtalker.mobtalkerscript.v2.value.userdata.MtsNativeField;
import net.mobtalker.mobtalkerscript.v2.value.userdata.MtsNativeFunction;

public final class MtsBaseLib {
    @MtsNativeField
    public final MtsGlobals _G;

    public MtsBaseLib(MtsGlobals mtsGlobals) {
        this._G = mtsGlobals;
    }

    @MtsNativeFunction(name="assert")
    public final void assertMts(MtsValue mtsValue, MtsValue mtsValue2) {
        if (!MtsBoolean.isTrue(mtsValue)) {
            String string = mtsValue2.isNil() ? "assertion failed!" : mtsValue2.toMtsString().asJavaString();
            throw new ScriptRuntimeException(string);
        }
    }

    @MtsNativeFunction(name="error")
    public final void error(MtsValue mtsValue, MtsValue mtsValue2) {
        if (mtsValue2.isNil()) {
            throw new ScriptRuntimeException(mtsValue.toMtsString().asJavaString());
        }
        throw new ScriptRuntimeException(mtsValue2.asNumber().asJavaInt(), mtsValue.toMtsString().asJavaString());
    }

    @MtsNativeFunction(name="inext")
    public final MtsValue inext(MtsValue mtsValue, MtsValue mtsValue2) {
        MtsNumber mtsNumber;
        MtsCheck.checkTable(mtsValue, 1);
        if (mtsValue2.isNil()) {
            mtsNumber = MtsValue.ZERO;
        } else {
            MtsCheck.checkNumber(mtsValue2, 1);
            mtsNumber = mtsValue2.asNumber();
        }
        MtsTable.Entry entry = mtsValue.asTable().getINext(mtsNumber);
        if (entry == null) {
            return MtsValue.EMPTY_VARARGS;
        }
        return MtsVarArgs.of(entry.getKey(), entry.getValue());
    }

    @MtsNativeFunction(name="next")
    public final MtsValue next(MtsValue mtsValue, MtsValue mtsValue2) {
        MtsCheck.checkTable(mtsValue, 1);
        MtsTable.Entry entry = mtsValue.asTable().getNext(mtsValue2);
        if (entry == null) {
            return MtsValue.EMPTY_VARARGS;
        }
        return MtsVarArgs.of(entry.getKey(), entry.getValue());
    }

    @MtsNativeFunction(name="print")
    public final void print(MtsVarArgs mtsVarArgs) {
        if (mtsVarArgs.count() > 0) {
            MtsString mtsString = MtsString.concat(mtsVarArgs);
            this._G.out.println(mtsString.asJavaString());
            return;
        }
        this._G.out.println();
    }

    @MtsNativeFunction(name="rawget")
    public final MtsValue rawGet(MtsValue mtsValue, MtsValue mtsValue2) {
        return MtsCheck.checkTable(mtsValue, 0).get(mtsValue2);
    }

    @MtsNativeFunction(name="rawset")
    public final void rawSet(MtsValue mtsValue, MtsValue mtsValue2, MtsValue mtsValue3) {
        MtsCheck.checkTable(mtsValue, 0).set(mtsValue2, mtsValue3);
    }

    @MtsNativeFunction(name="GetMetatable")
    public final MtsTable getMetaTable(MtsValue mtsValue) {
        MtsTable mtsTable = MtsCheck.checkTable(mtsValue, 0);
        if (mtsTable.hasMetaTag(MtsValue.__METATABLE)) {
            throw new ScriptRuntimeException("cannot retrieve a protected metatable");
        }
        return mtsTable.getMetaTable();
    }

    @MtsNativeFunction(name="SetMetatable")
    public final MtsTable setMetaTable(MtsValue mtsValue, MtsValue mtsValue2) {
        MtsTable mtsTable = MtsCheck.checkTable(mtsValue, 0);
        if (mtsTable.hasMetaTag(MtsValue.__METATABLE)) {
            throw new ScriptRuntimeException("cannot change a protected metatable");
        }
        mtsTable.setMetaTable(mtsValue2);
        return mtsTable;
    }

    @MtsNativeFunction(name="toNumber")
    public final MtsValue toNumber(MtsValue mtsValue) {
        try {
            return mtsValue.toMtsNumber();
        }
        catch (NumberFormatException numberFormatException) {
            return MtsValue.NIL;
        }
    }

    @MtsNativeFunction(name="toString")
    public final MtsString toString(MtsValue mtsValue) {
        return mtsValue.toMtsString();
    }

    @MtsNativeFunction(name="typeof")
    public final MtsString typeOf(MtsValue mtsValue) {
        return MtsValue.valueOf(mtsValue.getType().getName());
    }

    @MtsNativeFunction(name="LoadString")
    public final MtsFunction loadString(MtsVarArgs mtsVarArgs) {
        MtsFunctionPrototype mtsFunctionPrototype;
        try {
            mtsFunctionPrototype = MtsCompiler.loadString(MtsCheck.checkString(mtsVarArgs, 0), "string");
        }
        catch (Exception exception) {
            throw new ScriptRuntimeException("Unable to load string: %s", exception.getMessage());
        }
        MtsValue mtsValue = mtsVarArgs.get(1);
        if (mtsValue.isNil()) {
            mtsValue = this._G;
        }
        return new MtsClosure(mtsFunctionPrototype, mtsValue);
    }

    @MtsNativeFunction(name="pcall")
    public final MtsValue pCall(MtsVarArgs mtsVarArgs) {
        MtsVarArgs mtsVarArgs2;
        MtsValue mtsValue = mtsVarArgs.get(0);
        MtsVarArgs mtsVarArgs3 = mtsVarArgs.subArgs(1);
        try {
            MtsValue mtsValue2 = mtsValue.call(mtsVarArgs3);
            mtsVarArgs2 = mtsValue2.isVarArgs() ? MtsVarArgs.of((MtsValue)MtsValue.TRUE, mtsValue2.asVarArgs()) : MtsVarArgs.of((MtsValue)MtsValue.TRUE, mtsValue2);
        }
        catch (ScriptRuntimeException scriptRuntimeException) {
            mtsVarArgs2 = MtsVarArgs.of((MtsValue)MtsValue.FALSE, MtsValue.valueOf(scriptRuntimeException.getMessage()));
        }
        return mtsVarArgs2;
    }
}

