/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.instruction;

import net.mobtalker.mobtalkerscript.v2.instruction.MtsFrame;
import net.mobtalker.mobtalkerscript.v2.instruction.MtsInstruction;
import net.mobtalker.mobtalkerscript.v2.value.MtsTailcall;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import net.mobtalker.mobtalkerscript.v2.value.MtsVarArgs;

public final class InstrCall
extends MtsInstruction {
    private final int _nArgs;
    private final int _nReturn;

    InstrCall(int n, int n2) {
        this._nArgs = n;
        this._nReturn = n2;
    }

    @Override
    public final void execute(MtsFrame mtsFrame) {
        MtsValue[] mtsValueArray = new MtsValue[this._nArgs];
        for (int i = this._nArgs - 1; i >= 0; --i) {
            mtsValueArray[i] = mtsFrame.pop();
        }
        MtsValue mtsValue = mtsFrame.pop().call(MtsVarArgs.of(mtsValueArray));
        if (mtsValue instanceof MtsTailcall) {
            ((MtsTailcall)mtsValue).evaluate();
        }
        if (this._nReturn == 0) {
            return;
        }
        if (mtsValue.isVarArgs()) {
            MtsVarArgs mtsVarArgs = mtsValue.asVarArgs();
            for (int i = 0; i < this._nReturn; ++i) {
                mtsFrame.push(mtsVarArgs.get(i));
            }
            return;
        }
        mtsFrame.push(mtsValue);
        for (int i = 1; i < this._nReturn; ++i) {
            mtsFrame.push(MtsValue.NIL);
        }
    }

    @Override
    public final int stackSizeChange() {
        return -(1 + this._nArgs) + this._nReturn;
    }

    @Override
    public final String toString() {
        return "CALL " + this._nArgs + " " + this._nReturn;
    }
}

