/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.compiler.antlr;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.mobtalker.mobtalkerscript.util.logging.MtsLog;
import net.mobtalker.mobtalkerscript.v2.compiler.ITreePattern;
import net.mobtalker.mobtalkerscript.v2.compiler.MtsCompiler;
import net.mobtalker.mobtalkerscript.v2.compiler.TreeMultiPattern;
import net.mobtalker.mobtalkerscript.v2.compiler.TreePattern;
import net.mobtalker.mobtalkerscript.v2.compiler.antlr.MtsBaseVisitor;
import net.mobtalker.mobtalkerscript.v2.compiler.antlr.MtsParser;
import net.mobtalker.mobtalkerscript.v2.value.MtsBoolean;
import net.mobtalker.mobtalkerscript.v2.value.MtsNumber;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;

public class AntlrCompilerAdapter
extends MtsBaseVisitor<Void> {
    private static final ITreePattern TableAssignPattern = new TreeMultiPattern(new TreePattern(MtsParser.AssignExprContext.class), new TreePattern(MtsParser.VarExprListContext.class, MtsParser.AssignExprContext.class));
    private final MtsCompiler _c;

    public AntlrCompilerAdapter(MtsCompiler mtsCompiler) {
        Preconditions.checkNotNull((Object)mtsCompiler);
        this._c = mtsCompiler;
    }

    public void compile(MtsParser.ChunkContext chunkContext) {
        this.visit(chunkContext);
    }

    @Override
    public Void visitChunk(MtsParser.ChunkContext chunkContext) {
        MtsLog.CompilerLog.info("Enter Chunk", new Object[0]);
        if (chunkContext.getChild(0) instanceof MtsParser.ExprContext) {
            this.visitChildren(chunkContext);
            this._c.returnFunction(1);
        } else {
            this.visitChildren(chunkContext);
            this._c.returnFunction(0);
        }
        MtsLog.CompilerLog.info("Exit Chunk", new Object[0]);
        return null;
    }

    private void visitSingleOrCreateTable(List<MtsParser.ExprContext> list) {
        this.visit(list);
        int n = list.size();
        if (n > 1) {
            this._c.createTable(n, 0);
        }
    }

    @Override
    public Void visitCommandSay(MtsParser.CommandSayContext commandSayContext) {
        this._c.loadVariable("ShowText");
        if (commandSayContext.Character == null) {
            this._c.loadNil();
        } else {
            this.visit(commandSayContext.Character);
        }
        this.visit(commandSayContext.Text);
        this._c.loadConstant(MtsValue.valueOf(commandSayContext.IsLast != null));
        this._c.callFunction(3, 0);
        return null;
    }

    @Override
    public Void visitCommandShow(MtsParser.CommandShowContext commandShowContext) {
        this._c.loadVariable("ShowSprite");
        this.visit(commandShowContext.Group);
        this.visitSingleOrCreateTable(commandShowContext.Path);
        if (commandShowContext.Position == null) {
            this._c.loadNil();
        } else {
            this.visit(commandShowContext.Position);
        }
        if (commandShowContext.Offset == null) {
            this._c.loadConstant(MtsValue.ZERO);
            this._c.loadConstant(MtsValue.ZERO);
        } else {
            this.visit(commandShowContext.Offset.Exprs.get(0));
            if (commandShowContext.Offset.Exprs.size() < 2) {
                this._c.loadConstant(MtsValue.ZERO);
            } else {
                this.visit(commandShowContext.Offset.Exprs.get(1));
            }
        }
        this._c.callFunction(5, 0);
        return null;
    }

    @Override
    public Void visitCommandScene(MtsParser.CommandSceneContext commandSceneContext) {
        this._c.loadVariable("ShowScene");
        this.visitSingleOrCreateTable(commandSceneContext.Path);
        if (commandSceneContext.Mode == null) {
            this._c.loadNil();
        } else {
            this.visit(commandSceneContext.Mode);
        }
        this._c.callFunction(2, 0);
        return null;
    }

    @Override
    public Void visitCommandHide(MtsParser.CommandHideContext commandHideContext) {
        this._c.loadVariable("HideTexture");
        if (commandHideContext.Group != null) {
            this.visit(commandHideContext.Group);
        } else if (commandHideContext.Scene != null) {
            this._c.loadConstant(commandHideContext.Scene.getText());
        } else {
            throw new AssertionError();
        }
        this._c.callFunction(1, 0);
        return null;
    }

    @Override
    public Void visitCommandMenu(MtsParser.CommandMenuContext commandMenuContext) {
        int n;
        this._c.loadVariable("ShowMenu");
        if (commandMenuContext.Caption == null) {
            this._c.loadNil();
        } else {
            this.visit(commandMenuContext.Caption);
        }
        int n2 = this._c.declareAnonymousLocal("choice").getIndex();
        int n3 = commandMenuContext.Options.size();
        for (n = 0; n < n3; ++n) {
            this.visit(commandMenuContext.Options.get((int)n).Caption);
        }
        this._c.callFunction(n3 + 1, 1);
        this._c.storeLocal(n2);
        this._c.enterIfThenElseBlock();
        this._c.enterBlock();
        for (n = 0; n < n3; ++n) {
            if (n > 0) {
                this._c.enterIfCondition();
            }
            this._c.loadLocal(n2);
            this._c.loadConstant(MtsValue.valueOf(n));
            this._c.logicOperation("==");
            this._c.endIfCondition();
            this.visit(commandMenuContext.Options.get((int)n).Block);
            this._c.endThenBlock();
        }
        this._c.exitBlock();
        this._c.exitIfThenElse();
        return null;
    }

    private static List<String> getParameterNames(MtsParser.FuncBodyContext funcBodyContext) {
        ArrayList arrayList = Lists.newArrayList();
        MtsParser.FuncBodyContext funcBodyContext2 = funcBodyContext;
        if (funcBodyContext2.getParent() instanceof MtsParser.FuncDeclrStmtContext && ((MtsParser.FuncDeclrStmtContext)funcBodyContext2.getParent()).Name.MethodName != null) {
            arrayList.add("self");
        }
        if (funcBodyContext.Params != null) {
            for (Token token : funcBodyContext.Params.NameList.Names) {
                arrayList.add(token.getText());
            }
        }
        return arrayList;
    }

    @Override
    public Void visitFuncName(MtsParser.FuncNameContext funcNameContext) {
        if (funcNameContext.TableKeys.isEmpty() && funcNameContext.MethodName == null) {
            this._c.storeVariable(funcNameContext.RootName.getText());
        } else {
            this._c.loadVariable(funcNameContext.RootName.getText());
            if (!funcNameContext.TableKeys.isEmpty()) {
                this._c.loadConstant(funcNameContext.TableKeys.get(0).getText());
                for (int i = 0; i < funcNameContext.TableKeys.size(); ++i) {
                    this._c.loadFromTable();
                    this._c.loadConstant(funcNameContext.TableKeys.get(i).getText());
                }
            }
            if (funcNameContext.MethodName != null) {
                this._c.loadFromTable();
                this._c.loadConstant(funcNameContext.MethodName.getText());
            }
            this._c.storeInTable();
        }
        return null;
    }

    @Override
    public Void visitFuncDeclrStmt(MtsParser.FuncDeclrStmtContext funcDeclrStmtContext) {
        this.visit(funcDeclrStmtContext.Body);
        this.visit(funcDeclrStmtContext.Name);
        return null;
    }

    @Override
    public Void visitLocalFuncDeclrStmt(MtsParser.LocalFuncDeclrStmtContext localFuncDeclrStmtContext) {
        String string = localFuncDeclrStmtContext.Name.getText();
        this._c.declareLocal(string);
        this.visit(localFuncDeclrStmtContext.Body);
        this._c.storeVariable(string);
        return null;
    }

    @Override
    public Void visitFuncBody(MtsParser.FuncBodyContext funcBodyContext) {
        String string;
        ParserRuleContext parserRuleContext = funcBodyContext.getParent();
        if (parserRuleContext instanceof MtsParser.FuncDeclrStmtContext) {
            MtsParser.FuncNameContext funcNameContext = ((MtsParser.FuncDeclrStmtContext)parserRuleContext).Name;
            string = funcNameContext.MethodName != null ? funcNameContext.MethodName.getText() : (!funcNameContext.TableKeys.isEmpty() ? funcNameContext.TableKeys.get(funcNameContext.TableKeys.size() - 1).getText() : funcNameContext.RootName.getText());
        } else if (parserRuleContext instanceof MtsParser.LocalFuncDeclrStmtContext) {
            string = ((MtsParser.LocalFuncDeclrStmtContext)parserRuleContext).Name.getText();
        } else if (parserRuleContext instanceof MtsParser.FuncDeclrExprContext) {
            string = "Anonymous Function";
        } else {
            throw new AssertionError();
        }
        String string2 = string;
        int n = funcBodyContext.getStart().getLine();
        int n2 = funcBodyContext.getStop().getLine();
        List<String> list = AntlrCompilerAdapter.getParameterNames(funcBodyContext);
        this._c.enterFunction(string2, n, n2, list);
        this.visit(funcBodyContext.Body);
        this._c.exitFunction();
        this._c.createClosure();
        return null;
    }

    @Override
    public Void visitSimpleAssignmentStmt(MtsParser.SimpleAssignmentStmtContext simpleAssignmentStmtContext) {
        int n = simpleAssignmentStmtContext.Targets.ExprList.size();
        this.adjustExprListResults(simpleAssignmentStmtContext.Exprs.Exprs, n);
        this.visit(simpleAssignmentStmtContext.Targets);
        return null;
    }

    @Override
    public Void visitVarExprList(MtsParser.VarExprListContext varExprListContext) {
        this.visit(Lists.reverse(varExprListContext.ExprList));
        return null;
    }

    @Override
    public Void visitLocalVarDeclrStmt(MtsParser.LocalVarDeclrStmtContext localVarDeclrStmtContext) {
        for (Token object : localVarDeclrStmtContext.NameList.Names) {
            this._c.declareLocal(object.getText());
        }
        if (localVarDeclrStmtContext.ExprList == null) {
            return null;
        }
        int n = localVarDeclrStmtContext.NameList.Names.size();
        this.adjustExprListResults(localVarDeclrStmtContext.ExprList.Exprs, n);
        for (Token token : Lists.reverse(localVarDeclrStmtContext.NameList.Names)) {
            this._c.storeVariable(token.getText());
        }
        return null;
    }

    @Override
    public Void visitCallArgs(MtsParser.CallArgsContext callArgsContext) {
        int n = 0;
        if (callArgsContext.Method != null) {
            String string = callArgsContext.Method.getText();
            this._c.loadMethod(string);
            ++n;
        }
        if (callArgsContext.Arg != null) {
            this._c.loadConstant(callArgsContext.Arg.getText());
            ++n;
        } else if (callArgsContext.Args != null) {
            this.visit(callArgsContext.Args);
            n += callArgsContext.Args.Exprs.size();
        }
        MtsParser.CallArgsContext callArgsContext2 = callArgsContext;
        if (callArgsContext2.getParent() instanceof MtsParser.CallContext && callArgsContext2.getParent().getParent() instanceof MtsParser.CallExprContext && callArgsContext2.getParent().getParent().getParent() instanceof MtsParser.ExprListContext && callArgsContext2.getParent().getParent().getParent().getParent() instanceof MtsParser.ReturnStmtContext) {
            this._c.tailCall(n, callArgsContext.nReturn);
        } else {
            this._c.callFunction(n, callArgsContext.nReturn);
        }
        return null;
    }

    @Override
    public Void visitCall(MtsParser.CallContext callContext) {
        if (callContext.getParent() instanceof MtsParser.StmtContext) {
            callContext.nReturn = 0;
        }
        callContext.Args.get((int)(callContext.Args.size() - 1)).nReturn = callContext.nReturn;
        return this.visitChildren(callContext);
    }

    @Override
    public Void visitReturnStmt(MtsParser.ReturnStmtContext returnStmtContext) {
        int n = 0;
        if (returnStmtContext.ExprList != null) {
            n = returnStmtContext.ExprList.getChildCount();
            this.visit(returnStmtContext.ExprList);
        }
        this._c.returnFunction(n);
        return null;
    }

    @Override
    public Void visitVarExpr(MtsParser.VarExprContext varExprContext) {
        if (varExprContext.Suffixes.isEmpty()) {
            if (TableAssignPattern.matches(varExprContext.getParent())) {
                String string = varExprContext.Root.getText();
                this._c.storeVariable(string);
            } else {
                this._c.loadVariable(varExprContext.Root.getText());
            }
            return null;
        }
        if (varExprContext.Root != null) {
            this._c.loadVariable(varExprContext.Root.getText());
        } else {
            this.visit(varExprContext.RootExpr);
        }
        this.visit(varExprContext.Suffixes.get(0));
        for (int i = 1; i < varExprContext.Suffixes.size(); ++i) {
            this._c.loadFromTable();
            MtsParser.VarSuffixContext varSuffixContext = varExprContext.Suffixes.get(i);
            this.visit(varSuffixContext);
        }
        if (TableAssignPattern.matches(varExprContext.getParent())) {
            this._c.storeInTable();
        } else {
            this._c.loadFromTable();
        }
        return null;
    }

    @Override
    public Void visitNameFieldAccess(MtsParser.NameFieldAccessContext nameFieldAccessContext) {
        String string = nameFieldAccessContext.Field.getText();
        this._c.loadConstant(string);
        return null;
    }

    @Override
    public Void visitTableCtor(MtsParser.TableCtorContext tableCtorContext) {
        if (tableCtorContext.FieldDefs.isEmpty()) {
            this._c.createTable(0, 0);
            return null;
        }
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)((tableCtorContext.FieldDefs.size() + 1) / 2));
        int n = 0;
        for (MtsParser.FieldDefContext fieldDefContext : tableCtorContext.FieldDefs) {
            if (fieldDefContext instanceof MtsParser.ListFieldContext) {
                arrayList.add((MtsParser.ListFieldContext)fieldDefContext);
                continue;
            }
            this.visit(fieldDefContext);
            ++n;
        }
        this.visit(Lists.reverse((List)arrayList));
        this._c.createTable(arrayList.size(), n);
        return null;
    }

    @Override
    public Void visitNameKeyField(MtsParser.NameKeyFieldContext nameKeyFieldContext) {
        this._c.loadConstant(nameKeyFieldContext.Key.getText());
        this.visit(nameKeyFieldContext.Value);
        return null;
    }

    @Override
    public Void visitNestedBlock(MtsParser.NestedBlockContext nestedBlockContext) {
        this._c.enterBlock();
        this.visit(nestedBlockContext.Block);
        this._c.exitBlock();
        return null;
    }

    @Override
    public Void visitLabelStmt(MtsParser.LabelStmtContext labelStmtContext) {
        this._c.declareLabel(labelStmtContext.Name.getText());
        return null;
    }

    @Override
    public Void visitGotoStmt(MtsParser.GotoStmtContext gotoStmtContext) {
        this._c.gotoLabel(gotoStmtContext.Target.getText());
        return null;
    }

    @Override
    public Void visitIfThenElse(MtsParser.IfThenElseContext ifThenElseContext) {
        this._c.enterIfThenElseBlock();
        this._c.enterBlock();
        this.visit(ifThenElseContext.Condition);
        this._c.endIfCondition();
        this.visit(ifThenElseContext.Block);
        this._c.endThenBlock();
        this.visit(ifThenElseContext.ElseIfs);
        if (ifThenElseContext.Else != null) {
            this.visit(ifThenElseContext.Else);
        }
        this._c.exitBlock();
        this._c.exitIfThenElse();
        return null;
    }

    @Override
    public Void visitElseIfBody(MtsParser.ElseIfBodyContext elseIfBodyContext) {
        this._c.enterIfCondition();
        this.visit(elseIfBodyContext.Condition);
        this._c.endIfCondition();
        this.visit(elseIfBodyContext.Block);
        this._c.endThenBlock();
        return null;
    }

    @Override
    public Void visitElseBody(MtsParser.ElseBodyContext elseBodyContext) {
        this._c.enterElseBlock();
        this.visit(elseBodyContext.Block);
        return null;
    }

    @Override
    public Void visitWhileLoop(MtsParser.WhileLoopContext whileLoopContext) {
        this._c.enterWhileLoop();
        this.visit(whileLoopContext.Condition);
        this._c.enterWhileBody();
        this.visit(whileLoopContext.Block);
        this._c.exitWhileLoop();
        return null;
    }

    @Override
    public Void visitRepeatLoop(MtsParser.RepeatLoopContext repeatLoopContext) {
        this._c.enterRepeatLoop();
        this.visit(repeatLoopContext.Block);
        this._c.enterUntilConditon();
        this.visit(repeatLoopContext.Condition);
        this._c.exitRepeatLoop();
        return null;
    }

    @Override
    public Void visitNumericForLoop(MtsParser.NumericForLoopContext numericForLoopContext) {
        this.visit(numericForLoopContext.Control.Start);
        this.visit(numericForLoopContext.Control.Limit);
        if (numericForLoopContext.Control.Step != null) {
            this.visit(numericForLoopContext.Control.Step);
        } else {
            this._c.loadConstant(MtsValue.ONE);
        }
        this._c.enterNumericForLoop(numericForLoopContext.Control.Var.getText());
        this.visit(numericForLoopContext.Block);
        this._c.exitForLoop();
        return null;
    }

    @Override
    public Void visitGenericForLoop(MtsParser.GenericForLoopContext genericForLoopContext) {
        this.adjustExprListResults(genericForLoopContext.Control.Exprs.Exprs, 3);
        MtsParser.NameListContext nameListContext = genericForLoopContext.Control.Vars;
        String[] stringArray = new String[nameListContext.Names.size()];
        for (int i = 0; i < nameListContext.Names.size(); ++i) {
            stringArray[i] = nameListContext.Names.get(i).getText();
        }
        this._c.enterGenericForLoop(stringArray);
        this.visit(genericForLoopContext.Block);
        this._c.exitForLoop();
        return null;
    }

    @Override
    public Void visitUnaryOpExpr(MtsParser.UnaryOpExprContext unaryOpExprContext) {
        if ("-".equals(unaryOpExprContext.Operator.getText()) && unaryOpExprContext.Expr instanceof MtsParser.NumberLiteralContext) {
            MtsParser.NumberLiteralContext numberLiteralContext = new MtsParser.NumberLiteralContext(unaryOpExprContext);
            numberLiteralContext.addChild(new CommonToken("-" + unaryOpExprContext.Expr.getText()));
            this.visit(numberLiteralContext);
        } else {
            this.visit(unaryOpExprContext.Expr);
            this._c.unaryOperation(unaryOpExprContext.Operator.getText());
        }
        return null;
    }

    @Override
    public Void visitBinaryOpExpr(MtsParser.BinaryOpExprContext binaryOpExprContext) {
        this.visit(binaryOpExprContext.Left);
        this.visit(binaryOpExprContext.Right);
        this._c.binaryOperation(binaryOpExprContext.Operator.getText());
        return null;
    }

    @Override
    public Void visitLogicalOpExpr(MtsParser.LogicalOpExprContext logicalOpExprContext) {
        this.visit(logicalOpExprContext.Left);
        this.visit(logicalOpExprContext.Right);
        this._c.logicOperation(logicalOpExprContext.Operator.getText());
        return null;
    }

    @Override
    public Void visitConditionalOpExpr(MtsParser.ConditionalOpExprContext conditionalOpExprContext) {
        this.visit(conditionalOpExprContext.Left);
        this._c.enterConditionalBlock(conditionalOpExprContext.Operator.getText());
        this.visit(conditionalOpExprContext.Right);
        this._c.exitConditionalBlock();
        return null;
    }

    @Override
    public Void visitNullLiteral(MtsParser.NullLiteralContext nullLiteralContext) {
        this._c.loadNil();
        return null;
    }

    @Override
    public Void visitNumberLiteral(MtsParser.NumberLiteralContext numberLiteralContext) {
        MtsNumber mtsNumber = MtsCompiler.parseNumber(numberLiteralContext.getText());
        this._c.loadConstant(mtsNumber);
        return null;
    }

    @Override
    public Void visitBooleanLiteral(MtsParser.BooleanLiteralContext booleanLiteralContext) {
        MtsBoolean mtsBoolean = MtsCompiler.parseBoolean(booleanLiteralContext.getText());
        this._c.loadConstant(mtsBoolean);
        return null;
    }

    @Override
    public Void visitStringLiteral(MtsParser.StringLiteralContext stringLiteralContext) {
        this._c.interpolateString(stringLiteralContext.getText());
        return null;
    }

    @Override
    public Void visit(ParseTree parseTree) {
        if (parseTree instanceof ParserRuleContext) {
            ParserRuleContext parserRuleContext = (ParserRuleContext)parseTree;
            int n = parserRuleContext.start.getLine();
            int n2 = parserRuleContext.start.getCharPositionInLine();
            this._c.setSourcePosition(n, n2);
        }
        return (Void)super.visit(parseTree);
    }

    @Override
    public Void visitChildren(RuleNode ruleNode) {
        if (ruleNode instanceof ParserRuleContext) {
            ParserRuleContext parserRuleContext = (ParserRuleContext)ruleNode;
            int n = parserRuleContext.start.getLine();
            int n2 = parserRuleContext.start.getCharPositionInLine();
            this._c.setSourcePosition(n, n2);
        }
        return (Void)super.visitChildren(ruleNode);
    }

    public void visit(Iterable<? extends ParserRuleContext> iterable) {
        for (ParserRuleContext parserRuleContext : iterable) {
            this.visit(parserRuleContext);
        }
    }

    private void adjustExprListResults(List<MtsParser.ExprContext> list, int n) {
        int n2 = list.size();
        for (int i = 0; i < list.size(); ++i) {
            MtsParser.ExprContext exprContext = list.get(i);
            if (exprContext instanceof MtsParser.CallExprContext) {
                MtsParser.CallContext callContext = ((MtsParser.CallExprContext)exprContext).Call;
                if (i == n2 - 1) {
                    callContext.nReturn = n + 1 - n2;
                    n2 = n;
                } else {
                    callContext.nReturn = i < n ? 1 : 0;
                }
                this.visit(callContext);
                continue;
            }
            this.visit(exprContext);
            if (i < n) continue;
            this._c.discardValue();
        }
        this._c.loadNil(n - n2);
    }
}

