/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2;

import com.google.common.collect.Lists;
import java.util.List;
import net.mobtalker.mobtalkerscript.v2.MtsStackTraceElement;
import net.mobtalker.mobtalkerscript.v2.compiler.SourcePosition;

public class ScriptRuntimeException
extends RuntimeException {
    private final int _level;
    private final List<MtsStackTraceElement> _stackTrace = Lists.newArrayList();

    public ScriptRuntimeException(String string) {
        this(0, string);
    }

    public ScriptRuntimeException(int n, String string) {
        super(string);
        this._level = n;
    }

    public ScriptRuntimeException(String string, Object ... objectArray) {
        this(0, String.format(string, objectArray));
    }

    public ScriptRuntimeException(int n, String string, Object ... objectArray) {
        this(n, String.format(string, objectArray));
    }

    public int getLevel() {
        return this._level;
    }

    public void addStackTraceElement(MtsStackTraceElement mtsStackTraceElement) {
        this._stackTrace.add(mtsStackTraceElement);
    }

    public void addStackTraceElement(String string, SourcePosition sourcePosition, String string2) {
        this._stackTrace.add(new MtsStackTraceElement.Compiled(string, sourcePosition, string2));
    }

    public void addStackTraceElement(String string) {
        this._stackTrace.add(new MtsStackTraceElement.Native(string));
    }

    public String createStackTrace() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Exception: ").append(this.getMessage()).append("\n");
        stringBuilder.append("Stack traceback:");
        for (int i = this._level; i < this._stackTrace.size(); ++i) {
            stringBuilder.append("\n  ").append(this._stackTrace.get(i).toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.createStackTrace();
    }
}

