/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.util;

import java.util.Collection;
import java.util.NoSuchElementException;

public class Queue<T> {
    private T[] _array;
    private int _head;
    private int _tail;

    public static <T> Queue<T> newQueue() {
        return new Queue<T>();
    }

    public static <T> Queue<T> newQueue(Collection<T> collection) {
        Queue<T> queue = new Queue<T>(collection.size());
        for (T t : collection) {
            queue.offer(t);
        }
        return queue;
    }

    public Queue() {
        this(10);
    }

    public Queue(int n) {
        this._array = new Object[n];
        this._head = 0;
        this._tail = 0;
    }

    private int incrIndex(int n) {
        if (++n == this._array.length) {
            n = 0;
        }
        return n;
    }

    public void offer(T t) {
        this._tail = this.incrIndex(this._tail);
        if (this._tail == this._head) {
            Object[] objectArray = new Object[this._array.length << 1];
            if (this._head <= this._tail) {
                int n = this._tail - this._head;
                if (n == 0) {
                    System.arraycopy(this._array, this._head, objectArray, 0, this._array.length);
                    this._head = 0;
                    this._tail = this._array.length;
                } else {
                    System.arraycopy(this._array, this._head, objectArray, 0, n);
                    this._head = 0;
                    this._tail = n - 1;
                }
            } else {
                int n = this._array.length - this._head;
                int n2 = this._tail + 1;
                System.arraycopy(this._array, this._head, objectArray, 0, n);
                System.arraycopy(this._array, 0, objectArray, n, n2);
                this._head = 0;
                this._tail = n + n2 - 1;
            }
            this._array = objectArray;
        }
        this._array[this._tail] = t;
    }

    public T poll() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Queue is empty");
        }
        this._head = this.incrIndex(this._head);
        return this._array[this._head];
    }

    public T peek() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Queue is empty");
        }
        return this._array[this._head];
    }

    public boolean isEmpty() {
        return this._head == this._tail;
    }

    public void clear() {
        this._head = 0;
        this._tail = 0;
    }
}

