/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.scriptpack;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.mobtalker.mobtalker2.MobTalker2;
import net.mobtalker.mobtalker2.server.scriptpack.AbstractScriptPack;
import net.mobtalker.mobtalker2.server.scriptpack.IScriptFile;
import net.mobtalker.mobtalker2.server.scriptpack.RegularScriptFile;
import net.mobtalker.mobtalker2.server.scriptpack.ScriptPackEntry;
import net.mobtalker.mobtalker2.server.scriptpack.config.InteractionScriptConfig;
import net.mobtalker.mobtalker2.server.scriptpack.config.ScriptPackConfig;
import net.mobtalker.mobtalker2.server.scriptpack.config.ScriptPackConfigException;
import net.mobtalker.mobtalker2.util.logging.MobTalkerLog;
import org.apache.commons.lang3.StringUtils;

public class FolderScriptPack
extends AbstractScriptPack {
    private static final String LOG_TAG = "ScriptPack";

    public static boolean isValid(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        Path configFile = path.resolve("MobTalker2.pack");
        boolean hasConfig = Files.exists(configFile, new LinkOption[0]);
        return hasConfig;
    }

    public static FolderScriptPack from(Path path) throws IOException {
        MobTalkerLog.info(LOG_TAG, "Reading FolderScriptPack '%s'", MobTalker2.getResourcePackPath(new String[0]).relativize(path));
        Path configFile = path.resolve("MobTalker2.pack");
        ScriptPackConfig config = ScriptPackConfig.read(configFile);
        FolderScriptPack pack = new FolderScriptPack(path, config);
        return pack;
    }

    public FolderScriptPack(Path path, ScriptPackConfig config) throws IOException {
        super(path, config.getTitle(), config.getVersion(), config.getDescription(), config.getAuthors());
        this._isResourcePack = Files.isDirectory(this._path.resolve("assets/mobtalker/"), new LinkOption[0]);
        this.createEntries(config.getInteractionScripts());
    }

    private void createEntries(List<InteractionScriptConfig> configs) throws IOException {
        for (InteractionScriptConfig config : configs) {
            this.addEntry(config.getEntity(), new ScriptPackEntry(this, this.checkPaths(config.getFiles()), config.getSavedVariables(), config.getSavedVariablesPerPlayer()));
        }
    }

    private List<IScriptFile> checkPaths(List<String> stringPaths) throws IOException {
        ArrayList files = Lists.newArrayListWithExpectedSize((int)stringPaths.size());
        for (String stringPath : stringPaths) {
            Path path = this._path.resolve(stringPath = StringUtils.replaceChars((String)stringPath, (char)'\\', (char)'/')).toAbsolutePath().normalize();
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                throw new ScriptPackConfigException("script path '%s' does not exist, is not a valid file or cannot be read", stringPath);
            }
            if (!path.startsWith(this._path)) {
                throw new ScriptPackConfigException("script path '%s' is not a valid sub-path of it's pack path", stringPath);
            }
            files.add(new RegularScriptFile(path.toRealPath(new LinkOption[0])));
        }
        return files;
    }
}

