/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.scriptpack;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.mobtalker.mobtalker2.server.scriptpack.AbstractScriptPack;
import net.mobtalker.mobtalker2.server.scriptpack.IScriptFile;
import net.mobtalker.mobtalker2.server.scriptpack.RegularScriptFile;
import net.mobtalker.mobtalker2.server.scriptpack.ScriptPackEntry;

public class DefaultScriptPack
extends AbstractScriptPack {
    public DefaultScriptPack(Path path) throws IOException {
        super(path, "Default", "", "The default script pack", Collections.emptyList());
        this.createEntries();
    }

    private void createEntries() throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this._path, "*.{script,mts}");){
            for (Path path : stream) {
                String name = path.getFileName().toString();
                name = name.substring(0, name.lastIndexOf(46));
                RegularScriptFile file = new RegularScriptFile(path);
                Set<String> sv = Collections.emptySet();
                Set<String> svpp = Collections.emptySet();
                this.addEntry(name, new ScriptPackEntry(this, (List<IScriptFile>)ImmutableList.of((Object)file), sv, svpp));
            }
        }
        catch (IOException ex) {
            throw new IOException("Unable to read default script pack directory", ex);
        }
    }
}

