/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.script.lib;

import java.util.Collection;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.mobtalker.mobtalker2.server.interaction.IInteractionAdapter;
import net.mobtalker.mobtalker2.server.script.lib.AbstractMobTalkerLib;
import net.mobtalker.mobtalker2.util.EntityUtil;
import net.mobtalker.mobtalker2.util.PotionUtil;
import net.mobtalker.mobtalkerscript.util.MtsCheck;
import net.mobtalker.mobtalkerscript.v2.BadArgumentException;
import net.mobtalker.mobtalkerscript.v2.value.MtsBoolean;
import net.mobtalker.mobtalkerscript.v2.value.MtsString;
import net.mobtalker.mobtalkerscript.v2.value.MtsTable;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import net.mobtalker.mobtalkerscript.v2.value.MtsVarArgs;
import net.mobtalker.mobtalkerscript.v2.value.userdata.MtsNativeFunction;

public abstract class AbstractMobTalkerEntityLib<T extends EntityLivingBase>
extends AbstractMobTalkerLib {
    private static final MtsString EFFECT_KEY_NAME = MtsValue.valueOf("name");
    private static final MtsString EFFECT_KEY_DURATION = MtsValue.valueOf("duration");
    private static final MtsString EFFECT_KEY_AMPLIFIER = MtsValue.valueOf("amplifier");

    protected AbstractMobTalkerEntityLib(IInteractionAdapter adapter) {
        super(adapter);
    }

    protected abstract T getEntity();

    @MtsNativeFunction
    public MtsString getName() {
        String name = EntityUtil.getName(this.getEntity());
        return MtsValue.valueOf(name);
    }

    @MtsNativeFunction
    public MtsVarArgs getHealth() {
        T player = this.getEntity();
        float health = player.func_110143_aJ();
        float maxHealth = player.func_110138_aP();
        return MtsVarArgs.of((MtsValue)MtsValue.valueOf(health), MtsValue.valueOf(maxHealth));
    }

    @MtsNativeFunction
    public MtsVarArgs getPosition() {
        T entity = this.getEntity();
        return MtsVarArgs.of(MtsValue.valueOf(MathHelper.func_76128_c((double)((EntityLivingBase)entity).field_70165_t)), MtsValue.valueOf(MathHelper.func_76128_c((double)((EntityLivingBase)entity).field_70163_u)), MtsValue.valueOf(MathHelper.func_76128_c((double)((EntityLivingBase)entity).field_70161_v)));
    }

    @MtsNativeFunction
    public MtsBoolean isRiding() {
        boolean isRiding = ((EntityLivingBase)this.getEntity()).field_70154_o != null;
        return MtsValue.valueOf(isRiding);
    }

    @MtsNativeFunction
    public MtsTable getEffects() {
        Collection effects = this.getEntity().func_70651_bq();
        MtsTable t = new MtsTable(effects.size(), 0);
        if (effects.isEmpty()) {
            return t;
        }
        for (PotionEffect effect : effects) {
            MtsTable effectTable = new MtsTable(0, 3);
            String name = PotionUtil.getName(effect.func_76456_a());
            int duration = effect.func_76459_b();
            int amplifier = effect.func_76458_c();
            effectTable.set(EFFECT_KEY_NAME, (MtsValue)MtsValue.valueOf(name));
            effectTable.set(EFFECT_KEY_DURATION, (MtsValue)MtsValue.valueOf(duration));
            effectTable.set(EFFECT_KEY_AMPLIFIER, (MtsValue)MtsValue.valueOf(amplifier));
            t.add(effectTable);
        }
        return t;
    }

    @MtsNativeFunction
    public MtsBoolean applyEffect(MtsValue arg1, MtsValue arg2, MtsValue arg3) {
        String effectName = MtsCheck.checkString(arg1, 0);
        int duration = MtsCheck.checkInteger(arg2, 1);
        int amplifier = MtsCheck.checkInteger(arg3, 2, 0);
        if (!PotionUtil.isValidEffect(effectName)) {
            throw new BadArgumentException(0, "'%s' is not a valid potion effect", effectName);
        }
        PotionEffect potionEffect = PotionUtil.getEffect(effectName, duration, amplifier);
        T player = this.getEntity();
        if (!player.func_70687_e(potionEffect)) {
            return MtsValue.FALSE;
        }
        player.func_70690_d(potionEffect);
        return MtsValue.TRUE;
    }

    @MtsNativeFunction
    public MtsBoolean removeEffect(MtsValue arg1) {
        String effectName = MtsCheck.checkString(arg1, 0);
        if (!PotionUtil.isValidEffect(effectName)) {
            throw new BadArgumentException(0, "'%s' is not a valid potion effect", effectName);
        }
        int id = PotionUtil.getID(effectName);
        T player = this.getEntity();
        if (!player.func_82165_m(id)) {
            return MtsValue.FALSE;
        }
        player.func_82170_o(id);
        return MtsValue.TRUE;
    }
}

