/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.client.gui;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.mobtalker.mobtalker2.client.ClientInteractionHandler;
import net.mobtalker.mobtalker2.client.gui.MobTalkerChoiceGui;
import net.mobtalker.mobtalker2.client.gui.MobTalkerDialogArea;
import net.mobtalker.mobtalker2.common.resources.MobTalkerResourceLocation;
import net.mobtalker.mobtalker2.util.logging.MobTalkerLog;
import net.mobtalker.mobtalker2.util.mgt.Alignment;
import net.mobtalker.mobtalker2.util.mgt.AlignmentX;
import net.mobtalker.mobtalker2.util.mgt.Dimension;
import net.mobtalker.mobtalker2.util.mgt.FullscreenMode;
import net.mobtalker.mobtalker2.util.mgt.MGContainer;
import net.mobtalker.mobtalker2.util.mgt.MGCornersTexture;
import net.mobtalker.mobtalker2.util.mgt.MGFullscreenTexture;
import net.mobtalker.mobtalker2.util.mgt.MGTextArea;
import net.mobtalker.mobtalker2.util.mgt.MGTexture;
import net.mobtalker.mobtalker2.util.mgt.Point;
import net.mobtalker.mobtalker2.util.mgt.TexturePosition;

@SideOnly(value=Side.CLIENT)
public class MobTalkerInteractionGui
extends MGContainer
implements MobTalkerChoiceGui.IChoiceMadeListener,
MobTalkerDialogArea.IEndOfTextReachedListener {
    private static final String LOG_TAG = "GUI";
    private static final Map<String, TexturePosition> _positions = Maps.newHashMap();
    private final ClientInteractionHandler _handler;
    private MobTalkerChoiceGui _choiceGui;
    private MGCornersTexture _textAreaBackground;
    private MobTalkerDialogArea _textArea;
    private MGTextArea _characterName;
    private final Map<String, MGTexture> _textures;
    private boolean _hideHotbar = false;

    public MobTalkerInteractionGui(ClientInteractionHandler handler) {
        this._handler = handler;
        this._textures = Maps.newHashMap();
        this.createChoiceGui();
        this.createDialogTextArea();
        this.createDialogBackground();
        this.createCharacterName();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void createChoiceGui() {
        this._choiceGui = new MobTalkerChoiceGui();
        this._choiceGui.setChoiceListener(this);
        this.add(this._choiceGui);
    }

    private void createDialogTextArea() {
        this._textArea = new MobTalkerDialogArea(0);
        this._textArea.setAlign(Alignment.BOTTOM, Alignment.BOTTOM, 0, -3);
        this._textArea.setTextAlignment(AlignmentX.LEFT);
        this._textArea.setWidth(256);
        this._textArea.setLineCount(3);
        this._textArea.setLineSpacing(2);
        this._textArea.setZLevel(-98);
        this._textArea.setEndOfTextListener(this);
        this.add(this._textArea);
    }

    private void createDialogBackground() {
        this._textAreaBackground = new MGCornersTexture(0);
        this._textAreaBackground.setTexture(new MobTalkerResourceLocation("textures/ui/dialog_bg.png"));
        this._textAreaBackground.setWidth(this._textArea.getBounds().getWidth() + 16);
        this._textAreaBackground.setHeight(this._textArea.getBounds().getHeight() + 16);
        this._textAreaBackground.setAlign(Alignment.CENTER, this._textArea, Alignment.CENTER, 0, 0);
        this._textAreaBackground.setZLevel(-99);
        this.add(this._textAreaBackground);
    }

    private void createCharacterName() {
        int characterNameWidth = 248;
        this._characterName = new MGTextArea(0);
        this._characterName.setTextAlignment(AlignmentX.CENTER);
        this._characterName.setWidth(characterNameWidth);
        this._characterName.setAlign(Alignment.BOTTOM, this._textAreaBackground, Alignment.TOP, 0, -2);
        this._characterName.setZLevel(-98);
        this._characterName.setLineCount(1);
        this._characterName.setLineSpacing(0);
        this._characterName.setDropShadow(true);
        this.add(this._characterName);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderIngame(RenderGameOverlayEvent.Pre event) {
        if (!this._isVisible) {
            MobTalkerLog.warn(LOG_TAG, "Recieved render event while hidden!");
            return;
        }
        if (event.type != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        if (this._hideHotbar) {
            event.setCanceled(true);
        }
    }

    @Override
    public void doLayout(Dimension screenDim) {
        MobTalkerLog.debug(LOG_TAG, "ScreenDim: %s x %s", screenDim.getWidth(), screenDim.getHeight());
        super.doLayout(screenDim);
    }

    public void showSprite(String textureGroup, ResourceLocation textureLocation, String position, Point offset) {
        if (!_positions.containsKey(position)) {
            MobTalkerLog.fatal("[GUI] Recieved request to show sprite '%s' in texture group '%s' at position '%s' that does not exist!", textureLocation.func_110623_a(), textureGroup, position);
            return;
        }
        TexturePosition screenPosition = _positions.get(position);
        MGTexture texture = this._textures.get(textureGroup);
        if (texture == null) {
            texture = new MGTexture(0);
            texture.setZLevel(-900);
            texture.addMouseListener(this._textArea.advanceTextListener);
            this._textures.put(textureGroup, texture);
            this.add(texture);
            MobTalkerLog.debug("[GUI] Created texture group for '%s'", textureGroup);
        }
        MobTalkerLog.debug("[GUI] Showing sprite '%s' in group '%s' at '%s' with offset '%s, %s'", textureLocation.func_110623_a(), textureGroup, position, offset.getX(), offset.getY());
        texture.setTexture(textureLocation);
        texture.setAlign(screenPosition.getAlignFrom(), screenPosition.getAlignTo(), screenPosition.getOffset().add(offset));
        texture.setVisible(true);
        this.invalidate();
    }

    public void showScene(MobTalkerResourceLocation textureLocation, FullscreenMode mode) {
        MGFullscreenTexture texture;
        try {
            texture = (MGFullscreenTexture)this._textures.get("scene");
        }
        catch (ClassCastException ex) {
            MobTalkerLog.warn("[GUI] Tried to show scene '%s' in group 'scene', but this group already exists and is not a scene group!", textureLocation.func_110623_a());
            return;
        }
        if (texture == null) {
            texture = new MGFullscreenTexture(0);
            texture.setZLevel(-1000);
            texture.addMouseListener(this._textArea.advanceTextListener);
            this._textures.put("scene", texture);
            this.add(texture);
        }
        MobTalkerLog.debug("[GUI] Showing scene '%s' as '%s'", textureLocation.func_110623_a(), new Object[]{mode});
        texture.setTexture(textureLocation);
        texture.setAlign(Alignment.CENTER, Alignment.CENTER, Point.ZERO);
        texture.setMode(mode);
        texture.setVisible(true);
        this.invalidate();
    }

    public void hideTexture(String textureGroup) {
        MGTexture texture = this._textures.get(textureGroup);
        MobTalkerLog.debug("[GUI] Hiding texture group '%s'", textureGroup);
        if (texture == null) {
            MobTalkerLog.warn("[GUI] Texture group '%s' does not exist!", textureGroup);
            return;
        }
        texture.setVisible(false);
        this.remove(texture);
        this._textures.remove(textureGroup);
        this.invalidate();
    }

    public void setCharacterName(String name, AlignmentX side) {
        this._characterName.setText(name);
        this._characterName.setTextAlignment(side);
    }

    public void clearDialogeText() {
        this._textArea.clearText();
    }

    public void setDialogeText(String text) {
        this._textArea.setText(text);
        this.enableTextureMouseEvents();
    }

    public void displayChoiceMenu(List<String> choices) {
        this.disableTextureMouseEvents();
        this._choiceGui.setChoices(choices);
    }

    public void hideChoiceMenu() {
        this._choiceGui.clearChoices();
        this.enableTextureMouseEvents();
    }

    private void enableTextureMouseEvents() {
        this._textArea.setMouseEventsEnabled(true);
        for (MGTexture texture : this._textures.values()) {
            texture.setMouseEventsEnabled(true);
        }
    }

    private void disableTextureMouseEvents() {
        this._textArea.setMouseEventsEnabled(false);
        for (MGTexture texture : this._textures.values()) {
            texture.setMouseEventsEnabled(false);
        }
    }

    @Override
    public boolean onKeyPressed(char eventChar, int eventKey) {
        this._handler.onKeyTyped(eventChar, eventKey);
        return false;
    }

    @Override
    public void onClosed() {
        this.setVisible(false);
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @Override
    public void onChoiceMade(int choice) {
        this._handler.onChoiceMade(choice);
    }

    @Override
    public void onEndOfTextReached() {
        this.disableTextureMouseEvents();
        this._handler.onTextFinished();
    }

    static {
        _positions.put("bottomleft", new TexturePosition(Alignment.BOTTOMLEFT, Alignment.BOTTOM, -128, 0));
        _positions.put("bottom", new TexturePosition(Alignment.BOTTOM, Alignment.BOTTOM, 0, 0));
        _positions.put("bottomright", new TexturePosition(Alignment.BOTTOMRIGHT, Alignment.BOTTOM, 128, 0));
        _positions.put("left", new TexturePosition(Alignment.LEFT, Alignment.CENTER, -128, 0));
        _positions.put("center", new TexturePosition(Alignment.CENTER, Alignment.CENTER, 0, 0));
        _positions.put("right", new TexturePosition(Alignment.RIGHT, Alignment.CENTER, 128, 0));
        _positions.put("topleft", new TexturePosition(Alignment.TOPLEFT, Alignment.TOP, -128, 0));
        _positions.put("top", new TexturePosition(Alignment.TOP, Alignment.TOP, 0, 0));
        _positions.put("topright", new TexturePosition(Alignment.TOPRIGHT, Alignment.TOP, -128, 0));
        _positions.put("screenbottomleft", new TexturePosition(Alignment.BOTTOMLEFT, Alignment.BOTTOMLEFT));
        _positions.put("screenbottomright", new TexturePosition(Alignment.BOTTOMRIGHT, Alignment.BOTTOMRIGHT));
        _positions.put("screenleft", new TexturePosition(Alignment.LEFT, Alignment.LEFT));
        _positions.put("screenright", new TexturePosition(Alignment.RIGHT, Alignment.RIGHT));
        _positions.put("screentopleft", new TexturePosition(Alignment.TOPLEFT, Alignment.TOPLEFT));
        _positions.put("screentopright", new TexturePosition(Alignment.TOPRIGHT, Alignment.TOPRIGHT));
    }
}

