/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.mobtalker.mobtalker2.common.resources.MobTalkerResourceLocation;
import net.mobtalker.mobtalker2.util.mgt.Alignment;
import net.mobtalker.mobtalker2.util.mgt.MGButton;
import net.mobtalker.mobtalker2.util.mgt.MGComponent;
import net.mobtalker.mobtalker2.util.mgt.MGContainer;
import net.mobtalker.mobtalker2.util.mgt.MGCornersTexture;
import net.mobtalker.mobtalker2.util.mgt.MGTexture;
import net.mobtalker.mobtalker2.util.mgt.MouseListenerAdapter;

@SideOnly(value=Side.CLIENT)
public class MobTalkerChoiceGui
extends MGContainer {
    private final ArrayList<String> _choices;
    private final ArrayList<MGButton> _buttons;
    private final MGTexture _bgTexture;
    private IChoiceMadeListener choiceListener;
    private final MouseListenerAdapter mouseListener = new MouseListenerAdapter(){

        @Override
        public void mouseClicked(MGComponent sender, int x, int y, int button) {
            if (button == 0 && sender.getId() >= 0) {
                MobTalkerChoiceGui.this.choiceClicked(sender.getId());
            }
        }
    };

    public MobTalkerChoiceGui() {
        this._choices = new ArrayList(1);
        this._buttons = new ArrayList(1);
        this._bgTexture = new MGCornersTexture(0);
        this._bgTexture.setTexture(new MobTalkerResourceLocation("textures/ui/menu_bg.png"));
        this._bgTexture.setAlign(Alignment.BOTTOM, Alignment.BOTTOM, 0, -91);
        this._bgTexture.setZLevel(-2);
        this.add(this._bgTexture);
        this.setVisible(false);
    }

    public void setChoices(List<String> choices) {
        this.clearChoices();
        if (choices.isEmpty()) {
            return;
        }
        this._choices.addAll(choices);
        int maxStringWidth = 0;
        for (String choice : choices) {
            int captionWidth = MobTalkerChoiceGui.getFontRenderer().func_78256_a(choice);
            maxStringWidth = Math.max(maxStringWidth, captionWidth);
        }
        maxStringWidth = Math.max(maxStringWidth, 80);
        int offsetY = choices.size() * 21;
        for (int i = 0; i < choices.size(); ++i) {
            String choice = choices.get(i);
            MGButton button = new MGButton(i);
            button.setAlign(Alignment.BOTTOM, Alignment.BOTTOM, 0, -97 - (offsetY -= 21));
            button.setSize(maxStringWidth + 8, 20);
            button.setZLevel(-1);
            button.addMouseListener(clickSoundListener);
            button.addMouseListener(this.mouseListener);
            button.setCaption(choice);
            this._buttons.add(button);
        }
        this._bgTexture.setWidth(maxStringWidth + 20);
        this._bgTexture.setHeight(choices.size() * 21 + 11);
        this.addAll(this._buttons);
        this.invalidate();
        this.setVisible(true);
    }

    public void clearChoices() {
        this._choices.clear();
        this.removeAll(this._buttons);
        this._buttons.clear();
        this.setVisible(false);
    }

    public void setChoiceListener(IChoiceMadeListener choiceListener) {
        this.choiceListener = choiceListener;
    }

    protected void choiceClicked(int choice) {
        if (this.choiceListener != null) {
            this.choiceListener.onChoiceMade(choice);
        }
    }

    public static interface IChoiceMadeListener {
        public void onChoiceMade(int var1);
    }
}

