/*
 * Decompiled with CFR 0.152.
 */
package me.tyler15555.minibosses.common;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import me.tyler15555.minibosses.block.MBBlocks;
import me.tyler15555.minibosses.common.CommonProxy;
import me.tyler15555.minibosses.common.MBEventHandler;
import me.tyler15555.minibosses.entity.EntityCrawler;
import me.tyler15555.minibosses.entity.EntityForestGuard;
import me.tyler15555.minibosses.entity.EntityIronZombie;
import me.tyler15555.minibosses.entity.EntitySuperSlime;
import me.tyler15555.minibosses.item.MBItems;
import me.tyler15555.minibosses.util.ConfigHelper;
import me.tyler15555.minibosses.util.MicroBossProperties;
import me.tyler15555.minibosses.util.Resources;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.Level;

@Mod(modid="MiniBosses", name="Mini-Bosses", version="v1.0")
public class MiniBosses {
    @Mod.Instance(value="MiniBosses")
    public static MiniBosses instance;
    @SidedProxy(clientSide="me.tyler15555.minibosses.client.ClientProxy", serverSide="me.tyler15555.minibosses.common.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        event.getModLog().log(Level.INFO, "Mini-Bosses is starting to load!");
        ConfigHelper.setupConfig(new Configuration(event.getSuggestedConfigurationFile()), event.getModLog());
        Resources.setupArmorMaterials();
        GameRegistry.registerItem((Item)MBItems.ingotDarkIron, (String)"ingotDarkIron");
        GameRegistry.registerItem((Item)MBItems.darkIronHelm, (String)"darkIronHelm");
        GameRegistry.registerItem((Item)MBItems.darkIronChest, (String)"darkIronChest");
        GameRegistry.registerItem((Item)MBItems.darkIronLegs, (String)"darkIronLegs");
        GameRegistry.registerItem((Item)MBItems.darkIronBoots, (String)"darkIronBoots");
        GameRegistry.registerBlock((Block)MBBlocks.blockSlime, (String)"blockSlime");
    }

    @Mod.EventHandler
    public void loadMod(FMLInitializationEvent event) {
        proxy.registerRenderers();
        OreDictionary.registerOre((String)"ingotDarkIron", (Item)MBItems.ingotDarkIron);
        MinecraftForge.EVENT_BUS.register((Object)new MBEventHandler());
        EntityRegistry.registerModEntity(EntityIronZombie.class, (String)"MB-IronZombie", (int)1, (Object)this, (int)64, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntitySuperSlime.class, (String)"MB-SuperSlime", (int)2, (Object)this, (int)64, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityForestGuard.class, (String)"MB-ForestGuard", (int)3, (Object)this, (int)64, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityCrawler.class, (String)"MB-Crawler", (int)4, (Object)this, (int)64, (int)3, (boolean)true);
        EntityRegistry.addSpawn(EntityIronZombie.class, (int)ConfigHelper.ironZombieSpawnRate, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
        EntityRegistry.addSpawn(EntitySuperSlime.class, (int)ConfigHelper.superSlimeSpawnRate, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
        EntityRegistry.addSpawn(EntityForestGuard.class, (int)ConfigHelper.forestGuardSpawnRate, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
        EntityRegistry.addSpawn(EntityCrawler.class, (int)ConfigHelper.crawlerSpawnRate, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.HILLS));
        if (ConfigHelper.allowSlimeBlockCrafting) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(MBBlocks.blockSlime, 2), (Object[])new Object[]{"sss", "sss", "sss", Character.valueOf('s'), Items.field_151123_aH});
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(MBItems.darkIronHelm, new Object[]{"iii", "i i", "xxx", Character.valueOf('i'), "ingotDarkIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(MBItems.darkIronChest, new Object[]{"i i", "iii", "iii", Character.valueOf('i'), "ingotDarkIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(MBItems.darkIronLegs, new Object[]{"iii", "i i", "i i", Character.valueOf('i'), "ingotDarkIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(MBItems.darkIronBoots, new Object[]{"xxx", "i i", "i i", Character.valueOf('i'), "ingotDarkIron"}));
    }

    @Mod.EventHandler
    public void finishLoading(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (message.isItemStackMessage()) {
                MicroBossProperties.modWeapons.add(message.getItemStackValue());
                System.out.println("[MiniBosses] Mod: " + message.getSender() + " has added an item to the weapon list!");
            }
            if (!message.isStringMessage() || !message.getStringValue().contains("!")) continue;
            String[] data = message.getStringValue().split("!");
            Resources.entityBlockList.put(data[0], Integer.valueOf(data[1]));
        }
    }

    public static int createDarkIronRenderPrefix() {
        return proxy.registerDarkArmorRenderPrefix();
    }
}

