/*
 * Decompiled with CFR 0.152.
 */
package minestrapteam.minestrappolation.item;

import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minestrapteam.minestrappolation.item.IPlatable;
import minestrapteam.minestrappolation.item.IPlating;
import minestrapteam.minestrappolation.item.MItemTool;
import minestrapteam.minestrappolation.lib.MTools;
import minestrapteam.minestrappolation.util.MAssetManager;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class MItemSword
extends ItemSword
implements IPlatable {
    private Item.ToolMaterial material;
    private boolean ignites;
    private IIcon hornIcon;
    private Map<String, IIcon> overlayIcons = new HashMap<String, IIcon>();

    public MItemSword(Item.ToolMaterial material) {
        super(material);
        this.material = material;
    }

    public MItemSword(Item.ToolMaterial material, boolean ignites) {
        super(material);
        this.material = material;
        this.ignites = ignites;
    }

    @Override
    public String getType() {
        return "sword";
    }

    @Override
    public int getPlatingCount(ItemStack stack) {
        return this.material.func_77996_d() + 1;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity, EntityLivingBase attacker) {
        if (this == MTools.soulsteelSword) {
            attacker.field_70170_p.func_72956_a((Entity)attacker, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!attacker.field_70170_p.field_72995_K) {
                attacker.field_70170_p.func_72838_d((Entity)new EntityXPOrb(attacker.field_70170_p, attacker.field_70165_t, attacker.field_70165_t, attacker.field_70165_t, 25));
            }
        }
        return MItemTool.hitEntity(stack, entity, attacker, this.ignites, true);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        MItemTool.addInformation(stack, list);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && this.ignites) {
            Items.field_151033_d.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
            stack.func_77972_a(4, (EntityLivingBase)player);
            return true;
        }
        return false;
    }

    public float getDigSpeed(ItemStack stack, Block block, int metadata) {
        return MItemTool.getDigSpeed(super.getDigSpeed(stack, block, metadata), stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return MItemTool.getMaxDamage(super.getMaxDamage(stack), stack);
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        return MItemTool.getAttributeModifiers(super.getAttributeModifiers(stack), stack);
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 3;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A());
        this.hornIcon = iconRegister.func_94245_a(MAssetManager.getWeaponTexture("horned_sword_overlay"));
        ItemStack thisStack = new ItemStack((Item)this, 1, 0);
        for (Map.Entry<String, IPlating> e : IPlating.platings.entrySet()) {
            String type = e.getKey();
            IPlating plating = e.getValue();
            if (!plating.canApply(thisStack)) continue;
            StringBuilder builder = new StringBuilder(20);
            builder.append("weapons/").append(type).append("_sword_overlay");
            String textureName = MAssetManager.getTexture(builder.toString());
            this.overlayIcons.put(type, iconRegister.func_94245_a(textureName));
        }
    }

    public IIcon getIcon(ItemStack stack, int renderPass) {
        IIcon icon = null;
        if (renderPass == 2) {
            IPlating plating = MItemTool.getPlating(stack);
            if (plating != null) {
                icon = this.overlayIcons.get(plating.getType());
            }
        } else if (renderPass == 1 && MItemTool.isHorned(stack)) {
            icon = this.hornIcon;
        }
        return icon == null ? this.field_77791_bV : icon;
    }
}

