/*
 * Decompiled with CFR 0.152.
 */
package minestrapteam.minestrappolation.item;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minestrapteam.minestrappolation.item.IPlatable;
import minestrapteam.minestrappolation.item.IPlating;
import minestrapteam.minestrappolation.item.MItemTool;
import minestrapteam.minestrappolation.util.MAssetManager;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class MItemArmor
extends ItemArmor
implements IPlatable {
    private String part;
    private Map<String, IIcon> overlayIcons = new HashMap<String, IIcon>();

    public MItemArmor(ItemArmor.ArmorMaterial material, int renderIndex, int type) {
        super(material, renderIndex, type);
        this.func_77637_a(null);
        if (type == 0) {
            this.part = "helmet";
        } else if (type == 1) {
            this.part = "chestplate";
        } else if (type == 2) {
            this.part = "leggings";
        } else if (type == 3) {
            this.part = "boots";
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return MItemTool.getMaxDamage(super.getMaxDamage(stack), stack);
    }

    public boolean func_77623_v() {
        return true;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.field_111218_cA);
        ItemStack thisStack = new ItemStack((Item)this, 1, 0);
        for (Map.Entry<String, IPlating> e : IPlating.platings.entrySet()) {
            String type = e.getKey();
            IPlating plating = e.getValue();
            if (!plating.canApply(thisStack)) continue;
            StringBuilder builder = new StringBuilder(20);
            builder.append("armor/").append(type).append("_").append(this.part).append("_overlay");
            String textureName = MAssetManager.getTexture(builder.toString());
            this.overlayIcons.put(type, iconRegister.func_94245_a(textureName));
        }
    }

    public IIcon getIcon(ItemStack stack, int renderPass) {
        IPlating plating;
        IIcon icon = null;
        if (renderPass == 1 && (plating = MItemTool.getPlating(stack)) != null) {
            icon = this.overlayIcons.get(plating.getType());
        }
        return icon == null ? this.field_77791_bV : icon;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        MItemTool.addInformation(stack, list);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (type == null) {
            String material = this.func_82812_d().name().toLowerCase();
            String slot1 = slot == 2 ? "_2" : "_1";
            return MAssetManager.getArmorModel(material + slot1);
        }
        IPlating plating = MItemTool.getPlating(stack);
        if (plating != null) {
            String slot1 = slot == 2 ? "_overlay_2" : "_overlay_1";
            return MAssetManager.getArmorModel(plating.getType() + slot1);
        }
        return null;
    }

    @Override
    public String getType() {
        return this.part;
    }

    @Override
    public int getPlatingCount(ItemStack stack) {
        ItemArmor.ArmorMaterial material = this.func_82812_d();
        switch (material) {
            case CHAIN: {
                return 1;
            }
            case CLOTH: {
                return 1;
            }
            case IRON: {
                return 2;
            }
            case GOLD: {
                return 3;
            }
            case DIAMOND: {
                return 4;
            }
        }
        return 1;
    }
}

