/*
 * Decompiled with CFR 0.152.
 */
package minestrapteam.minestrappolation.tileentity;

import clashsoft.cslib.minecraft.stack.CSStacks;
import clashsoft.cslib.minecraft.tileentity.TileEntityInventory;
import minestrapteam.minestrappolation.block.BlockMelter;
import minestrapteam.minestrappolation.crafting.MelterRecipes;
import minestrapteam.minestrappolation.lib.MItems;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;

public class TileEntityMelter
extends TileEntityInventory
implements ISidedInventory {
    public int burnTime;
    public int maxBurnTime;
    public int meltTime;
    public int front;
    public boolean hasPower;
    private static final int[] topInputSlot = new int[]{0};
    private static final int[] outputSlots = new int[]{2, 1};
    private static final int[] inputSlots = new int[]{1};

    public TileEntityMelter() {
        super(4);
    }

    public void setFrontDirection(int f) {
        this.front = f;
    }

    public int getFrontDirection() {
        return this.front;
    }

    public final int getMaxMeltTime() {
        return this.hasPower ? 800 : 1600;
    }

    public int func_70302_i_() {
        return 4;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.front = nbt.func_74762_e("FrontDirection");
        this.burnTime = nbt.func_74765_d("BurnTime");
        this.meltTime = nbt.func_74765_d("CookTime");
        this.maxBurnTime = TileEntityMelter.getItemBurnTime(this.itemStacks[1]);
    }

    public boolean isPowered() {
        return this.hasPower;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("FrontDirection", this.front);
        nbt.func_74777_a("BurnTime", (short)this.burnTime);
        nbt.func_74777_a("CookTime", (short)this.meltTime);
    }

    public int getProgressScaled(int scalar) {
        if (!this.hasPower) {
            return this.meltTime * scalar / this.getMaxMeltTime();
        }
        return this.meltTime * scalar / this.getMaxMeltTime();
    }

    public int getBurnTimeRemainingScaled(int scalar) {
        if (this.maxBurnTime == 0) {
            this.maxBurnTime = 200;
        }
        return this.burnTime * scalar / this.maxBurnTime;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public void func_145845_h() {
        boolean burning;
        this.hasPower = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        boolean bl = burning = this.burnTime > 0;
        if (burning) {
            this.burnTime = this.hasPower ? (this.burnTime -= 16) : (this.burnTime -= 4);
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.canSmelt()) {
            if (this.burnTime == 0) {
                this.maxBurnTime = this.burnTime = TileEntityMelter.getItemBurnTime(this.itemStacks[1]);
                if (this.burnTime > 0) {
                    this.func_70296_d();
                    if (this.itemStacks[1] != null) {
                        --this.itemStacks[1].field_77994_a;
                        if (this.itemStacks[1].field_77994_a == 0) {
                            this.itemStacks[1] = this.itemStacks[1].func_77973_b().getContainerItem(this.itemStacks[1]);
                        }
                    }
                }
            } else if (this.isBurning()) {
                ++this.meltTime;
                if (this.meltTime >= this.getMaxMeltTime()) {
                    this.meltTime = 0;
                    this.smeltItem();
                    this.func_70296_d();
                }
            } else {
                this.meltTime = 0;
            }
        } else {
            this.meltTime = 0;
        }
        if (burning != this.burnTime > 0) {
            this.func_70296_d();
            this.func_145829_t();
            BlockMelter.updateBlockState(this.burnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private boolean canSmelt() {
        if (this.itemStacks[0] != null) {
            ItemStack itemstack = MelterRecipes.instance.getResult(this.itemStacks[0]);
            if (itemstack == null) {
                return false;
            }
            ItemStack container = itemstack.func_77973_b().getContainerItem(itemstack);
            if (container != null && !CSStacks.itemEquals((ItemStack)container, (ItemStack)this.itemStacks[3])) {
                return false;
            }
            if (this.itemStacks[2] == null) {
                return true;
            }
            if (!this.itemStacks[2].func_77969_a(itemstack)) {
                return false;
            }
            int result = this.itemStacks[2].field_77994_a + itemstack.field_77994_a;
            return result <= itemstack.func_77976_d();
        }
        return false;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = MelterRecipes.instance.getResult(this.itemStacks[0]);
            if (this.itemStacks[2] == null) {
                this.itemStacks[2] = itemstack.func_77946_l();
            } else if (this.itemStacks[2].func_77969_a(itemstack)) {
                this.itemStacks[2].field_77994_a += itemstack.field_77994_a;
            }
            --this.itemStacks[0].field_77994_a;
            if (this.itemStacks[0].field_77994_a <= 0) {
                this.itemStacks[0] = null;
            }
            if (this.itemStacks[3] != null && CSStacks.equals((ItemStack)this.itemStacks[3], (ItemStack)itemstack.func_77973_b().getContainerItem(itemstack))) {
                --this.itemStacks[3].field_77994_a;
                if (this.itemStacks[3].field_77994_a <= 0) {
                    this.itemStacks[3] = null;
                }
            }
        }
    }

    public boolean isItemFuel(ItemStack stack) {
        return TileEntityMelter.getItemBurnTime(stack) > 0;
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        int i = TileEntityFurnace.func_145952_a((ItemStack)stack);
        if (i == 0) {
            Item item = stack.func_77973_b();
            if (item == MItems.uranium) {
                i = 150000;
            } else if (item == MItems.plutonium) {
                i = 200000;
            }
        }
        return i;
    }

    public boolean func_102007_a(int slotID, ItemStack stack, int side) {
        return this.func_94041_b(slotID, stack);
    }

    public boolean func_102008_b(int slotID, ItemStack stack, int side) {
        return side == 0 && slotID != 1 || stack.func_77973_b() == Items.field_151133_ar;
    }

    public int[] func_94128_d(int side) {
        return side == 0 ? outputSlots : (side == 1 ? topInputSlot : inputSlots);
    }
}

