/*
 * Decompiled with CFR 0.152.
 */
package minestrapteam.minestrappolation.nei.handler;

import clashsoft.cslib.minecraft.lang.I18n;
import clashsoft.cslib.minecraft.stack.CSStacks;
import codechicken.nei.ItemList;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import minestrapteam.minestrappolation.client.gui.GuiMelter;
import minestrapteam.minestrappolation.crafting.MelterRecipes;
import minestrapteam.minestrappolation.tileentity.TileEntityMelter;
import minestrapteam.minestrappolation.util.MAssetManager;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class MelterRecipeHandler
extends TemplateRecipeHandler {
    public static ArrayList<FuelPair> afuels;

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(50, 23, 18, 18), "melter_fuel", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "melting", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiMelter.class;
    }

    public String getRecipeName() {
        return I18n.getString((String)"recipe.melting");
    }

    public TemplateRecipeHandler newInstance() {
        if (afuels == null) {
            MelterRecipeHandler.findFuels();
        }
        return super.newInstance();
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("melting")) {
            Map recipes = MelterRecipes.instance.getRecipes();
            for (Map.Entry recipe : recipes.entrySet()) {
                this.arecipes.add(new MeltingPair((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        Map recipes = MelterRecipes.instance.getRecipes();
        for (Map.Entry recipe : recipes.entrySet()) {
            if (!CSStacks.itemEquals((ItemStack)((ItemStack)recipe.getValue()), (ItemStack)result)) continue;
            this.arecipes.add(new MeltingPair((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue()));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("melter_fuel")) {
            this.loadCraftingRecipes("melting", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Map recipes = MelterRecipes.instance.getRecipes();
        for (Map.Entry recipe : recipes.entrySet()) {
            if (!CSStacks.itemEquals((ItemStack)((ItemStack)recipe.getKey()), (ItemStack)ingredient)) continue;
            MeltingPair arecipe = new MeltingPair((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue());
            arecipe.setIngredientPermutation(Arrays.asList(arecipe.ingred), ingredient);
            this.arecipes.add(arecipe);
        }
    }

    public String getGuiTexture() {
        return MAssetManager.getTexture("textures/gui/container/melter.png");
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(51, 25, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(74, 23, 176, 14, 24, 16, 48, 0);
    }

    private static void findFuels() {
        afuels = new ArrayList();
        for (ItemStack item : ItemList.items) {
            int burnTime = TileEntityMelter.getItemBurnTime(item);
            if (burnTime <= 0) continue;
            afuels.add(new FuelPair(item.func_77946_l(), burnTime));
        }
    }

    public String getOverlayIdentifier() {
        return "melting";
    }

    public static class FuelPair {
        public PositionedStack stack;
        public int burnTime;

        public FuelPair(ItemStack ingred, int burnTime) {
            this.stack = new PositionedStack((Object)ingred, 42, 42, false);
            this.burnTime = burnTime;
        }
    }

    public class MeltingPair
    extends TemplateRecipeHandler.CachedRecipe {
        protected PositionedStack ingred;
        protected PositionedStack result;
        protected PositionedStack bucket;

        public MeltingPair(ItemStack ingred, ItemStack result) {
            super((TemplateRecipeHandler)MelterRecipeHandler.this);
            ingred.field_77994_a = 1;
            this.ingred = new PositionedStack((Object)ingred, 51, 6);
            this.result = new PositionedStack((Object)result, 111, 24);
            ItemStack container = result.func_77973_b().getContainerItem(result);
            if (container != null) {
                this.bucket = new PositionedStack((Object)container, 61, 42);
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(MelterRecipeHandler.this.cycleticks / 48, Arrays.asList(this.ingred));
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public List<PositionedStack> getOtherStacks() {
            List list = super.getOtherStacks();
            PositionedStack fuel = MelterRecipeHandler.afuels.get((int)(MelterRecipeHandler.this.cycleticks / 48 % MelterRecipeHandler.afuels.size())).stack;
            if (fuel != null) {
                list.add(fuel);
            }
            if (this.bucket != null) {
                list.add(this.bucket);
            }
            return list;
        }
    }
}

