/*
 * Decompiled with CFR 0.152.
 */
package minestrapteam.minestrappolation.item;

import clashsoft.cslib.minecraft.lang.I18n;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import minestrapteam.minestrappolation.item.IPlatable;
import minestrapteam.minestrappolation.item.IPlating;
import minestrapteam.minestrappolation.lib.MTools;
import minestrapteam.minestrappolation.util.MAssetManager;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class MItemTool
extends ItemTool
implements IPlatable {
    public static final UUID PLATING_UUID = UUID.fromString("CB3F55D3-745C-4F38-A497-9C13A33DB5CF");
    public static final UUID HORN_UUID = UUID.fromString("CB3F55D3-845C-4F38-A497-9C13A33DB5CF");
    protected boolean ignites;
    protected boolean weapon;
    private String toolType;
    private Map<String, IIcon> overlayIcons = new HashMap<String, IIcon>();

    public MItemTool(float baseDamage, Item.ToolMaterial material, Set<Block> blocks, String type, boolean ignites) {
        super(baseDamage, material, blocks);
        this.toolType = type;
        this.ignites = ignites;
    }

    public MItemTool(float baseDamage, Item.ToolMaterial material, Set<Block> blocks, String type) {
        this(baseDamage, material, blocks, type, false);
    }

    public MItemTool setWeapon() {
        this.weapon = true;
        return this;
    }

    @Override
    public String getType() {
        return this.toolType;
    }

    @Override
    public int getPlatingCount(ItemStack stack) {
        return this.field_77862_b.func_77996_d() + 1;
    }

    public static boolean isPlated(ItemStack stack) {
        return MItemTool.getPlating(stack) != null;
    }

    public static IPlating getPlating(ItemStack stack) {
        if (stack.field_77990_d != null) {
            String s = stack.field_77990_d.func_74779_i("Plating");
            return s == null || s.isEmpty() ? null : IPlating.platings.get(s);
        }
        return null;
    }

    public static void setPlating(ItemStack stack, IPlating plating) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74778_a("Plating", plating == null ? "" : plating.getType());
    }

    public static boolean isHorned(ItemStack stack) {
        if (stack.field_77990_d != null) {
            return stack.field_77990_d.func_74767_n("Horned");
        }
        return false;
    }

    public static void setHorned(ItemStack stack, boolean horned) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74757_a("Horned", horned);
    }

    public static float getPoisonLevel(ItemStack stack) {
        if (stack.field_77990_d != null) {
            return stack.field_77990_d.func_74760_g("PoisonLevel");
        }
        return 0.0f;
    }

    public static void setPoisonLevel(ItemStack stack, float level) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74776_a("PoisonLevel", level);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.weapon ? EnumAction.block : EnumAction.none;
    }

    public int func_77626_a(ItemStack stack) {
        return this.weapon ? 72000 : 0;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (this.weapon) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public static boolean hitEntity(ItemStack stack, EntityLivingBase entity, EntityLivingBase attacker, boolean ignites, boolean weapon) {
        float level = MItemTool.getPoisonLevel(stack);
        if (level > 0.0f) {
            entity.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 240, 0));
            MItemTool.setPoisonLevel(stack, level -= 0.5f);
        }
        if (ignites) {
            entity.func_70015_d(10);
        }
        if (weapon) {
            stack.func_77972_a(1, attacker);
        } else {
            stack.func_77972_a(2, attacker);
        }
        return true;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity, EntityLivingBase attacker) {
        return MItemTool.hitEntity(stack, entity, attacker, this.ignites, this.weapon);
    }

    public static void addInformation(ItemStack stack, List list) {
        IPlating plating;
        float poisonLevel = MItemTool.getPoisonLevel(stack);
        if (poisonLevel > 0.0f) {
            list.add(I18n.getString((String)"item.poison_sword.desc", (Object[])new Object[]{Float.valueOf(poisonLevel)}));
        }
        if (MItemTool.isHorned(stack)) {
            list.add(I18n.getString((String)"item.horned_sword.desc"));
        }
        if ((plating = MItemTool.getPlating(stack)) != null) {
            list.add(I18n.getString((String)("item.plating." + plating.getType() + ".desc")));
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        MItemTool.addInformation(stack, list);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        int level = super.getHarvestLevel(stack, toolClass);
        if (level == -1 && toolClass != null && toolClass.equals(this.toolType)) {
            return this.field_77862_b.func_77996_d();
        }
        return level;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return this.toolType != null ? ImmutableSet.of((Object)this.toolType) : super.getToolClasses(stack);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && this.ignites) {
            Items.field_151033_d.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
            stack.func_77972_a(4, (EntityLivingBase)player);
            return true;
        }
        return false;
    }

    public static float getDigSpeed(float superDigSpeed, ItemStack stack) {
        IPlating plating = MItemTool.getPlating(stack);
        if (plating != null) {
            return superDigSpeed * plating.getDigSpeed();
        }
        return superDigSpeed;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        return MItemTool.getDigSpeed(super.getDigSpeed(stack, block, meta), stack);
    }

    public static int getMaxDamage(int superDamage, ItemStack stack) {
        IPlating plating = MItemTool.getPlating(stack);
        if (plating != null) {
            return superDamage + plating.getDurability();
        }
        return superDamage;
    }

    public int getMaxDamage(ItemStack stack) {
        return MItemTool.getMaxDamage(super.getMaxDamage(stack), stack);
    }

    public static Multimap getAttributeModifiers(Multimap multimap, ItemStack stack) {
        AttributeModifier modifier;
        IPlating plating = MItemTool.getPlating(stack);
        if (plating != null) {
            modifier = new AttributeModifier(PLATING_UUID, "Plating Modifier", (double)plating.getEntityDamage(), 0);
            multimap.put((Object)"generic.attackDamage", (Object)modifier);
        }
        if (MItemTool.isHorned(stack)) {
            modifier = new AttributeModifier(HORN_UUID, "Horn Modifier", 2.0, 0);
            multimap.put((Object)"generic.attackDamage", (Object)modifier);
        }
        return multimap;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        return MItemTool.getAttributeModifiers(super.getAttributeModifiers(stack), stack);
    }

    public boolean func_77623_v() {
        return true;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A());
        ItemStack thisStack = new ItemStack((Item)this, 1, 0);
        for (Map.Entry<String, IPlating> e : IPlating.platings.entrySet()) {
            String type = e.getKey();
            IPlating plating = e.getValue();
            if (!plating.canApply(thisStack)) continue;
            StringBuilder builder = new StringBuilder(20);
            builder.append("tools/").append(type).append("_").append(this.toolType).append("_overlay");
            if (this.field_77862_b.func_77996_d() >= 5) {
                builder.append("_2");
            }
            String textureName = MAssetManager.getTexture(builder.toString());
            this.overlayIcons.put(type, iconRegister.func_94245_a(textureName));
        }
    }

    public IIcon getIcon(ItemStack stack, int renderPass) {
        IPlating plating;
        IIcon icon = null;
        if (renderPass == 1 && (plating = MItemTool.getPlating(stack)) != null) {
            icon = this.overlayIcons.get(plating.getType());
        }
        return icon == null ? this.field_77791_bV : icon;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase living) {
        if (this == MTools.soulsteelAxe || this == MTools.soulsteelPickaxe || this == MTools.soulsteelShovel) {
            world.func_72956_a((Entity)living, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityXPOrb(world, (double)x, (double)y, (double)z, 5 + world.field_73012_v.nextInt(8)));
                return true;
            }
        }
        return super.func_150894_a(stack, world, block, x, y, z, living);
    }
}

