/*
 * Decompiled with CFR 0.152.
 */
package minestrapteam.minestrappolation.nei.handler;

import clashsoft.cslib.minecraft.lang.I18n;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import minestrapteam.minestrappolation.crafting.MelterRecipes;
import minestrapteam.minestrappolation.nei.handler.MelterRecipeHandler;
import net.minecraft.item.ItemStack;

public class MelterFuelHandler
extends MelterRecipeHandler {
    private ArrayList<MelterRecipeHandler.MeltingPair> mfurnace = new ArrayList();

    public MelterFuelHandler() {
        this.loadAllSmelting();
    }

    @Override
    public String getRecipeName() {
        return I18n.getString((String)"recipe.melter_fuel");
    }

    private void loadAllSmelting() {
        Map recipes = MelterRecipes.instance.getRecipes();
        for (Map.Entry recipe : recipes.entrySet()) {
            this.mfurnace.add(new MelterRecipeHandler.MeltingPair(this, (ItemStack)recipe.getKey(), (ItemStack)recipe.getValue()));
        }
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("melter_fuel")) {
            for (MelterRecipeHandler.FuelPair fuel : afuels) {
                this.arecipes.add(new CachedFuelRecipe(fuel));
            }
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (MelterRecipeHandler.FuelPair fuel : afuels) {
            if (!fuel.stack.contains(ingredient)) continue;
            this.arecipes.add(new CachedFuelRecipe(fuel));
        }
    }

    @Override
    public String getOverlayIdentifier() {
        return "melter_fuel";
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        CachedFuelRecipe crecipe = (CachedFuelRecipe)((Object)this.arecipes.get(recipe));
        MelterRecipeHandler.FuelPair fuel = crecipe.fuel;
        float burnTime = (float)fuel.burnTime / 200.0f;
        if (gui.isMouseOver(fuel.stack, recipe) && burnTime < 1.0f) {
            String s_time = (burnTime = 1.0f / burnTime) == (float)Math.round(burnTime) ? Integer.toString((int)burnTime) : Float.toString(burnTime);
            currenttip.add(I18n.getString((String)"nei.recipe.fuel.required", (Object[])new Object[]{s_time}));
        } else if (burnTime > 1.0f && (gui.isMouseOver(crecipe.getResult(), recipe) || gui.isMouseOver(crecipe.getIngredient(), recipe))) {
            String s_time = burnTime == (float)Math.round(burnTime) ? Integer.toString((int)burnTime) : Float.toString(burnTime);
            currenttip.add(I18n.getString((String)("nei.recipe.fuel." + (gui.isMouseOver(crecipe.getResult(), recipe) ? "produced" : "processed")), (Object[])new Object[]{s_time}));
        }
        return currenttip;
    }

    public class CachedFuelRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public MelterRecipeHandler.FuelPair fuel;

        public CachedFuelRecipe(MelterRecipeHandler.FuelPair fuel) {
            super((TemplateRecipeHandler)MelterFuelHandler.this);
            this.fuel = fuel;
        }

        private MelterRecipeHandler.MeltingPair getRecipe() {
            return (MelterRecipeHandler.MeltingPair)((Object)MelterFuelHandler.this.mfurnace.get(MelterFuelHandler.this.cycleticks / 48 % MelterFuelHandler.this.mfurnace.size()));
        }

        public PositionedStack getIngredient() {
            return this.getRecipe().ingred;
        }

        public PositionedStack getResult() {
            return this.getRecipe().result;
        }

        public List<PositionedStack> getOtherStacks() {
            PositionedStack bucket;
            List list = super.getOtherStacks();
            if (this.fuel.stack != null) {
                list.add(this.fuel.stack);
            }
            if ((bucket = this.getRecipe().bucket) != null) {
                list.add(bucket);
            }
            return list;
        }
    }
}

